/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import com.licel.jcardsim.remote.BixVReaderProtocol;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Formatter;
import java.util.concurrent.TimeUnit;

public class BixVReaderTCPProtocol
implements BixVReaderProtocol {
    private Socket socket;
    private Socket eventSocket;
    private DataInputStream dataInput;
    private DataOutputStream dataOutput;
    private DataOutputStream eventOutput;

    public void connect(String host, int port, int event_port) throws IOException {
        this.socket = new Socket(host, port);
        try {
            TimeUnit.SECONDS.sleep(3L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.eventSocket = new Socket(host, event_port);
        this.dataInput = new DataInputStream(this.socket.getInputStream());
        this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
        this.eventOutput = new DataOutputStream(this.eventSocket.getOutputStream());
    }

    @Override
    public void disconnect() {
        this.closeSocket(this.socket);
        this.closeSocket(this.eventSocket);
    }

    @Override
    public int readCommand() throws IOException {
        byte[] cmdBuf = new byte[4];
        this.readFully(cmdBuf, this.dataInput);
        int cmd = this.cmdFromBytes(cmdBuf);
        return cmd;
    }

    @Override
    public byte[] readData() throws IOException {
        int dataLen = this.readCommand();
        byte[] dataBuf = new byte[dataLen];
        this.readFully(dataBuf, this.dataInput);
        return dataBuf;
    }

    @Override
    public void writeData(byte[] data) throws IOException {
        byte[] dataBuf = new byte[4 + data.length];
        byte[] dataLen = this.cmdToBytes(data.length);
        System.arraycopy(dataLen, 0, dataBuf, 0, 4);
        System.arraycopy(data, 0, dataBuf, 4, data.length);
        this.dataOutput.write(dataBuf);
    }

    @Override
    public void writeDataCommand(int cmd) throws IOException {
        this.writeCommand(this.dataOutput, cmd);
    }

    @Override
    public void writeEventCommand(int cmd) throws IOException {
        this.writeCommand(this.eventOutput, cmd);
    }

    private static String bytesToHex(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02X ", b);
        }
        return formatter.toString();
    }

    private void closeSocket(Socket sock) {
        try {
            sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int cmdFromBytes(byte[] cmd) {
        return cmd[0] & 0xFF | (cmd[1] & 0xFF) << 8 | (cmd[2] & 0xFF) << 16 | (cmd[3] & 0xFF) << 24;
    }

    private byte[] cmdToBytes(int cmd) {
        return new byte[]{(byte)cmd, (byte)(cmd >>> 8), (byte)(cmd >>> 16), (byte)(cmd >>> 24)};
    }

    private void readFully(byte[] buf, InputStream stream) throws IOException {
        int len = buf.length;
        int offset = 0;
        while (len > 0) {
            int retval = stream.read(buf, offset, len);
            if (retval < 0) {
                throw new IOException("Got negative number from socket");
            }
            len -= retval;
            offset += retval;
        }
    }

    private void writeCommand(OutputStream stream, int cmd) throws IOException {
        byte[] buf = this.cmdToBytes(cmd);
        stream.write(buf, 0, buf.length);
    }
}

