/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import com.licel.jcardsim.base.CardManager;
import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.remote.VSmartCardTCPProtocol;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Enumeration;
import java.util.Properties;

public class VSmartCard {
    Simulator sim;

    public VSmartCard(String host, int port) throws IOException {
        VSmartCardTCPProtocol driverProtocol = new VSmartCardTCPProtocol();
        driverProtocol.connect(host, port);
        this.startThread(driverProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java com.licel.jcardsim.remote.VSmartCard <jcardsim.cfg>");
            System.exit(-1);
        }
        Properties cfg = new Properties();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(args[0]);
            cfg.load(fis);
        }
        Enumeration<?> keys = cfg.propertyNames();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            System.setProperty(propertyName, cfg.getProperty(propertyName));
        }
        String propKey = "com.licel.jcardsim.vsmartcard.host";
        String host = System.getProperty(propKey);
        if (host == null) {
            throw new InvalidParameterException("Missing value for property: " + propKey);
        }
        propKey = "com.licel.jcardsim.vsmartcard.port";
        String port = System.getProperty(propKey);
        if (port == null) {
            throw new InvalidParameterException("Missing value for property: " + propKey);
        }
        new VSmartCard(host, Integer.parseInt(port));
    }

    private void startThread(VSmartCardTCPProtocol driverProtocol) throws IOException {
        this.sim = new Simulator();
        IOThread ioThread = new IOThread(this.sim, driverProtocol);
        ShutDownHook hook = new ShutDownHook(ioThread);
        Runtime.getRuntime().addShutdownHook(hook);
        ioThread.start();
    }

    static class IOThread
    extends Thread {
        VSmartCardTCPProtocol driverProtocol;
        Simulator sim;
        boolean isRunning;

        public IOThread(Simulator sim, VSmartCardTCPProtocol driverProtocol) {
            this.sim = sim;
            this.driverProtocol = driverProtocol;
            this.isRunning = true;
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    int cmd = this.driverProtocol.readCommand();
                    switch (cmd) {
                        case 1: 
                        case 2: {
                            this.sim.reset();
                            break;
                        }
                        case 4: {
                            this.driverProtocol.writeData(this.sim.getATR());
                            break;
                        }
                        case -1: {
                            byte[] apdu = this.driverProtocol.readData();
                            byte[] reply = CardManager.dispatchApdu(this.sim, apdu);
                            this.driverProtocol.writeData(reply);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    static class ShutDownHook
    extends Thread {
        IOThread ioThread;

        public ShutDownHook(IOThread ioThread) {
            this.ioThread = ioThread;
        }

        @Override
        public void run() {
            this.ioThread.isRunning = false;
            System.out.println("Shutdown connections");
            this.ioThread.driverProtocol.disconnect();
        }
    }
}

