/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.samples;

import com.licel.jcardsim.samples.BaseApplet;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.MessageDigest;
import javacardx.apdu.ExtendedLength;

public class Sha1Applet
extends BaseApplet
implements ExtendedLength {
    private static final byte CLA = -128;
    private static final byte INS_DIGEST = 0;
    private static final byte INS_ECHO = 2;
    private static final byte INS_LEN = 4;
    private static final byte INS_LAST_DIGEST = 6;
    private static final byte CLA_MASK = -16;
    private MessageDigest digest = MessageDigest.getInstance((byte)1, false);
    private byte[] lastDigest = JCSystem.makeTransientByteArray(this.digest.getLength(), (byte)2);

    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new Sha1Applet().register();
    }

    protected Sha1Applet() {
    }

    @Override
    public void process(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        short readCount = apdu.setIncomingAndReceive();
        short lc = apdu.getIncomingLength();
        short offsetCData = apdu.getOffsetCdata();
        short read = readCount;
        while (read < lc) {
            read = (short)(read + apdu.receiveBytes(read));
        }
        if (this.selectingApplet()) {
            return;
        }
        if ((buffer[0] & 0xFFFFFFF0) != -128) {
            ISOException.throwIt((short)28160);
        }
        switch (buffer[1]) {
            case 0: {
                short len = this.digest.doFinal(buffer, offsetCData, lc, this.lastDigest, (short)0);
                Util.arrayCopy(this.lastDigest, (short)0, buffer, (short)0, len);
                apdu.setOutgoingAndSend((short)0, len);
                break;
            }
            case 2: {
                apdu.setOutgoingAndSend(offsetCData, lc);
                break;
            }
            case 4: {
                short le = apdu.setOutgoing();
                apdu.setOutgoingLength((short)4);
                Util.setShort(buffer, (short)0, lc);
                Util.setShort(buffer, (short)2, le);
                apdu.sendBytes((short)0, (short)4);
                break;
            }
            case 6: {
                Util.arrayCopy(this.lastDigest, (short)0, buffer, (short)0, (short)this.lastDigest.length);
                apdu.setOutgoingAndSend((short)0, (short)this.lastDigest.length);
                break;
            }
            default: {
                ISOException.throwIt((short)27904);
            }
        }
    }
}

