/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.utils;

import com.licel.jcardsim.bouncycastle.util.encoders.Hex;
import com.licel.jcardsim.utils.ByteUtil;
import java.util.Comparator;
import javacard.framework.AID;

public final class AIDUtil {
    private static final Comparator<AID> aidComparator = new Comparator<AID>(){

        @Override
        public int compare(AID aid1, AID aid2) {
            String s1 = aid1 != null ? AIDUtil.toString(aid1) : "";
            String s2 = aid1 != null ? AIDUtil.toString(aid2) : "";
            return s1.compareTo(s2);
        }
    };

    public static byte[] select(AID aid) {
        if (aid == null) {
            throw new NullPointerException("aid");
        }
        byte[] aidBuffer = new byte[16];
        byte length = aid.getBytes(aidBuffer, (short)0);
        byte[] selectCmd = new byte[length + 5 + 1];
        selectCmd[0] = 0;
        selectCmd[1] = -92;
        selectCmd[2] = 4;
        selectCmd[3] = 0;
        selectCmd[4] = length;
        System.arraycopy(aidBuffer, 0, selectCmd, 5, length);
        selectCmd[selectCmd.length - 1] = 0;
        return selectCmd;
    }

    public static byte[] select(String aid) {
        if (aid == null) {
            throw new NullPointerException("aid");
        }
        byte[] aidBuffer = ByteUtil.byteArray(aid);
        if (aidBuffer.length > 16) {
            throw new IllegalArgumentException("AID must not be larger than 16 bytes: " + ByteUtil.hexString(aidBuffer));
        }
        byte[] selectCmd = new byte[aidBuffer.length + 5 + 1];
        selectCmd[0] = 0;
        selectCmd[1] = -92;
        selectCmd[2] = 4;
        selectCmd[3] = 0;
        selectCmd[4] = (byte)aidBuffer.length;
        System.arraycopy(aidBuffer, 0, selectCmd, 5, aidBuffer.length);
        selectCmd[selectCmd.length - 1] = 0;
        return selectCmd;
    }

    public static AID create(byte[] aidBytes) {
        if (aidBytes == null) {
            throw new NullPointerException("aidString");
        }
        if (aidBytes.length < 5 || aidBytes.length > 16) {
            throw new IllegalArgumentException("AID size must be between 5 and 16 but was " + aidBytes.length);
        }
        return new AID(aidBytes, 0, (byte)aidBytes.length);
    }

    public static AID create(String aidString) {
        if (aidString == null) {
            throw new NullPointerException("aidString");
        }
        return AIDUtil.create(Hex.decode(aidString));
    }

    public static String toString(AID aid) {
        if (aid == null) {
            throw new NullPointerException("aid");
        }
        byte[] buffer = new byte[16];
        short len = aid.getBytes(buffer, (short)0);
        return ByteUtil.hexString(buffer, 0, len);
    }

    public static Comparator<AID> comparator() {
        return aidComparator;
    }

    private AIDUtil() {
    }
}

