/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.utils;

import com.licel.jcardsim.smartcardio.JCardSimProvider;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;

public class APDUScriptTool {
    static boolean outputOn = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws FileNotFoundException, IOException, NoSuchAlgorithmException, CardException {
        if (args.length < 2) {
            System.out.println("Usage: java com.licel.jcardsim.utils.APDUScriptTool <jcardsim.cfg> <apdu script> [out file]");
            System.exit(-1);
        }
        Properties cfg = new Properties();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(args[0]);
            cfg.load(fis);
        }
        PrintStream out = args.length == 3 ? new PrintStream(args[2]) : System.out;
        fis = new FileInputStream(args[1]);
        try {
            APDUScriptTool.executeCommands(cfg, fis, out);
        }
        catch (Throwable t) {
            System.err.println("Unable to execute " + args[1] + " due to: " + t.getMessage());
            System.exit(-1);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (args.length == 3 && out != null) {
                out.close();
            }
        }
    }

    public static void executeCommands(Properties cfg, InputStream commandsStream, PrintStream out) throws IOException, ParseException, NoSuchAlgorithmException, CardException {
        Enumeration<?> keys = cfg.propertyNames();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            System.setProperty(propertyName, cfg.getProperty(propertyName));
        }
        ArrayList<CommandAPDU> commands = APDUScriptTool.parseAPDUStream(new InputStreamReader(commandsStream));
        if (Security.getProvider("jCardSim") == null) {
            JCardSimProvider provider = new JCardSimProvider();
            Security.addProvider(provider);
        }
        TerminalFactory tf = TerminalFactory.getInstance("jCardSim", null);
        CardTerminals ct = tf.terminals();
        List<CardTerminal> list = ct.list();
        CardTerminal jcsTerminal = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getName().equals("jCardSim.Terminal")) continue;
            jcsTerminal = list.get(i);
            break;
        }
        Card jcsCard = jcsTerminal.connect("T=0");
        CardChannel jcsChannel = jcsCard.getBasicChannel();
        if (commands.size() > 0) {
            for (int i = 0; i < commands.size(); ++i) {
                CommandAPDU command = commands.get(i);
                ResponseAPDU response = jcsChannel.transmit(command);
                String dump = APDUScriptTool.commandToStr(command) + APDUScriptTool.responseToStr(response);
                if (out == null) {
                    System.out.println(dump);
                    continue;
                }
                out.println(dump);
            }
        }
    }

    private static ArrayList<CommandAPDU> parseAPDUStream(InputStreamReader in) throws IOException, ParseException {
        ArrayList<CommandAPDU> apduCommands = new ArrayList<CommandAPDU>();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        StringBuilder command = new StringBuilder();
        while (line != null) {
            if ((line = line.trim()).startsWith("//") || line.isEmpty()) {
                line = br.readLine();
                continue;
            }
            if (line.indexOf(";") < 0) {
                command.append(line);
            } else {
                command.append(line.substring(0, line.indexOf(";")));
                String cmd = command.toString();
                String[] words = cmd.split("\\s+");
                if (cmd.equalsIgnoreCase("powerup") || cmd.equalsIgnoreCase("powerdown") || cmd.equalsIgnoreCase("contacted") || cmd.equalsIgnoreCase("contactless")) {
                    command = new StringBuilder();
                    command.append(line.substring(line.indexOf(";") + 1));
                    line = br.readLine();
                    continue;
                }
                if (words.length >= 6) {
                    apduCommands.add(APDUScriptTool.parseAPDUCommand(cmd));
                    command = new StringBuilder();
                    command.append(line.substring(line.indexOf(";") + 1));
                }
            }
            line = br.readLine();
        }
        return apduCommands;
    }

    private static int parseNumber(String str) {
        if (str.startsWith("0x")) {
            return Integer.parseInt(str.substring(2), 16);
        }
        return Integer.parseInt(str);
    }

    private static String toHex(int i) {
        return i > 15 ? Integer.toHexString(i) : "0" + Integer.toHexString(i);
    }

    private static CommandAPDU parseAPDUCommand(String command) throws ParseException {
        String[] bytes = command.split("\\s+");
        if (bytes.length < 6) {
            throw new ParseException("C-APDU format must be: <CLA> <INS> <P1> <P2> <LC> [<byte 0> <byte 1> ... <byte LC-1>] <LE>; " + command, 6);
        }
        int cla = APDUScriptTool.parseNumber(bytes[0]);
        int ins = APDUScriptTool.parseNumber(bytes[1]);
        int p0 = APDUScriptTool.parseNumber(bytes[2]);
        int p1 = APDUScriptTool.parseNumber(bytes[3]);
        int lc = APDUScriptTool.parseNumber(bytes[4]);
        int le = APDUScriptTool.parseNumber(bytes[bytes.length - 1]);
        if (lc + 6 > bytes.length) {
            throw new ParseException("Unexpected end of C-APDU: " + command, lc + 5);
        }
        byte[] data = new byte[lc];
        for (int i = 0; i < lc; ++i) {
            data[i] = (byte)APDUScriptTool.parseNumber(bytes[i + 5]);
        }
        return new CommandAPDU(cla, ins, p0, p1, data, le);
    }

    private static String commandToStr(CommandAPDU command) {
        StringBuilder sb = new StringBuilder();
        sb.append("CLA: ").append(APDUScriptTool.toHex(command.getCLA())).append(", ");
        sb.append("INS: ").append(APDUScriptTool.toHex(command.getINS())).append(", ");
        sb.append("P1: ").append(APDUScriptTool.toHex(command.getP1())).append(", ");
        sb.append("P2: ").append(APDUScriptTool.toHex(command.getP2())).append(", ");
        sb.append("Lc: ").append(APDUScriptTool.toHex(command.getNc())).append(", ");
        byte[] data = command.getData();
        for (int i = 0; i < command.getNc(); ++i) {
            sb.append(APDUScriptTool.toHex(data[i] & 0xFF)).append(", ");
        }
        return sb.toString();
    }

    private static String responseToStr(ResponseAPDU response) {
        StringBuilder sb = new StringBuilder();
        sb.append("Le: ").append(APDUScriptTool.toHex(response.getNr())).append(", ");
        byte[] data = response.getData();
        for (int i = 0; i < data.length; ++i) {
            sb.append(APDUScriptTool.toHex(data[i] & 0xFF)).append(", ");
        }
        sb.append("SW1: ").append(APDUScriptTool.toHex(response.getSW1())).append(", ");
        sb.append("SW2: ").append(APDUScriptTool.toHex(response.getSW2()));
        return sb.toString();
    }
}

