/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class JavaCardApiProcessor {
    public static void main(String[] args) throws Exception {
        File buildDir = new File(args[0]);
        if (!buildDir.exists() || !buildDir.isDirectory()) {
            throw new RuntimeException("Invalid directory: " + buildDir);
        }
        HashMap<String, String> allMap = new HashMap<String, String>();
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.framework.AIDProxy", "javacard.framework.AID", false);
        allMap.put("com.licel.jcardsim.framework.APDUProxy".replace(".", "/"), "javacard.framework.APDU".replace(".", "/"));
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.framework.APDUProxy", "javacard.framework.APDU", false);
        JavaCardApiProcessor.copyClass(buildDir, "com.licel.jcardsim.framework.APDUProxy$1", "javacard.framework.APDU$1", allMap);
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.APDUException");
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.framework.AppletProxy", "javacard.framework.Applet", false);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.framework.CardExceptionProxy", "javacard.framework.CardException", false);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.framework.CardRuntimeExceptionProxy", "javacard.framework.CardRuntimeException", false);
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.ISOException");
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.framework.JCSystemProxy", "javacard.framework.JCSystem", false);
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.PINException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.SystemException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.TransactionException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.UserException");
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.framework.UtilProxy", "javacard.framework.Util", false);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.framework.OwnerPINProxy", "javacard.framework.OwnerPIN", false);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.crypto.ChecksumProxy", "javacard.security.Checksum", true);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.crypto.CipherProxy", "javacardx.crypto.Cipher", true);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.crypto.KeyAgreementProxy", "javacard.security.KeyAgreement", true);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.crypto.KeyPairProxy", "javacard.security.KeyPair", false);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.crypto.KeyBuilderProxy", "javacard.security.KeyBuilder", true);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.crypto.MessageDigestProxy", "javacard.security.MessageDigest", true);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.crypto.RandomDataProxy", "javacard.security.RandomData", true);
        JavaCardApiProcessor.proxyClass(buildDir, "com.licel.jcardsim.crypto.SignatureProxy", "javacard.security.Signature", true);
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.framework.service.ServiceException");
        JavaCardApiProcessor.proxyExceptionClass(buildDir, "javacard.security.CryptoException");
    }

    public static void proxyClass(File buildDir, String proxyClassFile, String targetClassFile, boolean skipConstructor) throws IOException {
        File proxyFile = new File(buildDir, proxyClassFile.replace(".", File.separator) + ".class");
        FileInputStream fProxyClass = new FileInputStream(proxyFile);
        FileInputStream fTargetClass = new FileInputStream(new File(buildDir, targetClassFile.replace(".", File.separator) + ".class"));
        ClassReader crProxy = new ClassReader((InputStream)fProxyClass);
        ClassNode cnProxy = new ClassNode();
        crProxy.accept((ClassVisitor)cnProxy, 0);
        ClassReader crTarget = new ClassReader((InputStream)fTargetClass);
        ClassNode cnTarget = new ClassNode();
        crTarget.accept((ClassVisitor)cnTarget, 0);
        ClassNode cnProxyRemapped = new ClassNode();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(cnProxy.name, cnTarget.name);
        for (int i = 0; i < 10; ++i) {
            map.put(cnProxy.name + "$1", cnTarget.name + "$1");
        }
        ClassRemapper ra = new ClassRemapper((ClassVisitor)cnProxyRemapped, (Remapper)new SimpleRemapper(map));
        cnProxy.accept((ClassVisitor)ra);
        ClassWriter cw = new ClassWriter(crTarget, 2);
        MergeAdapter ma = new MergeAdapter((ClassVisitor)cw, cnProxyRemapped, skipConstructor);
        cnTarget.accept((ClassVisitor)ma);
        fProxyClass.close();
        fTargetClass.close();
        FileOutputStream fos = new FileOutputStream(new File(buildDir, targetClassFile.replace(".", File.separator) + ".class"));
        fos.write(cw.toByteArray());
        fos.close();
        proxyFile.delete();
    }

    public static void copyClass(File buildDir, String proxyClassFile, String targetClassName, Map map) throws IOException {
        File sourceFile = new File(buildDir, proxyClassFile.replace(".", File.separator) + ".class");
        FileInputStream fProxyClass = new FileInputStream(sourceFile);
        ClassReader crProxy = new ClassReader((InputStream)fProxyClass);
        ClassNode cnProxy = new ClassNode();
        crProxy.accept((ClassVisitor)cnProxy, 0);
        ClassWriter cw = new ClassWriter(2);
        map.put(cnProxy.name, targetClassName.replace(".", "/"));
        ClassRemapper ra = new ClassRemapper((ClassVisitor)cw, (Remapper)new SimpleRemapper(map));
        cnProxy.accept((ClassVisitor)ra);
        fProxyClass.close();
        FileOutputStream fos = new FileOutputStream(new File(buildDir, targetClassName.replace(".", File.separator) + ".class"));
        fos.write(cw.toByteArray());
        fos.close();
        sourceFile.delete();
    }

    public static void proxyExceptionClass(File buildDir, String targetClassName) throws IOException {
        FileInputStream fTargetClass = new FileInputStream(new File(buildDir, targetClassName.replace(".", File.separator) + ".class"));
        ClassReader crTarget = new ClassReader((InputStream)fTargetClass);
        ClassNode cnTarget = new ClassNode();
        crTarget.accept((ClassVisitor)cnTarget, 0);
        ClassWriter cw = new ClassWriter(2);
        ExceptionClassProxy ecc = new ExceptionClassProxy(cw, cnTarget.version, cnTarget.name, cnTarget.superName);
        cnTarget.accept((ClassVisitor)ecc);
        fTargetClass.close();
        FileOutputStream fos = new FileOutputStream(new File(buildDir, targetClassName.replace(".", File.separator) + ".class"));
        fos.write(cw.toByteArray());
        fos.close();
    }

    static class MergeAdapter
    extends ClassAdapter {
        private ClassNode cn;
        private String cname;
        private HashMap<String, MethodNode> cnMethods = new HashMap();
        private HashMap<String, FieldNode> cnFields = new HashMap();
        private boolean skipConstructor;

        public MergeAdapter(ClassVisitor cv, ClassNode cn, boolean skipConstructor) {
            super(cv);
            this.cn = cn;
            this.skipConstructor = skipConstructor;
            for (MethodNode mn : cn.methods) {
                if (skipConstructor && mn.name.equals("<init>")) continue;
                this.cnMethods.put(mn.name + mn.desc, mn);
            }
            for (FieldNode fn : cn.fields) {
                this.cnFields.put(fn.name + fn.desc, fn);
            }
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.cname = name;
            System.out.println(" .. " + name);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.cnMethods.containsKey(name + desc) || (access & 5) == 0) {
                System.out.println("skip method: " + this.cname + name + desc);
                return null;
            }
            System.out.println("Use original:" + this.cname + name + desc);
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 1) != 1) {
                System.out.println("skip field: " + this.cname + name + desc);
                return null;
            }
            System.out.println("Use original:" + this.cname + name + desc);
            return super.visitField(access, name, desc, signature, value);
        }

        public void visitSource(String file, String debug) {
            System.out.println(String.format("src: %s: %s", file, debug));
            super.visitSource(file, debug);
        }

        public void visitOuterClass(String owner, String name, String desc) {
            System.out.println(String.format("ocks: %s: %s %s", owner, name, desc));
            super.visitOuterClass(owner, name, desc);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            System.out.println(String.format("anot: %s", desc));
            return super.visitAnnotation(desc, visible);
        }

        public void check(int api) {
            super.check(api);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            for (FieldNode fn : this.cn.fields) {
                this.cv.visitField(fn.access, fn.name, fn.desc, fn.signature, fn.value);
            }
            for (MethodNode mn : this.cn.methods) {
                if (this.skipConstructor && mn.name.equals("<init>")) continue;
                String[] exceptions = new String[mn.exceptions.size()];
                mn.exceptions.toArray(exceptions);
                MethodVisitor mv = this.cv.visitMethod(mn.access, mn.name, mn.desc, mn.signature, exceptions);
                mn.instructions.resetLabels();
                System.out.println(String.format("v: %s: %s.%s%s, %d %d", this.cn.sourceFile, this.cn.name, mn.name, mn.desc, mn.maxStack, mn.maxLocals));
                try {
                    mn.accept(mv);
                }
                catch (Exception e) {
                    System.out.println(String.format(" - Ex: %s", e));
                    throw e;
                }
            }
        }
    }

    static class ExceptionClassProxy
    extends ClassVisitor
    implements Opcodes {
        String superClassName;
        String className;

        public ExceptionClassProxy(ClassWriter cv, int classVersion, String exceptionClassName, String superClassName) {
            super(262144, (ClassVisitor)cv);
            this.superClassName = superClassName;
            this.className = exceptionClassName;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 1) != 1) {
                return null;
            }
            return super.visitField(access, name, desc, signature, value);
        }

        public void visitEnd() {
            MethodVisitor mv = this.cv.visitMethod(1, "<init>", "(S)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(21, 1);
            mv.visitMethodInsn(183, this.superClassName, "<init>", "(S)V", false);
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            mv = this.cv.visitMethod(9, "throwIt", "(S)V", null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, this.className);
            mv.visitInsn(89);
            mv.visitVarInsn(21, 0);
            mv.visitMethodInsn(183, this.className, "<init>", "(S)V", false);
            mv.visitInsn(191);
            mv.visitMaxs(3, 1);
            mv.visitEnd();
        }
    }

    static class ClassAdapter
    extends ClassNode
    implements Opcodes {
        public ClassAdapter(ClassVisitor cv) {
            super(262144);
            this.cv = cv;
        }

        public void visitEnd() {
            this.accept(this.cv);
        }
    }
}

