/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.utils;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PomProcessor {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("Build directory is required");
        }
        File buildDir = new File(args[0]);
        if (!buildDir.exists() || !buildDir.isDirectory()) {
            throw new RuntimeException("Invalid directory: " + buildDir);
        }
        File depPom = new File(buildDir, "dependency-reduced-pom.xml");
        if (!depPom.exists()) {
            System.err.println("POM not found: " + depPom.getAbsolutePath());
            return;
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(depPom);
            PomProcessor.deleteRedundantDeps(doc);
            doc.getDocumentElement().normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(depPom);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            System.out.println("pom.xml updated successfully");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private static void deleteRedundantDeps(Document doc) {
        NodeList projects = doc.getElementsByTagName("project");
        if (projects.getLength() < 1) {
            System.err.println("Invalid number of project elements");
            return;
        }
        Node project = projects.item(0);
        if (project.getNodeType() != 1) {
            System.err.println("Invalid project node type");
            return;
        }
        Element elProject = (Element)project;
        NodeList dependencies = elProject.getElementsByTagName("dependencies");
        if (dependencies.getLength() < 1) {
            System.err.println("Invalid num of dependencies");
            return;
        }
        boolean found = false;
        int depIdx = 0;
        for (depIdx = 0; depIdx < dependencies.getLength(); ++depIdx) {
            if (dependencies.item(depIdx).getParentNode() != elProject) continue;
            found = true;
            break;
        }
        if (!found) {
            System.err.println("Project.dependencies not found");
            return;
        }
        Node nDeps = dependencies.item(depIdx);
        if (nDeps.getNodeType() != 1) {
            System.err.println("Invalid dependencies node type");
            return;
        }
        Element elDeps = (Element)nDeps;
        NodeList depsNodeList = elDeps.getElementsByTagName("dependency");
        if (depsNodeList.getLength() < 1) {
            System.err.println("No deps found");
            return;
        }
        System.out.println(String.format("Number of dependencies found: %d", depsNodeList.getLength()));
        int i = 0;
        while (i < depsNodeList.getLength()) {
            Node alChild;
            Element elDep = (Element)depsNodeList.item(i);
            NodeList nArtifacts = elDep.getElementsByTagName("artifactId");
            NodeList nGroupId = elDep.getElementsByTagName("groupId");
            String artifactId = null;
            String groupId = null;
            if (nArtifacts.getLength() > 0) {
                Element elArtifact = (Element)nArtifacts.item(0);
                alChild = elArtifact.getFirstChild();
                String string = artifactId = alChild.getNodeType() == 3 ? alChild.getNodeValue() : null;
            }
            if (nGroupId.getLength() > 0) {
                Element elGroupId = (Element)nGroupId.item(0);
                alChild = elGroupId.getFirstChild();
                groupId = alChild.getNodeType() == 3 ? alChild.getNodeValue() : null;
            }
            System.out.println(String.format("Dependency: %s:%s", groupId, artifactId));
            if ("api_classic".equalsIgnoreCase(artifactId)) {
                System.out.println("oracle.javacard:api_classic found in dependencies, removing");
                elDeps.removeChild(elDep);
                continue;
            }
            if ("org.ow2.asm".equalsIgnoreCase(groupId)) {
                System.out.println("org.ow2.asm:* found in dependencies, removing");
                elDeps.removeChild(elDep);
                continue;
            }
            ++i;
        }
    }
}

