/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.licel.jcardsim.base.SimulatorSystem;
import java.lang.reflect.Field;
import javacard.framework.AID;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.security.MessageDigest;

public final class JCSystem {
    public static final byte MEMORY_TYPE_PERSISTENT = 0;
    public static final byte MEMORY_TYPE_TRANSIENT_RESET = 1;
    public static final byte MEMORY_TYPE_TRANSIENT_DESELECT = 2;
    public static final byte ARRAY_TYPE_BOOLEAN = 1;
    public static final byte ARRAY_TYPE_BYTE = 2;
    public static final byte ARRAY_TYPE_SHORT = 3;
    public static final byte ARRAY_TYPE_INT = 4;
    public static final byte ARRAY_TYPE_OBJECT = 5;
    public static final byte NOT_A_TRANSIENT_OBJECT = 0;
    public static final byte CLEAR_ON_RESET = 1;
    public static final byte CLEAR_ON_DESELECT = 2;
    private static final short API_VERSION;

    public static Object makeGlobalArray(byte by, short s) {
        return null;
    }

    public static void getAvailableMemory(short[] sArray, short s, byte by) throws SystemException {
    }

    public static byte isTransient(Object theObj) {
        return SimulatorSystem.instance().getTransientMemory().isTransient(theObj);
    }

    public static boolean[] makeTransientBooleanArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.instance().getTransientMemory().makeBooleanArray(length, event);
    }

    public static byte[] makeTransientByteArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.instance().getTransientMemory().makeByteArray(length, event);
    }

    public static short[] makeTransientShortArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.instance().getTransientMemory().makeShortArray(length, event);
    }

    public static Object[] makeTransientObjectArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.instance().getTransientMemory().makeObjectArray(length, event);
    }

    public static short getVersion() {
        return API_VERSION;
    }

    public static AID getAID() {
        return SimulatorSystem.instance().getAID();
    }

    public static AID lookupAID(byte[] buffer, short offset, byte length) {
        return SimulatorSystem.instance().lookupAID(buffer, offset, length);
    }

    public static void beginTransaction() throws TransactionException {
        SimulatorSystem.instance().beginTransaction();
    }

    public static void abortTransaction() throws TransactionException {
        SimulatorSystem.instance().abortTransaction();
    }

    public static void commitTransaction() throws TransactionException {
        SimulatorSystem.instance().commitTransaction();
    }

    public static byte getTransactionDepth() {
        return SimulatorSystem.instance().getTransactionDepth();
    }

    public static short getUnusedCommitCapacity() {
        return SimulatorSystem.instance().getUnusedCommitCapacity();
    }

    public static short getMaxCommitCapacity() {
        return SimulatorSystem.instance().getMaxCommitCapacity();
    }

    public static AID getPreviousContextAID() {
        return SimulatorSystem.instance().getPreviousContextAID();
    }

    public static short getAvailableMemory(byte memoryType) throws SystemException {
        switch (memoryType) {
            case 0: {
                return SimulatorSystem.instance().getAvailablePersistentMemory();
            }
            case 1: {
                return SimulatorSystem.instance().getAvailableTransientResetMemory();
            }
            case 2: {
                return SimulatorSystem.instance().getAvailableTransientDeselectMemory();
            }
        }
        SystemException.throwIt((short)1);
        return 0;
    }

    public static Shareable getAppletShareableInterfaceObject(AID serverAID, byte parameter) {
        return SimulatorSystem.instance().getSharedObject(serverAID, parameter);
    }

    public static boolean isObjectDeletionSupported() {
        return SimulatorSystem.instance().isObjectDeletionSupported();
    }

    public static void requestObjectDeletion() throws SystemException {
        SimulatorSystem.instance().requestObjectDeletion();
    }

    public static byte getAssignedChannel() {
        return SimulatorSystem.instance().getAssignedChannel();
    }

    public static boolean isAppletActive(AID theApplet) {
        return theApplet == SimulatorSystem.instance().getAID();
    }

    static {
        int detectedVersion;
        try {
            Field f = MessageDigest.class.getDeclaredField("ALG_SHA_224");
            detectedVersion = 768;
        }
        catch (Exception ex) {
            detectedVersion = 514;
        }
        API_VERSION = (short)detectedVersion;
    }
}

