/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil;

import com.android.mms.dom.smil.TimeImpl;
import com.android.mms.dom.smil.TimeListImpl;
import com.klinker.android.logger.Log;
import java.util.ArrayList;
import org.w3c.dom.DOMException;
import org.w3c.dom.smil.ElementTime;
import org.w3c.dom.smil.SMILElement;
import org.w3c.dom.smil.Time;
import org.w3c.dom.smil.TimeList;

public abstract class ElementTimeImpl
implements ElementTime {
    private static final String TAG = "ElementTimeImpl";
    private static final String FILL_REMOVE_ATTRIBUTE = "remove";
    private static final String FILL_FREEZE_ATTRIBUTE = "freeze";
    private static final String FILL_HOLD_ATTRIBUTE = "hold";
    private static final String FILL_TRANSITION_ATTRIBUTE = "transition";
    private static final String FILL_AUTO_ATTRIBUTE = "auto";
    private static final String FILL_ATTRIBUTE_NAME = "fill";
    private static final String FILLDEFAULT_ATTRIBUTE_NAME = "fillDefault";
    final SMILElement mSmilElement;

    ElementTimeImpl(SMILElement element) {
        this.mSmilElement = element;
    }

    int getBeginConstraints() {
        return 255;
    }

    int getEndConstraints() {
        return 255;
    }

    abstract ElementTime getParentElementTime();

    @Override
    public TimeList getBegin() {
        String[] beginTimeStringList = this.mSmilElement.getAttribute("begin").split(";");
        ArrayList<Time> beginTimeList = new ArrayList<Time>();
        for (int i = 0; i < beginTimeStringList.length; ++i) {
            try {
                beginTimeList.add(new TimeImpl(beginTimeStringList[i], this.getBeginConstraints()));
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (beginTimeList.size() == 0) {
            beginTimeList.add(new TimeImpl("0", 255));
        }
        return new TimeListImpl(beginTimeList);
    }

    @Override
    public float getDur() {
        float dur = 0.0f;
        try {
            String durString = this.mSmilElement.getAttribute("dur");
            if (durString != null) {
                dur = TimeImpl.parseClockValue(durString) / 1000.0f;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return dur;
    }

    @Override
    public TimeList getEnd() {
        ArrayList<Time> endTimeList = new ArrayList<Time>();
        String[] endTimeStringList = this.mSmilElement.getAttribute("end").split(";");
        int len = endTimeStringList.length;
        if (len != 1 || endTimeStringList[0].length() != 0) {
            for (int i = 0; i < len; ++i) {
                try {
                    endTimeList.add(new TimeImpl(endTimeStringList[i], this.getEndConstraints()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Log.e((String)TAG, (String)"Malformed time value.", (Throwable)e);
                }
            }
        }
        if (endTimeList.size() == 0) {
            float duration = this.getDur();
            if (duration < 0.0f) {
                endTimeList.add(new TimeImpl("indefinite", this.getEndConstraints()));
            } else {
                TimeList begin = this.getBegin();
                for (int i = 0; i < begin.getLength(); ++i) {
                    endTimeList.add(new TimeImpl(begin.item(i).getResolvedOffset() + (double)duration + "s", this.getEndConstraints()));
                }
            }
        }
        return new TimeListImpl(endTimeList);
    }

    private boolean beginAndEndAreZero() {
        TimeList begin = this.getBegin();
        TimeList end = this.getEnd();
        if (begin.getLength() == 1 && end.getLength() == 1) {
            Time beginTime = begin.item(0);
            Time endTime = end.item(0);
            return beginTime.getOffset() == 0.0 && endTime.getOffset() == 0.0;
        }
        return false;
    }

    @Override
    public short getFill() {
        short fillDefault;
        String fill = this.mSmilElement.getAttribute(FILL_ATTRIBUTE_NAME);
        if (fill.equalsIgnoreCase(FILL_FREEZE_ATTRIBUTE)) {
            return 1;
        }
        if (fill.equalsIgnoreCase(FILL_REMOVE_ATTRIBUTE)) {
            return 0;
        }
        if (fill.equalsIgnoreCase(FILL_HOLD_ATTRIBUTE)) {
            return 1;
        }
        if (fill.equalsIgnoreCase(FILL_TRANSITION_ATTRIBUTE)) {
            return 1;
        }
        if (!fill.equalsIgnoreCase(FILL_AUTO_ATTRIBUTE) && (fillDefault = this.getFillDefault()) != 2) {
            return fillDefault;
        }
        if (this.mSmilElement.getAttribute("dur").length() == 0 && this.mSmilElement.getAttribute("end").length() == 0 && this.mSmilElement.getAttribute("repeatCount").length() == 0 && this.mSmilElement.getAttribute("repeatDur").length() == 0 || this.beginAndEndAreZero()) {
            return 1;
        }
        return 0;
    }

    @Override
    public short getFillDefault() {
        String fillDefault = this.mSmilElement.getAttribute(FILLDEFAULT_ATTRIBUTE_NAME);
        if (fillDefault.equalsIgnoreCase(FILL_REMOVE_ATTRIBUTE)) {
            return 0;
        }
        if (fillDefault.equalsIgnoreCase(FILL_FREEZE_ATTRIBUTE)) {
            return 1;
        }
        if (fillDefault.equalsIgnoreCase(FILL_AUTO_ATTRIBUTE)) {
            return 2;
        }
        if (fillDefault.equalsIgnoreCase(FILL_HOLD_ATTRIBUTE)) {
            return 1;
        }
        if (fillDefault.equalsIgnoreCase(FILL_TRANSITION_ATTRIBUTE)) {
            return 1;
        }
        ElementTime parent = this.getParentElementTime();
        if (parent == null) {
            return 2;
        }
        return ((ElementTimeImpl)parent).getFillDefault();
    }

    @Override
    public float getRepeatCount() {
        String repeatCount = this.mSmilElement.getAttribute("repeatCount");
        try {
            float value = Float.parseFloat(repeatCount);
            if (value > 0.0f) {
                return value;
            }
            return 0.0f;
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    @Override
    public float getRepeatDur() {
        try {
            float repeatDur = TimeImpl.parseClockValue(this.mSmilElement.getAttribute("repeatDur"));
            if (repeatDur > 0.0f) {
                return repeatDur;
            }
            return 0.0f;
        }
        catch (IllegalArgumentException e) {
            return 0.0f;
        }
    }

    @Override
    public short getRestart() {
        String restart = this.mSmilElement.getAttribute("restart");
        if (restart.equalsIgnoreCase("never")) {
            return 1;
        }
        if (restart.equalsIgnoreCase("whenNotActive")) {
            return 2;
        }
        return 0;
    }

    @Override
    public void setBegin(TimeList begin) throws DOMException {
        this.mSmilElement.setAttribute("begin", "indefinite");
    }

    @Override
    public void setDur(float dur) throws DOMException {
        this.mSmilElement.setAttribute("dur", Integer.toString((int)(dur * 1000.0f)) + "ms");
    }

    @Override
    public void setEnd(TimeList end) throws DOMException {
        this.mSmilElement.setAttribute("end", "indefinite");
    }

    @Override
    public void setFill(short fill) throws DOMException {
        if (fill == 1) {
            this.mSmilElement.setAttribute(FILL_ATTRIBUTE_NAME, FILL_FREEZE_ATTRIBUTE);
        } else {
            this.mSmilElement.setAttribute(FILL_ATTRIBUTE_NAME, FILL_REMOVE_ATTRIBUTE);
        }
    }

    @Override
    public void setFillDefault(short fillDefault) throws DOMException {
        if (fillDefault == 1) {
            this.mSmilElement.setAttribute(FILLDEFAULT_ATTRIBUTE_NAME, FILL_FREEZE_ATTRIBUTE);
        } else {
            this.mSmilElement.setAttribute(FILLDEFAULT_ATTRIBUTE_NAME, FILL_REMOVE_ATTRIBUTE);
        }
    }

    @Override
    public void setRepeatCount(float repeatCount) throws DOMException {
        String repeatCountString = "indefinite";
        if (repeatCount > 0.0f) {
            repeatCountString = Float.toString(repeatCount);
        }
        this.mSmilElement.setAttribute("repeatCount", repeatCountString);
    }

    @Override
    public void setRepeatDur(float repeatDur) throws DOMException {
        String repeatDurString = "indefinite";
        if (repeatDur > 0.0f) {
            repeatDurString = Float.toString(repeatDur) + "ms";
        }
        this.mSmilElement.setAttribute("repeatDur", repeatDurString);
    }

    @Override
    public void setRestart(short restart) throws DOMException {
        if (restart == 1) {
            this.mSmilElement.setAttribute("restart", "never");
        } else if (restart == 2) {
            this.mSmilElement.setAttribute("restart", "whenNotActive");
        } else {
            this.mSmilElement.setAttribute("restart", "always");
        }
    }
}

