/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.IntentService;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.telephony.SmsMessage;
import com.klinker.android.logger.Log;

public class MessageStatusService
extends IntentService {
    private static final String[] ID_PROJECTION = new String[]{"_id"};
    private static final String LOG_TAG = "MessageStatusReceiver";
    private static final Uri STATUS_URI = Uri.parse((String)"content://sms/status");

    public MessageStatusService() {
        super(MessageStatusService.class.getName());
        this.setIntentRedelivery(true);
    }

    protected void onHandleIntent(Intent intent) {
        Uri messageUri = intent.getData();
        byte[] pdu = intent.getByteArrayExtra("pdu");
        String format = intent.getStringExtra("format");
        SmsMessage message = this.updateMessageStatus((Context)this, messageUri, pdu, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmsMessage updateMessageStatus(Context context, Uri messageUri, byte[] pdu, String format) {
        SmsMessage message = SmsMessage.createFromPdu((byte[])pdu);
        if (message == null) {
            return null;
        }
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), messageUri, ID_PROJECTION, null, null, null);
        try {
            if (cursor.moveToFirst()) {
                int messageId = cursor.getInt(0);
                Uri updateUri = ContentUris.withAppendedId((Uri)STATUS_URI, (long)messageId);
                int status = message.getStatus();
                boolean isStatusReport = message.isStatusReportMessage();
                ContentValues contentValues = new ContentValues(2);
                this.log("updateMessageStatus: msgUrl=" + messageUri + ", status=" + status + ", isStatusReport=" + isStatusReport);
                contentValues.put("status", Integer.valueOf(status));
                contentValues.put("date_sent", Long.valueOf(System.currentTimeMillis()));
                SqliteWrapper.update(context, context.getContentResolver(), updateUri, contentValues, null, null);
            } else {
                this.error("Can't find message for status update: " + messageUri);
            }
        }
        finally {
            cursor.close();
        }
        return message;
    }

    private void error(String message) {
        Log.e((String)LOG_TAG, (String)("[MessageStatusReceiver] " + message));
    }

    private void log(String message) {
        Log.d((String)LOG_TAG, (String)("[MessageStatusReceiver] " + message));
    }
}

