/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import com.android.mms.transaction.TransactionService;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Utils;
import java.lang.reflect.Method;

public class MmsSystemEventReceiver
extends BroadcastReceiver {
    private static final String TAG = "MmsSystemEventReceiver";
    private static ConnectivityManager mConnMgr = null;

    public static void wakeUpService(Context context) {
        Log.v((String)TAG, (String)"wakeUpService: start transaction service ...");
        context.startService(new Intent(context, TransactionService.class));
    }

    public void onReceive(Context context, Intent intent) {
        Log.v((String)TAG, (String)("Intent received: " + intent));
        if (!Utils.isDefaultSmsApp(context)) {
            return;
        }
        String action = intent.getAction();
        if (action.equals("android.intent.action.CONTENT_CHANGED")) {
            Uri changed = (Uri)intent.getParcelableExtra("deleted_contents");
        } else if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            if (mConnMgr == null) {
                mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
            }
            boolean mobileDataEnabled = false;
            try {
                Class<?> cmClass = Class.forName(mConnMgr.getClass().getName());
                Method method = cmClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
                method.setAccessible(true);
                mobileDataEnabled = (Boolean)method.invoke((Object)mConnMgr, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!mobileDataEnabled) {
                Log.v((String)TAG, (String)"mobile data turned off, bailing");
                return;
            }
            NetworkInfo mmsNetworkInfo = mConnMgr.getNetworkInfo(2);
            boolean available = mmsNetworkInfo.isAvailable();
            boolean isConnected = mmsNetworkInfo.isConnected();
            Log.v((String)TAG, (String)("TYPE_MOBILE_MMS available = " + available + ", isConnected = " + isConnected));
            if (available && !isConnected) {
                MmsSystemEventReceiver.wakeUpService(context);
            }
        } else if (action.equals("android.intent.action.BOOT_COMPLETED")) {
            MmsSystemEventReceiver.wakeUpService(context);
        }
    }
}

