/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import com.android.mms.transaction.Observer;
import com.android.mms.transaction.TransactionState;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Observable {
    private final ArrayList<Observer> mObservers = new ArrayList();
    private Iterator<Observer> mIterator;

    public abstract TransactionState getState();

    public void attach(Observer observer) {
        this.mObservers.add(observer);
    }

    public void detach(Observer observer) {
        if (this.mIterator != null) {
            this.mIterator.remove();
        } else {
            this.mObservers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers() {
        this.mIterator = this.mObservers.iterator();
        try {
            while (this.mIterator.hasNext()) {
                this.mIterator.next().update(this);
            }
        }
        finally {
            this.mIterator = null;
        }
    }
}

