/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Looper;
import android.provider.Telephony;
import com.android.mms.transaction.DefaultRetryScheme;
import com.android.mms.transaction.NotificationTransaction;
import com.android.mms.transaction.Observable;
import com.android.mms.transaction.Observer;
import com.android.mms.transaction.ReadRecTransaction;
import com.android.mms.transaction.RetrieveTransaction;
import com.android.mms.transaction.SendTransaction;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionService;
import com.android.mms.transaction.TransactionState;
import com.android.mms.util.DownloadManager;
import com.google.android.mms.pdu_alt.PduPersister;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.R;

public class RetryScheduler
implements Observer {
    private static final String TAG = "RetryScheduler";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private static RetryScheduler sInstance;

    private RetryScheduler(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
    }

    public static RetryScheduler getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new RetryScheduler(context);
        }
        return sInstance;
    }

    private boolean isConnected() {
        ConnectivityManager mConnMgr = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo ni = mConnMgr.getNetworkInfo(2);
        return ni == null ? false : ni.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable) {
        block8: {
            try {
                Transaction t = (Transaction)observable;
                Log.v((String)TAG, (String)("[RetryScheduler] update " + observable));
                if (!(t instanceof NotificationTransaction) && !(t instanceof RetrieveTransaction) && !(t instanceof ReadRecTransaction) && !(t instanceof SendTransaction)) break block8;
                try {
                    Uri uri;
                    TransactionState state = t.getState();
                    if (state.getState() == 2 && (uri = state.getContentUri()) != null) {
                        this.scheduleRetry(uri);
                    }
                }
                finally {
                    t.detach(this);
                }
            }
            finally {
                if (this.isConnected()) {
                    RetryScheduler.setRetryAlarm(this.mContext);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRetry(Uri uri) {
        block28: {
            long msgId = ContentUris.parseId((Uri)uri);
            Uri.Builder uriBuilder = Telephony.MmsSms.PendingMessages.CONTENT_URI.buildUpon();
            uriBuilder.appendQueryParameter("protocol", "mms");
            uriBuilder.appendQueryParameter("message", String.valueOf(msgId));
            Cursor cursor = SqliteWrapper.query(this.mContext, this.mContentResolver, uriBuilder.build(), null, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() != 1 || !cursor.moveToFirst()) break block28;
                    int msgType = cursor.getInt(cursor.getColumnIndexOrThrow("msg_type"));
                    int retryIndex = cursor.getInt(cursor.getColumnIndexOrThrow("retry_index")) + 1;
                    int errorType = 1;
                    DefaultRetryScheme scheme = new DefaultRetryScheme(this.mContext, retryIndex);
                    ContentValues values = new ContentValues(4);
                    long current = System.currentTimeMillis();
                    boolean isRetryDownloading = msgType == 130;
                    boolean retry = true;
                    int respStatus = this.getResponseStatus(msgId);
                    int errorString = 0;
                    if (!isRetryDownloading) {
                        switch (respStatus) {
                            case 132: {
                                errorString = R.string.invalid_destination;
                                break;
                            }
                            case 130: 
                            case 225: {
                                errorString = R.string.service_not_activated;
                                break;
                            }
                            case 134: {
                                errorString = R.string.service_network_problem;
                                break;
                            }
                            case 194: 
                            case 228: {
                                errorString = R.string.service_message_not_found;
                            }
                        }
                        if (errorString != 0) {
                            DownloadManager.getInstance().showErrorCodeToast(errorString);
                            retry = false;
                        }
                    } else {
                        respStatus = this.getRetrieveStatus(msgId);
                        if (respStatus == 228) {
                            DownloadManager.getInstance().showErrorCodeToast(R.string.service_message_not_found);
                            SqliteWrapper.delete(this.mContext, this.mContext.getContentResolver(), uri, null, null);
                            retry = false;
                            return;
                        }
                    }
                    if (retryIndex < scheme.getRetryLimit() && retry) {
                        long retryAt = current + scheme.getWaitingInterval();
                        Log.v((String)TAG, (String)("scheduleRetry: retry for " + uri + " is scheduled at " + (retryAt - System.currentTimeMillis()) + "ms from now"));
                        values.put("due_time", Long.valueOf(retryAt));
                        if (isRetryDownloading) {
                            try {
                                Looper.prepare();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            DownloadManager.init(this.mContext);
                            DownloadManager.getInstance().markState(uri, 130);
                        }
                    } else {
                        errorType = 10;
                        if (isRetryDownloading) {
                            Cursor c = SqliteWrapper.query(this.mContext, this.mContext.getContentResolver(), uri, new String[]{"thread_id"}, null, null, null);
                            long threadId = -1L;
                            if (c != null) {
                                try {
                                    if (c.moveToFirst()) {
                                        threadId = c.getLong(0);
                                    }
                                }
                                finally {
                                    c.close();
                                }
                            }
                            if (threadId != -1L) {
                                this.markMmsFailed(this.mContext);
                            }
                            DownloadManager.getInstance().markState(uri, 135);
                        } else {
                            ContentValues readValues = new ContentValues(1);
                            readValues.put("read", Integer.valueOf(0));
                            SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), uri, readValues, null, null);
                            this.markMmsFailed(this.mContext);
                        }
                    }
                    values.put("err_type", Integer.valueOf(errorType));
                    values.put("retry_index", Integer.valueOf(retryIndex));
                    values.put("last_try", Long.valueOf(current));
                    int columnIndex = cursor.getColumnIndexOrThrow("_id");
                    long id = cursor.getLong(columnIndex);
                    SqliteWrapper.update(this.mContext, this.mContentResolver, Uri.withAppendedPath((Uri)Uri.parse((String)"content://mms-sms/"), (String)"pending"), values, "_id=" + id, null);
                }
                finally {
                    cursor.close();
                }
            }
        }
    }

    private void markMmsFailed(Context context) {
        Cursor query = context.getContentResolver().query(Uri.parse((String)"content://mms"), new String[]{"_id"}, null, null, "date desc");
        query.moveToFirst();
        String id = query.getString(query.getColumnIndex("_id"));
        query.close();
        ContentValues values = new ContentValues();
        values.put("msg_box", Integer.valueOf(5));
        String where = "_id = '" + id + "'";
        context.getContentResolver().update(Uri.parse((String)"content://mms"), values, where, null);
        context.sendBroadcast(new Intent("com.klinker.android.send_message.REFRESH"));
        context.sendBroadcast(new Intent(com.klinker.android.send_message.Transaction.NOTIFY_SMS_FAILURE));
        context.sendBroadcast(new Intent("com.klinker.android.send_message.MMS_ERROR"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getResponseStatus(long msgID) {
        int respStatus = 0;
        Cursor cursor = SqliteWrapper.query(this.mContext, this.mContentResolver, Uri.parse((String)"content://mms/outbox"), null, "_id=" + msgID, null, null);
        try {
            if (cursor.moveToFirst()) {
                respStatus = cursor.getInt(cursor.getColumnIndexOrThrow("resp_st"));
            }
        }
        finally {
            cursor.close();
        }
        if (respStatus != 0) {
            Log.e((String)TAG, (String)("Response status is: " + respStatus));
        }
        return respStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRetrieveStatus(long msgID) {
        int retrieveStatus = 0;
        Cursor cursor = SqliteWrapper.query(this.mContext, this.mContentResolver, Uri.parse((String)"content://mms/inbox"), null, "_id=" + msgID, null, null);
        try {
            if (cursor.moveToFirst()) {
                retrieveStatus = cursor.getInt(cursor.getColumnIndexOrThrow("resp_st"));
            }
        }
        finally {
            cursor.close();
        }
        if (retrieveStatus != 0) {
            Log.v((String)TAG, (String)("Retrieve status is: " + retrieveStatus));
        }
        return retrieveStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRetryAlarm(Context context) {
        Cursor cursor = PduPersister.getPduPersister(context).getPendingMessages(Long.MAX_VALUE);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    long retryAt = cursor.getLong(cursor.getColumnIndexOrThrow("due_time"));
                    Intent service = new Intent("android.intent.action.ACTION_ONALARM", null, context, TransactionService.class);
                    PendingIntent operation = PendingIntent.getService((Context)context, (int)0, (Intent)service, (int)0x40000000);
                    AlarmManager am = (AlarmManager)context.getSystemService("alarm");
                    am.set(1, retryAt, operation);
                    Log.v((String)TAG, (String)("Next retry is scheduled at" + (retryAt - System.currentTimeMillis()) + "ms from now"));
                }
            }
            finally {
                cursor.close();
            }
        }
    }
}

