/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.Context;
import com.android.mms.transaction.HttpUtils;
import com.android.mms.transaction.Observable;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.transaction.TransactionState;
import com.google.android.mms.MmsException;
import com.klinker.android.send_message.Utils;
import java.io.IOException;

public abstract class Transaction
extends Observable {
    private final int mServiceId;
    protected Context mContext;
    protected String mId;
    protected TransactionState mTransactionState;
    protected TransactionSettings mTransactionSettings;
    public static final int NOTIFICATION_TRANSACTION = 0;
    public static final int RETRIEVE_TRANSACTION = 1;
    public static final int SEND_TRANSACTION = 2;
    public static final int READREC_TRANSACTION = 3;

    public Transaction(Context context, int serviceId, TransactionSettings settings) {
        this.mContext = context;
        this.mTransactionState = new TransactionState();
        this.mServiceId = serviceId;
        this.mTransactionSettings = settings;
    }

    @Override
    public TransactionState getState() {
        return this.mTransactionState;
    }

    public abstract void process();

    public boolean isEquivalent(Transaction transaction) {
        return this.mId.equals(transaction.mId);
    }

    public int getServiceId() {
        return this.mServiceId;
    }

    public TransactionSettings getConnectionSettings() {
        return this.mTransactionSettings;
    }

    public void setConnectionSettings(TransactionSettings settings) {
        this.mTransactionSettings = settings;
    }

    protected byte[] sendPdu(byte[] pdu) throws IOException, MmsException {
        return this.sendPdu(-1L, pdu, this.mTransactionSettings.getMmscUrl());
    }

    protected byte[] sendPdu(byte[] pdu, String mmscUrl) throws IOException, MmsException {
        return this.sendPdu(-1L, pdu, mmscUrl);
    }

    protected byte[] sendPdu(long token, byte[] pdu) throws IOException, MmsException {
        return this.sendPdu(token, pdu, this.mTransactionSettings.getMmscUrl());
    }

    protected byte[] sendPdu(long token, byte[] pdu, String mmscUrl) throws IOException, MmsException {
        if (pdu == null) {
            throw new MmsException();
        }
        Utils.ensureRouteToHost(this.mContext, mmscUrl, this.mTransactionSettings.getProxyAddress());
        return HttpUtils.httpConnection(this.mContext, token, mmscUrl, pdu, 1, this.mTransactionSettings.isProxySet(), this.mTransactionSettings.getProxyAddress(), this.mTransactionSettings.getProxyPort());
    }

    protected byte[] getPdu(String url) throws IOException {
        Utils.ensureRouteToHost(this.mContext, url, this.mTransactionSettings.getProxyAddress());
        return HttpUtils.httpConnection(this.mContext, -1L, url, null, 2, this.mTransactionSettings.isProxySet(), this.mTransactionSettings.getProxyAddress(), this.mTransactionSettings.getProxyPort());
    }

    public String toString() {
        return this.getClass().getName() + ": serviceId=" + this.mServiceId;
    }

    public abstract int getType();
}

