/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.Context;
import android.net.NetworkUtils;
import android.text.TextUtils;
import com.android.mms.MmsConfig;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Transaction;
import com.klinker.android.send_message.Utils;

public class TransactionSettings {
    private static final String TAG = "TransactionSettings";
    private static final boolean DEBUG = true;
    private static final boolean LOCAL_LOGV = false;
    private String mServiceCenter;
    private String mProxyAddress;
    private int mProxyPort = -1;
    private String mUserAgent;
    private String mUserAgentProfileUrl;
    private static final String[] APN_PROJECTION = new String[]{"type", "mmsc", "mmsproxy", "mmsport"};
    private static final int COLUMN_TYPE = 0;
    private static final int COLUMN_MMSC = 1;
    private static final int COLUMN_MMSPROXY = 2;
    private static final int COLUMN_MMSPORT = 3;

    public TransactionSettings(Context context, String apnName) {
        String uaProfTagName;
        String uaProfUrl;
        Log.v((String)TAG, (String)("TransactionSettings: apnName: " + apnName));
        if (Transaction.settings == null) {
            Transaction.settings = Utils.getDefaultSendSettings(context);
        }
        this.mServiceCenter = NetworkUtils.trimV4AddrZeros(Transaction.settings.getMmsc());
        this.mProxyAddress = NetworkUtils.trimV4AddrZeros(Transaction.settings.getProxy());
        String agent = Transaction.settings.getAgent();
        if (agent != null && !agent.trim().equals("")) {
            MmsConfig.setUserAgent(agent);
            Log.v((String)TAG, (String)"set user agent");
        }
        if ((uaProfUrl = Transaction.settings.getUserProfileUrl()) != null && !uaProfUrl.trim().equals("")) {
            MmsConfig.setUaProfUrl(uaProfUrl);
            Log.v((String)TAG, (String)"set user agent profile url");
        }
        if ((uaProfTagName = Transaction.settings.getUaProfTagName()) != null && !uaProfTagName.trim().equals("")) {
            MmsConfig.setUaProfTagName(uaProfTagName);
            Log.v((String)TAG, (String)"set user agent profile tag name");
        }
        if (this.isProxySet()) {
            this.mProxyPort = Integer.parseInt(Transaction.settings.getPort());
        }
    }

    public TransactionSettings(String mmscUrl, String proxyAddr, int proxyPort) {
        this.mServiceCenter = mmscUrl != null ? mmscUrl.trim() : null;
        this.mProxyAddress = proxyAddr;
        this.mProxyPort = proxyPort;
        Log.v((String)TAG, (String)("TransactionSettings: " + this.mServiceCenter + " proxyAddress: " + this.mProxyAddress + " proxyPort: " + this.mProxyPort));
    }

    public String getMmscUrl() {
        return this.mServiceCenter;
    }

    public String getProxyAddress() {
        return this.mProxyAddress;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public boolean isProxySet() {
        return this.mProxyAddress != null && this.mProxyAddress.trim().length() != 0;
    }

    private static boolean isValidApnType(String types, String requestType) {
        if (TextUtils.isEmpty((CharSequence)types)) {
            return true;
        }
        for (String t : types.split(",")) {
            if (!t.equals(requestType) && !t.equals("*")) continue;
            return true;
        }
        return false;
    }
}

