/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.graphics.Bitmap;
import com.klinker.android.logger.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class Message {
    private String text;
    private String subject;
    private String[] addresses;
    private Bitmap[] images;
    private String[] imageNames;
    private byte[] media;
    private String mediaMimeType;
    private boolean save;
    private int type;
    private int delay;
    public static final int TYPE_SMSMMS = 0;
    public static final int TYPE_VOICE = 1;

    public Message() {
        this("", new String[]{""});
    }

    public Message(String text, String address) {
        this(text, address.trim().split(" "));
    }

    public Message(String text, String address, String subject) {
        this(text, address.trim().split(" "), subject);
    }

    public Message(String text, String[] addresses) {
        this.text = text;
        this.addresses = addresses;
        this.images = new Bitmap[0];
        this.subject = null;
        this.media = new byte[0];
        this.mediaMimeType = null;
        this.save = true;
        this.type = 0;
        this.delay = 0;
    }

    public Message(String text, String[] addresses, String subject) {
        this.text = text;
        this.addresses = addresses;
        this.images = new Bitmap[0];
        this.subject = subject;
        this.media = new byte[0];
        this.mediaMimeType = null;
        this.save = true;
        this.type = 0;
        this.delay = 0;
    }

    public Message(String text, String address, Bitmap image) {
        this(text, address.trim().split(" "), new Bitmap[]{image});
    }

    public Message(String text, String address, Bitmap image, String subject) {
        this(text, address.trim().split(" "), new Bitmap[]{image}, subject);
    }

    public Message(String text, String[] addresses, Bitmap image) {
        this(text, addresses, new Bitmap[]{image});
    }

    public Message(String text, String[] addresses, Bitmap image, String subject) {
        this(text, addresses, new Bitmap[]{image}, subject);
    }

    public Message(String text, String address, Bitmap[] images) {
        this(text, address.trim().split(" "), images);
    }

    public Message(String text, String address, Bitmap[] images, String subject) {
        this(text, address.trim().split(" "), images, subject);
    }

    public Message(String text, String[] addresses, Bitmap[] images) {
        this.text = text;
        this.addresses = addresses;
        this.images = images;
        this.subject = null;
        this.media = new byte[0];
        this.mediaMimeType = null;
        this.save = true;
        this.type = 0;
        this.delay = 0;
    }

    public Message(String text, String[] addresses, Bitmap[] images, String subject) {
        this.text = text;
        this.addresses = addresses;
        this.images = images;
        this.subject = subject;
        this.media = new byte[0];
        this.mediaMimeType = null;
        this.save = true;
        this.type = 0;
        this.delay = 0;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public void setAddress(String address) {
        this.addresses = new String[1];
        this.addresses[0] = address;
    }

    public void setImages(Bitmap[] images) {
        this.images = images;
    }

    public void setImageNames(String[] names) {
        this.imageNames = names;
    }

    public void setImage(Bitmap image) {
        this.images = new Bitmap[1];
        this.images[0] = image;
    }

    public void setAudio(byte[] audio) {
        this.media = audio;
        this.mediaMimeType = "audio/wav";
    }

    public void setVideo(byte[] video) {
        this.media = video;
        this.mediaMimeType = "video/3gpp";
    }

    public void setMedia(byte[] media, String mimeType) {
        this.media = media;
        this.mediaMimeType = mimeType;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setSave(boolean save) {
        this.save = save;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void addAddress(String address) {
        String[] temp = this.addresses;
        if (temp == null) {
            temp = new String[]{};
        }
        this.addresses = new String[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            this.addresses[i] = temp[i];
        }
        this.addresses[temp.length] = address;
    }

    public void addImage(Bitmap image) {
        Bitmap[] temp = this.images;
        if (temp == null) {
            temp = new Bitmap[]{};
        }
        this.images = new Bitmap[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            this.images[i] = temp[i];
        }
        this.images[temp.length] = image;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public Bitmap[] getImages() {
        return this.images;
    }

    public String[] getImageNames() {
        return this.imageNames;
    }

    public byte[] getMedia() {
        return this.media;
    }

    public String getMediaMimeType() {
        return this.mediaMimeType;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean getSave() {
        return this.save;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getType() {
        return this.type;
    }

    public static byte[] bitmapToByteArray(Bitmap image) {
        if (image == null) {
            Log.v((String)"Message", (String)"image is null, returning byte array of size 0");
            return new byte[0];
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)stream);
        return stream.toByteArray();
    }
}

