/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import com.klinker.android.logger.Log;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

public class RouteInfo
implements Parcelable {
    private static final String TAG = "RouteInfo";
    private final LinkAddress mDestination;
    private final InetAddress mGateway;
    private final boolean mIsDefault;
    private final boolean mIsHost;
    public static final Parcelable.Creator<RouteInfo> CREATOR = new Parcelable.Creator<RouteInfo>(){

        public RouteInfo createFromParcel(Parcel in) {
            byte[] addr;
            InetAddress destAddr = null;
            int prefix = 0;
            InetAddress gateway = null;
            if (in.readByte() == 1) {
                addr = in.createByteArray();
                prefix = in.readInt();
                try {
                    destAddr = InetAddress.getByAddress(addr);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            if (in.readByte() == 1) {
                addr = in.createByteArray();
                try {
                    gateway = InetAddress.getByAddress(addr);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            LinkAddress dest = null;
            if (destAddr != null) {
                dest = new LinkAddress(destAddr, prefix);
            }
            return new RouteInfo(dest, gateway);
        }

        public RouteInfo[] newArray(int size) {
            return new RouteInfo[size];
        }
    };

    public RouteInfo(LinkAddress destination, InetAddress gateway) {
        if (destination == null) {
            if (gateway != null) {
                if (gateway instanceof Inet4Address) {
                    try {
                        destination = new LinkAddress(Inet4Address.getLocalHost(), 0);
                    }
                    catch (UnknownHostException e) {
                        Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
                    }
                } else {
                    try {
                        destination = new LinkAddress(Inet6Address.getLocalHost(), 0);
                    }
                    catch (UnknownHostException e) {
                        Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
                    }
                }
            } else {
                throw new RuntimeException("Invalid arguments passed in.");
            }
        }
        if (gateway == null) {
            if (destination.getAddress() instanceof Inet4Address) {
                try {
                    gateway = Inet4Address.getLocalHost();
                }
                catch (UnknownHostException e) {
                    Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
                }
            } else {
                try {
                    gateway = Inet6Address.getLocalHost();
                }
                catch (UnknownHostException e) {
                    Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
                }
            }
        }
        this.mDestination = new LinkAddress(NetworkUtils.getNetworkPart(destination.getAddress(), destination.getNetworkPrefixLength()), destination.getNetworkPrefixLength());
        this.mGateway = gateway;
        this.mIsDefault = this.isDefault();
        this.mIsHost = this.isHost();
    }

    public RouteInfo(InetAddress gateway) {
        this(null, gateway);
    }

    public static RouteInfo makeHostRoute(InetAddress host) {
        return RouteInfo.makeHostRoute(host, null);
    }

    public static RouteInfo makeHostRoute(InetAddress host, InetAddress gateway) {
        if (host == null) {
            return null;
        }
        if (host instanceof Inet4Address) {
            return new RouteInfo(new LinkAddress(host, 32), gateway);
        }
        return new RouteInfo(new LinkAddress(host, 128), gateway);
    }

    private boolean isHost() {
        try {
            return this.mGateway.equals(Inet4Address.getLocalHost()) || this.mGateway.equals(Inet6Address.getLocalHost());
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private boolean isDefault() {
        boolean val = false;
        if (this.mGateway != null) {
            val = this.mGateway instanceof Inet4Address ? this.mDestination == null || this.mDestination.getNetworkPrefixLength() == 0 : this.mDestination == null || this.mDestination.getNetworkPrefixLength() == 0;
        }
        return val;
    }

    public LinkAddress getDestination() {
        return this.mDestination;
    }

    public InetAddress getGateway() {
        return this.mGateway;
    }

    public boolean isDefaultRoute() {
        return this.mIsDefault;
    }

    public boolean isHostRoute() {
        return this.mIsHost;
    }

    public String toString() {
        String val = "";
        if (this.mDestination != null) {
            val = this.mDestination.toString();
        }
        if (this.mGateway != null) {
            val = val + " -> " + this.mGateway.getHostAddress();
        }
        return val;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.mDestination == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mDestination.getAddress().getAddress());
            dest.writeInt(this.mDestination.getNetworkPrefixLength());
        }
        if (this.mGateway == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mGateway.getAddress());
        }
    }

    public boolean equals(Object obj) {
        boolean sameDestination;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RouteInfo)) {
            return false;
        }
        RouteInfo target = (RouteInfo)obj;
        boolean bl = this.mDestination == null ? target.getDestination() == null : (sameDestination = this.mDestination.equals(target.getDestination()));
        boolean sameAddress = this.mGateway == null ? target.getGateway() == null : this.mGateway.equals(target.getGateway());
        return sameDestination && sameAddress && this.mIsDefault == target.mIsDefault;
    }

    public int hashCode() {
        return (this.mDestination == null ? 0 : this.mDestination.hashCode()) + (this.mGateway == null ? 0 : this.mGateway.hashCode()) + (this.mIsDefault ? 3 : 7);
    }

    private boolean matches(InetAddress destination) {
        if (destination == null) {
            return false;
        }
        if (this.isDefault()) {
            return true;
        }
        InetAddress dstNet = NetworkUtils.getNetworkPart(destination, this.mDestination.getNetworkPrefixLength());
        return this.mDestination.getAddress().equals(dstNet);
    }

    public static RouteInfo selectBestRoute(Collection<RouteInfo> routes, InetAddress dest) {
        if (routes == null || dest == null) {
            return null;
        }
        RouteInfo bestRoute = null;
        for (RouteInfo route : routes) {
            if (!NetworkUtils.addressTypeMatches(route.mDestination.getAddress(), dest) || bestRoute != null && bestRoute.mDestination.getNetworkPrefixLength() >= route.mDestination.getNetworkPrefixLength() || !route.matches(dest)) continue;
            bestRoute = route;
        }
        return bestRoute;
    }
}

