/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.events;

import com.android.mms.dom.events.EventImpl;
import com.klinker.android.logger.Log;
import java.util.ArrayList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class EventTargetImpl
implements EventTarget {
    private static final String TAG = "EventTargetImpl";
    private ArrayList<EventListenerEntry> mListenerEntries;
    private EventTarget mNodeTarget;

    public EventTargetImpl(EventTarget target) {
        this.mNodeTarget = target;
    }

    @Override
    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        if (type == null || type.equals("") || listener == null) {
            return;
        }
        this.removeEventListener(type, listener, useCapture);
        if (this.mListenerEntries == null) {
            this.mListenerEntries = new ArrayList();
        }
        this.mListenerEntries.add(new EventListenerEntry(type, listener, useCapture));
    }

    @Override
    public boolean dispatchEvent(Event evt) throws EventException {
        EventImpl eventImpl = (EventImpl)evt;
        if (!eventImpl.isInitialized()) {
            throw new EventException(0, "Event not initialized");
        }
        if (eventImpl.getType() == null || eventImpl.getType().equals("")) {
            throw new EventException(0, "Unspecified even type");
        }
        eventImpl.setTarget(this.mNodeTarget);
        eventImpl.setEventPhase((short)2);
        eventImpl.setCurrentTarget(this.mNodeTarget);
        if (!eventImpl.isPropogationStopped() && this.mListenerEntries != null) {
            for (int i = 0; i < this.mListenerEntries.size(); ++i) {
                EventListenerEntry listenerEntry = this.mListenerEntries.get(i);
                if (listenerEntry.mUseCapture || !listenerEntry.mType.equals(eventImpl.getType())) continue;
                try {
                    listenerEntry.mListener.handleEvent(eventImpl);
                    continue;
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"Catched EventListener exception", (Throwable)e);
                }
            }
        }
        if (eventImpl.getBubbles()) {
            // empty if block
        }
        return eventImpl.isPreventDefault();
    }

    @Override
    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        if (null == this.mListenerEntries) {
            return;
        }
        for (int i = 0; i < this.mListenerEntries.size(); ++i) {
            EventListenerEntry listenerEntry = this.mListenerEntries.get(i);
            if (listenerEntry.mUseCapture != useCapture || listenerEntry.mListener != listener || !listenerEntry.mType.equals(type)) continue;
            this.mListenerEntries.remove(i);
            break;
        }
    }

    static class EventListenerEntry {
        final String mType;
        final EventListener mListener;
        final boolean mUseCapture;

        EventListenerEntry(String type, EventListener listener, boolean useCapture) {
            this.mType = type;
            this.mListener = listener;
            this.mUseCapture = useCapture;
        }
    }
}

