/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil;

import com.android.mms.dom.smil.SmilParElementImpl;
import com.klinker.android.logger.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.smil.ElementParallelTimeContainer;
import org.w3c.dom.smil.ElementSequentialTimeContainer;
import org.w3c.dom.smil.ElementTime;
import org.w3c.dom.smil.Time;
import org.w3c.dom.smil.TimeList;

public class SmilPlayer
implements Runnable {
    private static final String TAG = "Mms/smil";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int TIMESLICE = 200;
    public static final String MEDIA_TIME_UPDATED_EVENT = "mediaTimeUpdated";
    private static final Comparator<TimelineEntry> sTimelineEntryComparator = new Comparator<TimelineEntry>(){

        @Override
        public int compare(TimelineEntry o1, TimelineEntry o2) {
            return Double.compare(o1.getOffsetTime(), o2.getOffsetTime());
        }
    };
    private static SmilPlayer sPlayer;
    private long mCurrentTime;
    private int mCurrentElement;
    private int mCurrentSlide;
    private ArrayList<TimelineEntry> mAllEntries;
    private ElementTime mRoot;
    private Thread mPlayerThread;
    private SmilPlayerState mState = SmilPlayerState.INITIALIZED;
    private SmilPlayerAction mAction = SmilPlayerAction.NO_ACTIVE_ACTION;
    private ArrayList<ElementTime> mActiveElements;
    private Event mMediaTimeUpdatedEvent;

    private static ArrayList<TimelineEntry> getParTimeline(ElementParallelTimeContainer par, double offset, double maxOffset) {
        ArrayList<TimelineEntry> timeline = new ArrayList<TimelineEntry>();
        TimeList myBeginList = par.getBegin();
        Time begin = myBeginList.item(0);
        double beginOffset = begin.getResolvedOffset() + offset;
        if (beginOffset > maxOffset) {
            return timeline;
        }
        TimelineEntry myBegin = new TimelineEntry(beginOffset, par, 0);
        timeline.add(myBegin);
        TimeList myEndList = par.getEnd();
        Time end = myEndList.item(0);
        double endOffset = end.getResolvedOffset() + offset;
        if (endOffset > maxOffset) {
            endOffset = maxOffset;
        }
        TimelineEntry myEnd = new TimelineEntry(endOffset, par, 1);
        maxOffset = endOffset;
        NodeList children = par.getTimeChildren();
        for (int i = 0; i < children.getLength(); ++i) {
            ElementTime child = (ElementTime)((Object)children.item(i));
            ArrayList<TimelineEntry> childTimeline = SmilPlayer.getTimeline(child, offset, maxOffset);
            timeline.addAll(childTimeline);
        }
        Collections.sort(timeline, sTimelineEntryComparator);
        NodeList activeChildrenAtEnd = par.getActiveChildrenAt((float)(endOffset - offset) * 1000.0f);
        for (int i = 0; i < activeChildrenAtEnd.getLength(); ++i) {
            timeline.add(new TimelineEntry(endOffset, (ElementTime)((Object)activeChildrenAtEnd.item(i)), 1));
        }
        timeline.add(myEnd);
        return timeline;
    }

    private static ArrayList<TimelineEntry> getSeqTimeline(ElementSequentialTimeContainer seq, double offset, double maxOffset) {
        ArrayList<TimelineEntry> timeline = new ArrayList<TimelineEntry>();
        double orgOffset = offset;
        TimeList myBeginList = seq.getBegin();
        Time begin = myBeginList.item(0);
        double beginOffset = begin.getResolvedOffset() + offset;
        if (beginOffset > maxOffset) {
            return timeline;
        }
        TimelineEntry myBegin = new TimelineEntry(beginOffset, seq, 0);
        timeline.add(myBegin);
        TimeList myEndList = seq.getEnd();
        Time end = myEndList.item(0);
        double endOffset = end.getResolvedOffset() + offset;
        if (endOffset > maxOffset) {
            endOffset = maxOffset;
        }
        TimelineEntry myEnd = new TimelineEntry(endOffset, seq, 1);
        maxOffset = endOffset;
        NodeList children = seq.getTimeChildren();
        for (int i = 0; i < children.getLength(); ++i) {
            ElementTime child = (ElementTime)((Object)children.item(i));
            ArrayList<TimelineEntry> childTimeline = SmilPlayer.getTimeline(child, offset, maxOffset);
            timeline.addAll(childTimeline);
            offset = childTimeline.get(childTimeline.size() - 1).getOffsetTime();
        }
        NodeList activeChildrenAtEnd = seq.getActiveChildrenAt((float)(endOffset - orgOffset));
        for (int i = 0; i < activeChildrenAtEnd.getLength(); ++i) {
            timeline.add(new TimelineEntry(endOffset, (ElementTime)((Object)activeChildrenAtEnd.item(i)), 1));
        }
        timeline.add(myEnd);
        return timeline;
    }

    private static ArrayList<TimelineEntry> getTimeline(ElementTime element, double offset, double maxOffset) {
        if (element instanceof ElementParallelTimeContainer) {
            return SmilPlayer.getParTimeline((ElementParallelTimeContainer)element, offset, maxOffset);
        }
        if (element instanceof ElementSequentialTimeContainer) {
            return SmilPlayer.getSeqTimeline((ElementSequentialTimeContainer)element, offset, maxOffset);
        }
        ArrayList<TimelineEntry> timeline = new ArrayList<TimelineEntry>();
        TimeList beginList = element.getBegin();
        for (int i = 0; i < beginList.getLength(); ++i) {
            double beginOffset;
            Time begin = beginList.item(i);
            if (!begin.getResolved() || !((beginOffset = begin.getResolvedOffset() + offset) <= maxOffset)) continue;
            TimelineEntry entry = new TimelineEntry(beginOffset, element, 0);
            timeline.add(entry);
        }
        TimeList endList = element.getEnd();
        for (int i = 0; i < endList.getLength(); ++i) {
            double endOffset;
            Time end = endList.item(i);
            if (!end.getResolved() || !((endOffset = end.getResolvedOffset() + offset) <= maxOffset)) continue;
            TimelineEntry entry = new TimelineEntry(endOffset, element, 1);
            timeline.add(entry);
        }
        Collections.sort(timeline, sTimelineEntryComparator);
        return timeline;
    }

    private SmilPlayer() {
    }

    public static SmilPlayer getPlayer() {
        if (sPlayer == null) {
            sPlayer = new SmilPlayer();
        }
        return sPlayer;
    }

    public synchronized boolean isPlayingState() {
        return this.mState == SmilPlayerState.PLAYING;
    }

    public synchronized boolean isPlayedState() {
        return this.mState == SmilPlayerState.PLAYED;
    }

    public synchronized boolean isPausedState() {
        return this.mState == SmilPlayerState.PAUSED;
    }

    public synchronized boolean isStoppedState() {
        return this.mState == SmilPlayerState.STOPPED;
    }

    private synchronized boolean isPauseAction() {
        return this.mAction == SmilPlayerAction.PAUSE;
    }

    private synchronized boolean isStartAction() {
        return this.mAction == SmilPlayerAction.START;
    }

    private synchronized boolean isStopAction() {
        return this.mAction == SmilPlayerAction.STOP;
    }

    private synchronized boolean isReloadAction() {
        return this.mAction == SmilPlayerAction.RELOAD;
    }

    private synchronized boolean isNextAction() {
        return this.mAction == SmilPlayerAction.NEXT;
    }

    private synchronized boolean isPrevAction() {
        return this.mAction == SmilPlayerAction.PREV;
    }

    public synchronized void init(ElementTime root) {
        this.mRoot = root;
        this.mAllEntries = SmilPlayer.getTimeline(this.mRoot, 0.0, 9.223372036854776E18);
        this.mMediaTimeUpdatedEvent = ((DocumentEvent)((Object)this.mRoot)).createEvent("Event");
        this.mMediaTimeUpdatedEvent.initEvent(MEDIA_TIME_UPDATED_EVENT, false, false);
        this.mActiveElements = new ArrayList();
    }

    public synchronized void play() {
        if (!this.isPlayingState()) {
            this.mCurrentTime = 0L;
            this.mCurrentElement = 0;
            this.mCurrentSlide = 0;
            this.mPlayerThread = new Thread((Runnable)this, "SmilPlayer thread");
            this.mState = SmilPlayerState.PLAYING;
            this.mPlayerThread.start();
        } else {
            Log.w((String)TAG, (String)"Error State: Playback is playing!");
        }
    }

    public synchronized void pause() {
        if (this.isPlayingState()) {
            this.mAction = SmilPlayerAction.PAUSE;
            this.notifyAll();
        } else {
            Log.w((String)TAG, (String)"Error State: Playback is not playing!");
        }
    }

    public synchronized void start() {
        if (this.isPausedState()) {
            this.resumeActiveElements();
            this.mAction = SmilPlayerAction.START;
            this.notifyAll();
        } else if (this.isPlayedState()) {
            this.play();
        } else {
            Log.w((String)TAG, (String)"Error State: Playback can not be started!");
        }
    }

    public synchronized void stop() {
        if (this.isPlayingState() || this.isPausedState()) {
            this.mAction = SmilPlayerAction.STOP;
            this.notifyAll();
        } else if (this.isPlayedState()) {
            this.actionStop();
        }
    }

    public synchronized void stopWhenReload() {
        this.endActiveElements();
    }

    public synchronized void reload() {
        if (this.isPlayingState() || this.isPausedState()) {
            this.mAction = SmilPlayerAction.RELOAD;
            this.notifyAll();
        } else if (this.isPlayedState()) {
            this.actionReload();
        }
    }

    public synchronized void next() {
        if (this.isPlayingState() || this.isPausedState()) {
            this.mAction = SmilPlayerAction.NEXT;
            this.notifyAll();
        }
    }

    public synchronized void prev() {
        if (this.isPlayingState() || this.isPausedState()) {
            this.mAction = SmilPlayerAction.PREV;
            this.notifyAll();
        }
    }

    private synchronized boolean isBeginOfSlide(TimelineEntry entry) {
        return 0 == entry.getAction() && entry.getElement() instanceof SmilParElementImpl;
    }

    private synchronized void reloadActiveSlide() {
        this.mActiveElements.clear();
        this.beginSmilDocument();
        for (int i = this.mCurrentSlide; i < this.mCurrentElement; ++i) {
            TimelineEntry entry = this.mAllEntries.get(i);
            this.actionEntry(entry);
        }
        this.seekActiveMedia();
    }

    private synchronized void beginSmilDocument() {
        TimelineEntry entry = this.mAllEntries.get(0);
        this.actionEntry(entry);
    }

    private synchronized double getOffsetTime(ElementTime element) {
        for (int i = this.mCurrentSlide; i < this.mCurrentElement; ++i) {
            TimelineEntry entry = this.mAllEntries.get(i);
            if (!element.equals(entry.getElement())) continue;
            return entry.getOffsetTime() * 1000.0;
        }
        return -1.0;
    }

    private synchronized void seekActiveMedia() {
        for (int i = this.mActiveElements.size() - 1; i >= 0; --i) {
            ElementTime element = this.mActiveElements.get(i);
            if (element instanceof SmilParElementImpl) {
                return;
            }
            double offset = this.getOffsetTime(element);
            if (!(offset >= 0.0) || !(offset <= (double)this.mCurrentTime)) continue;
            element.seekElement((float)((double)this.mCurrentTime - offset));
        }
    }

    private synchronized void waitForEntry(long interval) throws InterruptedException {
        long overhead = 0L;
        while (interval > 0L) {
            long startAt = System.currentTimeMillis();
            long sleep = Math.min(interval, 200L);
            if (overhead < sleep) {
                this.wait(sleep - overhead);
                this.mCurrentTime += sleep;
            } else {
                sleep = 0L;
                this.mCurrentTime += overhead;
            }
            if (this.isStopAction() || this.isReloadAction() || this.isPauseAction() || this.isNextAction() || this.isPrevAction()) {
                return;
            }
            ((EventTarget)((Object)this.mRoot)).dispatchEvent(this.mMediaTimeUpdatedEvent);
            interval -= 200L;
            overhead = System.currentTimeMillis() - startAt - sleep;
        }
    }

    public synchronized int getDuration() {
        if (this.mAllEntries != null && !this.mAllEntries.isEmpty()) {
            return (int)this.mAllEntries.get(this.mAllEntries.size() - 1).mOffsetTime * 1000;
        }
        return 0;
    }

    public synchronized int getCurrentPosition() {
        return (int)this.mCurrentTime;
    }

    private synchronized void endActiveElements() {
        for (int i = this.mActiveElements.size() - 1; i >= 0; --i) {
            ElementTime element = this.mActiveElements.get(i);
            element.endElement();
        }
    }

    private synchronized void pauseActiveElements() {
        for (int i = this.mActiveElements.size() - 1; i >= 0; --i) {
            ElementTime element = this.mActiveElements.get(i);
            element.pauseElement();
        }
    }

    private synchronized void resumeActiveElements() {
        int size = this.mActiveElements.size();
        for (int i = 0; i < size; ++i) {
            ElementTime element = this.mActiveElements.get(i);
            element.resumeElement();
        }
    }

    private synchronized void waitForWakeUp() {
        try {
            while (!(this.isStartAction() || this.isStopAction() || this.isReloadAction() || this.isNextAction() || this.isPrevAction())) {
                this.wait(200L);
            }
            if (this.isStartAction()) {
                this.mAction = SmilPlayerAction.NO_ACTIVE_ACTION;
                this.mState = SmilPlayerState.PLAYING;
            }
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)"Unexpected InterruptedException.", (Throwable)e);
        }
    }

    private synchronized void actionEntry(TimelineEntry entry) {
        switch (entry.getAction()) {
            case 0: {
                entry.getElement().beginElement();
                this.mActiveElements.add(entry.getElement());
                break;
            }
            case 1: {
                entry.getElement().endElement();
                this.mActiveElements.remove(entry.getElement());
                break;
            }
        }
    }

    private synchronized TimelineEntry reloadCurrentEntry() {
        if (this.mCurrentElement < this.mAllEntries.size()) {
            return this.mAllEntries.get(this.mCurrentElement);
        }
        return null;
    }

    private void stopCurrentSlide() {
        HashSet<TimelineEntry> skippedEntries = new HashSet<TimelineEntry>();
        int totalEntries = this.mAllEntries.size();
        for (int i = this.mCurrentElement; i < totalEntries; ++i) {
            TimelineEntry entry = this.mAllEntries.get(i);
            int action = entry.getAction();
            if (entry.getElement() instanceof SmilParElementImpl && action == 1) {
                this.actionEntry(entry);
                this.mCurrentElement = i;
                break;
            }
            if (action == 1 && !skippedEntries.contains(entry)) {
                this.actionEntry(entry);
                continue;
            }
            if (action != 0) continue;
            skippedEntries.add(entry);
        }
    }

    private TimelineEntry loadNextSlide() {
        TimelineEntry entry;
        int totalEntries = this.mAllEntries.size();
        for (int i = this.mCurrentElement; i < totalEntries; ++i) {
            entry = this.mAllEntries.get(i);
            if (!this.isBeginOfSlide(entry)) continue;
            this.mCurrentElement = i;
            this.mCurrentSlide = i;
            this.mCurrentTime = (long)(entry.getOffsetTime() * 1000.0);
            return entry;
        }
        ++this.mCurrentElement;
        entry = null;
        if (this.mCurrentElement < totalEntries) {
            entry = this.mAllEntries.get(this.mCurrentElement);
            this.mCurrentTime = (long)(entry.getOffsetTime() * 1000.0);
        }
        return entry;
    }

    private TimelineEntry loadPrevSlide() {
        int skippedSlides = 1;
        int latestBeginEntryIndex = -1;
        for (int i = this.mCurrentSlide; i >= 0; --i) {
            TimelineEntry entry = this.mAllEntries.get(i);
            if (!this.isBeginOfSlide(entry)) continue;
            latestBeginEntryIndex = i;
            if (0 != skippedSlides--) continue;
            this.mCurrentElement = i;
            this.mCurrentSlide = i;
            this.mCurrentTime = (long)(entry.getOffsetTime() * 1000.0);
            return entry;
        }
        if (latestBeginEntryIndex != -1) {
            this.mCurrentElement = latestBeginEntryIndex;
            this.mCurrentSlide = latestBeginEntryIndex;
            return this.mAllEntries.get(this.mCurrentElement);
        }
        return null;
    }

    private synchronized TimelineEntry actionNext() {
        this.stopCurrentSlide();
        return this.loadNextSlide();
    }

    private synchronized TimelineEntry actionPrev() {
        this.stopCurrentSlide();
        return this.loadPrevSlide();
    }

    private synchronized void actionPause() {
        this.pauseActiveElements();
        this.mState = SmilPlayerState.PAUSED;
        this.mAction = SmilPlayerAction.NO_ACTIVE_ACTION;
    }

    private synchronized void actionStop() {
        this.endActiveElements();
        this.mCurrentTime = 0L;
        this.mCurrentElement = 0;
        this.mCurrentSlide = 0;
        this.mState = SmilPlayerState.STOPPED;
        this.mAction = SmilPlayerAction.NO_ACTIVE_ACTION;
    }

    private synchronized void actionReload() {
        this.reloadActiveSlide();
        this.mAction = SmilPlayerAction.NO_ACTIVE_ACTION;
    }

    @Override
    public void run() {
        if (this.isStoppedState()) {
            return;
        }
        int size = this.mAllEntries.size();
        this.mCurrentElement = 0;
        while (this.mCurrentElement < size) {
            TimelineEntry entry = this.mAllEntries.get(this.mCurrentElement);
            if (this.isBeginOfSlide(entry)) {
                this.mCurrentSlide = this.mCurrentElement;
            }
            long offset = (long)(entry.getOffsetTime() * 1000.0);
            while (offset > this.mCurrentTime) {
                try {
                    this.waitForEntry(offset - this.mCurrentTime);
                }
                catch (InterruptedException e) {
                    Log.e((String)TAG, (String)"Unexpected InterruptedException.", (Throwable)e);
                }
                while (this.isPauseAction() || this.isStopAction() || this.isReloadAction() || this.isNextAction() || this.isPrevAction()) {
                    if (this.isPauseAction()) {
                        this.actionPause();
                        this.waitForWakeUp();
                    }
                    if (this.isStopAction()) {
                        this.actionStop();
                        return;
                    }
                    if (this.isReloadAction()) {
                        this.actionReload();
                        entry = this.reloadCurrentEntry();
                        if (entry == null) {
                            return;
                        }
                        if (this.isPausedState()) {
                            this.mAction = SmilPlayerAction.PAUSE;
                        }
                    }
                    if (this.isNextAction()) {
                        TimelineEntry nextEntry = this.actionNext();
                        if (nextEntry != null) {
                            entry = nextEntry;
                        }
                        if (this.mState == SmilPlayerState.PAUSED) {
                            this.mAction = SmilPlayerAction.PAUSE;
                            this.actionEntry(entry);
                        } else {
                            this.mAction = SmilPlayerAction.NO_ACTIVE_ACTION;
                        }
                        offset = this.mCurrentTime;
                    }
                    if (!this.isPrevAction()) continue;
                    TimelineEntry prevEntry = this.actionPrev();
                    if (prevEntry != null) {
                        entry = prevEntry;
                    }
                    if (this.mState == SmilPlayerState.PAUSED) {
                        this.mAction = SmilPlayerAction.PAUSE;
                        this.actionEntry(entry);
                    } else {
                        this.mAction = SmilPlayerAction.NO_ACTIVE_ACTION;
                    }
                    offset = this.mCurrentTime;
                }
            }
            this.mCurrentTime = offset;
            this.actionEntry(entry);
            ++this.mCurrentElement;
        }
        this.mState = SmilPlayerState.PLAYED;
    }

    private void dumpAllEntries() {
    }

    private static final class TimelineEntry {
        static final int ACTION_BEGIN = 0;
        static final int ACTION_END = 1;
        private final double mOffsetTime;
        private final ElementTime mElement;
        private final int mAction;

        public TimelineEntry(double offsetTime, ElementTime element, int action) {
            this.mOffsetTime = offsetTime;
            this.mElement = element;
            this.mAction = action;
        }

        public double getOffsetTime() {
            return this.mOffsetTime;
        }

        public ElementTime getElement() {
            return this.mElement;
        }

        public int getAction() {
            return this.mAction;
        }

        public String toString() {
            return "Type = " + this.mElement + " offset = " + this.getOffsetTime() + " action = " + this.getAction();
        }
    }

    private static enum SmilPlayerAction {
        NO_ACTIVE_ACTION,
        RELOAD,
        STOP,
        PAUSE,
        START,
        NEXT,
        PREV;

    }

    private static enum SmilPlayerState {
        INITIALIZED,
        PLAYING,
        PLAYED,
        PAUSED,
        STOPPED;

    }
}

