/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.NotificationTransaction;
import com.android.mms.transaction.TransactionService;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.DeliveryInd;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.NotificationInd;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.ReadOrigInd;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Transaction;

public class PushReceiver
extends BroadcastReceiver {
    private static final String TAG = "PushReceiver";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;

    public void onReceive(Context context, Intent intent) {
        if ((intent.getAction().equals("android.provider.Telephony.WAP_PUSH_DELIVER") || intent.getAction().equals("android.provider.Telephony.WAP_PUSH_RECEIVED")) && "application/vnd.wap.mms-message".equals(intent.getType())) {
            SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            if (!sharedPrefs.getBoolean("receive_with_stock", false) && Build.VERSION.SDK_INT < 19 && sharedPrefs.getBoolean("override", true) || Build.VERSION.SDK_INT >= 19) {
                PowerManager pm = (PowerManager)context.getSystemService("power");
                PowerManager.WakeLock wl = pm.newWakeLock(1, "MMS PushReceiver");
                wl.acquire(5000L);
                new ReceivePushTask(context).execute(new Intent[]{intent});
                Log.v((String)"mms_receiver", (String)(context.getPackageName() + " received and aborted"));
                this.abortBroadcast();
            } else {
                this.clearAbortBroadcast();
                Intent notificationBroadcast = new Intent("com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                notificationBroadcast.putExtra("receive_through_stock", true);
                context.sendBroadcast(notificationBroadcast);
                Log.v((String)"mms_receiver", (String)(context.getPackageName() + " received and not aborted"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findThreadId(Context context, GenericPdu pdu, int type) {
        String messageId = type == 134 ? new String(((DeliveryInd)pdu).getMessageId()) : new String(((ReadOrigInd)pdu).getMessageId());
        StringBuilder sb = new StringBuilder(40);
        sb.append("m_id");
        sb.append('=');
        sb.append(DatabaseUtils.sqlEscapeString((String)messageId));
        sb.append(" AND ");
        sb.append("m_type");
        sb.append('=');
        sb.append(128);
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), Uri.parse((String)"content://mms"), new String[]{"thread_id"}, sb.toString(), null, null);
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    long l = cursor.getLong(0);
                    return l;
                }
            }
            finally {
                cursor.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateNotification(Context context, NotificationInd nInd) {
        byte[] rawLocation = nInd.getContentLocation();
        if (rawLocation != null) {
            String location = new String(rawLocation);
            String selection = "ct_l = ?";
            String[] selectionArgs = new String[]{location};
            Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), Uri.parse((String)"content://mms"), new String[]{"_id"}, selection, selectionArgs, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() > 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }
        return false;
    }

    private class ReceivePushTask
    extends AsyncTask<Intent, Void, Void> {
        private Context mContext;

        public ReceivePushTask(Context context) {
            this.mContext = context;
        }

        protected Void doInBackground(Intent ... intents) {
            Intent intent = intents[0];
            byte[] pushData = intent.getByteArrayExtra("data");
            PduParser parser = new PduParser(pushData);
            GenericPdu pdu = parser.parse();
            if (null == pdu) {
                Log.e((String)PushReceiver.TAG, (String)"Invalid PUSH data");
                return null;
            }
            PduPersister p = PduPersister.getPduPersister(this.mContext);
            ContentResolver cr = this.mContext.getContentResolver();
            int type = pdu.getMessageType();
            long threadId = -1L;
            try {
                switch (type) {
                    case 134: 
                    case 136: {
                        boolean group;
                        threadId = PushReceiver.findThreadId(this.mContext, pdu, type);
                        if (threadId == -1L) break;
                        try {
                            group = Transaction.settings.getGroup();
                        }
                        catch (Exception e) {
                            group = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("group_message", true);
                        }
                        Uri uri = p.persist(pdu, Uri.parse((String)"content://mms/inbox"), true, group, null);
                        ContentValues values = new ContentValues(1);
                        values.put("thread_id", Long.valueOf(threadId));
                        SqliteWrapper.update(this.mContext, cr, uri, values, null, null);
                        break;
                    }
                    case 130: {
                        boolean group;
                        byte[] contentLocation;
                        NotificationInd nInd = (NotificationInd)pdu;
                        if (MmsConfig.getTransIdEnabled() && 61 == (contentLocation = nInd.getContentLocation())[contentLocation.length - 1]) {
                            byte[] transactionId = nInd.getTransactionId();
                            byte[] contentLocationWithId = new byte[contentLocation.length + transactionId.length];
                            System.arraycopy(contentLocation, 0, contentLocationWithId, 0, contentLocation.length);
                            System.arraycopy(transactionId, 0, contentLocationWithId, contentLocation.length, transactionId.length);
                            nInd.setContentLocation(contentLocationWithId);
                        }
                        try {
                            group = Transaction.settings.getGroup();
                        }
                        catch (Exception e) {
                            group = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("group_message", true);
                        }
                        Uri uri = p.persist(pdu, Uri.parse((String)"content://mms/inbox"), !NotificationTransaction.allowAutoDownload(this.mContext), group, null);
                        if (NotificationTransaction.allowAutoDownload(this.mContext)) {
                            Intent svc = new Intent(this.mContext, TransactionService.class);
                            svc.putExtra("uri", uri.toString());
                            svc.putExtra("type", 0);
                            this.mContext.startService(svc);
                            break;
                        }
                        Intent notificationBroadcast = new Intent("com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                        notificationBroadcast.putExtra("receive_through_stock", true);
                        this.mContext.sendBroadcast(notificationBroadcast);
                        break;
                    }
                    default: {
                        Log.e((String)PushReceiver.TAG, (String)"Received unrecognized PDU.");
                    }
                }
            }
            catch (MmsException e) {
                Log.e((String)PushReceiver.TAG, (String)("Failed to save the data from PUSH: type=" + type), (Throwable)e);
            }
            catch (RuntimeException e) {
                Log.e((String)PushReceiver.TAG, (String)"Unexpected RuntimeException.", (Throwable)e);
            }
            return null;
        }
    }
}

