/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.Context;
import android.net.Uri;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.PduComposer;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.ReadRecInd;
import com.klinker.android.send_message.Utils;
import java.io.IOException;

public class ReadRecTransaction
extends Transaction
implements Runnable {
    private static final String TAG = "ReadRecTransaction";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private Thread mThread;
    private final Uri mReadReportURI;

    public ReadRecTransaction(Context context, int transId, TransactionSettings connectionSettings, String uri) {
        super(context, transId, connectionSettings);
        this.mReadReportURI = Uri.parse((String)uri);
        this.mId = uri;
        this.attach(RetryScheduler.getInstance(context));
    }

    @Override
    public void process() {
        this.mThread = new Thread((Runnable)this, TAG);
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PduPersister persister = PduPersister.getPduPersister(this.mContext);
        try {
            ReadRecInd readRecInd = (ReadRecInd)persister.load(this.mReadReportURI);
            String lineNumber = Utils.getMyPhoneNumber(this.mContext);
            readRecInd.setFrom(new EncodedStringValue(lineNumber));
            byte[] postingData = new PduComposer(this.mContext, readRecInd).make();
            this.sendPdu(postingData);
            Uri uri = persister.move(this.mReadReportURI, Uri.parse((String)"content://mms/sent"));
            this.mTransactionState.setState(1);
            this.mTransactionState.setContentUri(uri);
        }
        catch (IOException e) {
        }
        catch (MmsException e) {
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (this.mTransactionState.getState() != 1) {
                this.mTransactionState.setState(2);
                this.mTransactionState.setContentUri(this.mReadReportURI);
            }
            this.notifyObservers();
        }
    }

    @Override
    public int getType() {
        return 3;
    }
}

