/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.util.DownloadManager;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.AcknowledgeInd;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.PduComposer;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.RetrieveConf;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Utils;
import java.io.IOException;

public class RetrieveTransaction
extends Transaction
implements Runnable {
    private static final String TAG = "RetrieveTransaction";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private final Uri mUri;
    private final String mContentLocation;
    private boolean mLocked;
    static final String[] PROJECTION = new String[]{"ct_l", "locked"};
    static final int COLUMN_CONTENT_LOCATION = 0;
    static final int COLUMN_LOCKED = 1;

    public RetrieveTransaction(Context context, int serviceId, TransactionSettings connectionSettings, String uri) throws MmsException {
        super(context, serviceId, connectionSettings);
        if (!uri.startsWith("content://")) {
            throw new IllegalArgumentException("Initializing from X-Mms-Content-Location is abandoned!");
        }
        this.mUri = Uri.parse((String)uri);
        this.mId = this.mContentLocation = this.getContentLocation(context, this.mUri);
        this.attach(RetryScheduler.getInstance(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentLocation(Context context, Uri uri) throws MmsException {
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), uri, PROJECTION, null, null, null);
        this.mLocked = false;
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    this.mLocked = cursor.getInt(1) == 1;
                    String string2 = cursor.getString(0);
                    return string2;
                }
            }
            finally {
                cursor.close();
            }
        }
        throw new MmsException("Cannot get X-Mms-Content-Location from: " + uri);
    }

    @Override
    public void process() {
        new Thread((Runnable)this, TAG).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DownloadManager.getInstance().markState(this.mUri, 129);
            byte[] resp = this.getPdu(this.mContentLocation);
            RetrieveConf retrieveConf = (RetrieveConf)new PduParser(resp).parse();
            if (null == retrieveConf) {
                throw new MmsException("Invalid M-Retrieve.conf PDU.");
            }
            Uri msgUri = null;
            if (RetrieveTransaction.isDuplicateMessage(this.mContext, retrieveConf)) {
                this.mTransactionState.setState(2);
                this.mTransactionState.setContentUri(this.mUri);
            } else {
                boolean group;
                try {
                    group = com.klinker.android.send_message.Transaction.settings.getGroup();
                }
                catch (Exception e) {
                    group = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("group_message", true);
                }
                PduPersister persister = PduPersister.getPduPersister(this.mContext);
                msgUri = persister.persist(retrieveConf, Uri.parse((String)"content://mms/inbox"), true, group, null);
                ContentValues values = new ContentValues(1);
                values.put("date", Long.valueOf(System.currentTimeMillis() / 1000L));
                SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), msgUri, values, null, null);
                this.mTransactionState.setState(1);
                this.mTransactionState.setContentUri(msgUri);
                RetrieveTransaction.updateContentLocation(this.mContext, msgUri, this.mContentLocation, this.mLocked);
            }
            SqliteWrapper.delete(this.mContext, this.mContext.getContentResolver(), this.mUri, null, null);
            this.sendAcknowledgeInd(retrieveConf);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)android.util.Log.getStackTraceString((Throwable)t));
        }
        finally {
            if (this.mTransactionState.getState() != 1) {
                this.mTransactionState.setState(2);
                this.mTransactionState.setContentUri(this.mUri);
                Log.e((String)TAG, (String)"Retrieval failed.");
            }
            this.notifyObservers();
        }
        this.mContext.sendBroadcast(new Intent("com.klinker.android.messaging.NEW_MMS_DOWNLOADED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateMessage(Context context, RetrieveConf rc) {
        byte[] rawMessageId = rc.getMessageId();
        if (rawMessageId != null) {
            String messageId = new String(rawMessageId);
            String selection = "(m_id = ? AND m_type = ?)";
            String[] selectionArgs = new String[]{messageId, String.valueOf(132)};
            Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), Uri.parse((String)"content://mms"), new String[]{"_id", "sub", "sub_cs"}, selection, selectionArgs, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() > 0) {
                        boolean bl = RetrieveTransaction.isDuplicateMessageExtra(cursor, rc);
                        return bl;
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }
        return false;
    }

    private static boolean isDuplicateMessageExtra(Cursor cursor, RetrieveConf rc) {
        EncodedStringValue encodedSubjectReceived = null;
        EncodedStringValue encodedSubjectStored = null;
        String subjectReceived = null;
        String subjectStored = null;
        String subject = null;
        encodedSubjectReceived = rc.getSubject();
        if (encodedSubjectReceived != null) {
            subjectReceived = encodedSubjectReceived.getString();
        }
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            int subjectIdx = cursor.getColumnIndex("sub");
            int charsetIdx = cursor.getColumnIndex("sub_cs");
            subject = cursor.getString(subjectIdx);
            int charset = cursor.getInt(charsetIdx);
            if (subject != null) {
                encodedSubjectStored = new EncodedStringValue(charset, PduPersister.getBytes(subject));
            }
            if (encodedSubjectStored == null && encodedSubjectReceived == null) {
                return true;
            }
            if (encodedSubjectStored != null && encodedSubjectReceived != null) {
                subjectStored = encodedSubjectStored.getString();
                if (!TextUtils.isEmpty((CharSequence)subjectStored) && !TextUtils.isEmpty((CharSequence)subjectReceived)) {
                    return subjectStored.equals(subjectReceived);
                }
                if (TextUtils.isEmpty((CharSequence)subjectStored) && TextUtils.isEmpty((CharSequence)subjectReceived)) {
                    return true;
                }
            }
            cursor.moveToNext();
        }
        return false;
    }

    private void sendAcknowledgeInd(RetrieveConf rc) throws MmsException, IOException {
        byte[] tranId = rc.getTransactionId();
        if (tranId != null) {
            AcknowledgeInd acknowledgeInd = new AcknowledgeInd(18, tranId);
            String lineNumber = Utils.getMyPhoneNumber(this.mContext);
            acknowledgeInd.setFrom(new EncodedStringValue(lineNumber));
            if (MmsConfig.getNotifyWapMMSC()) {
                this.sendPdu(new PduComposer(this.mContext, acknowledgeInd).make(), this.mContentLocation);
            } else {
                this.sendPdu(new PduComposer(this.mContext, acknowledgeInd).make());
            }
        }
    }

    private static void updateContentLocation(Context context, Uri uri, String contentLocation, boolean locked) {
        ContentValues values = new ContentValues(2);
        values.put("ct_l", contentLocation);
        values.put("locked", Boolean.valueOf(locked));
        SqliteWrapper.update(context, context.getContentResolver(), uri, values, null, null);
    }

    @Override
    public int getType() {
        return 1;
    }
}

