/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu_alt;

import com.google.android.mms.pdu_alt.CharacterSets;
import com.klinker.android.logger.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class EncodedStringValue
implements Cloneable {
    private static final String TAG = "EncodedStringValue";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private int mCharacterSet;
    private byte[] mData;

    public EncodedStringValue(int charset, byte[] data) {
        if (null == data) {
            throw new NullPointerException("EncodedStringValue: Text-string is null.");
        }
        this.mCharacterSet = charset;
        this.mData = new byte[data.length];
        System.arraycopy(data, 0, this.mData, 0, data.length);
    }

    public EncodedStringValue(byte[] data) {
        this(106, data);
    }

    public EncodedStringValue(String data) {
        try {
            this.mData = data.getBytes("utf-8");
            this.mCharacterSet = 106;
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"Default encoding must be supported.", (Throwable)e);
        }
    }

    public int getCharacterSet() {
        return this.mCharacterSet;
    }

    public void setCharacterSet(int charset) {
        this.mCharacterSet = charset;
    }

    public byte[] getTextString() {
        byte[] byteArray = new byte[this.mData.length];
        System.arraycopy(this.mData, 0, byteArray, 0, this.mData.length);
        return byteArray;
    }

    public void setTextString(byte[] textString) {
        if (null == textString) {
            throw new NullPointerException("EncodedStringValue: Text-string is null.");
        }
        this.mData = new byte[textString.length];
        System.arraycopy(textString, 0, this.mData, 0, textString.length);
    }

    public String getString() {
        if (0 == this.mCharacterSet) {
            return new String(this.mData);
        }
        try {
            String name = CharacterSets.getMimeName(this.mCharacterSet);
            return new String(this.mData, name);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new String(this.mData, "iso-8859-1");
            }
            catch (UnsupportedEncodingException _) {
                return new String(this.mData);
            }
        }
    }

    public void appendTextString(byte[] textString) {
        if (null == textString) {
            throw new NullPointerException("Text-string is null.");
        }
        if (null == this.mData) {
            this.mData = new byte[textString.length];
            System.arraycopy(textString, 0, this.mData, 0, textString.length);
        } else {
            ByteArrayOutputStream newTextString = new ByteArrayOutputStream();
            try {
                newTextString.write(this.mData);
                newTextString.write(textString);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
                throw new NullPointerException("appendTextString: failed when write a new Text-string");
            }
            this.mData = newTextString.toByteArray();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        int len = this.mData.length;
        byte[] dstBytes = new byte[len];
        System.arraycopy(this.mData, 0, dstBytes, 0, len);
        try {
            return new EncodedStringValue(this.mCharacterSet, dstBytes);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("failed to clone an EncodedStringValue: " + this));
            Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    public EncodedStringValue[] split(String pattern) {
        String[] temp = this.getString().split(pattern);
        EncodedStringValue[] ret = new EncodedStringValue[temp.length];
        for (int i = 0; i < ret.length; ++i) {
            try {
                ret[i] = new EncodedStringValue(this.mCharacterSet, temp[i].getBytes());
                continue;
            }
            catch (NullPointerException _) {
                return null;
            }
        }
        return ret;
    }

    public static EncodedStringValue[] extract(String src) {
        String[] values = src.split(";");
        ArrayList<EncodedStringValue> list = new ArrayList<EncodedStringValue>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].length() <= 0) continue;
            list.add(new EncodedStringValue(values[i]));
        }
        int len = list.size();
        if (len > 0) {
            return list.toArray(new EncodedStringValue[len]);
        }
        return null;
    }

    public static String concat(EncodedStringValue[] addr) {
        StringBuilder sb = new StringBuilder();
        int maxIndex = addr.length - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            sb.append(addr[i].getString());
            if (i >= maxIndex) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public static EncodedStringValue copy(EncodedStringValue value) {
        if (value == null) {
            return null;
        }
        return new EncodedStringValue(value.mCharacterSet, value.mData);
    }

    public static EncodedStringValue[] encodeStrings(String[] array) {
        int count = array.length;
        if (count > 0) {
            EncodedStringValue[] encodedArray = new EncodedStringValue[count];
            for (int i = 0; i < count; ++i) {
                encodedArray[i] = new EncodedStringValue(array[i]);
            }
            return encodedArray;
        }
        return null;
    }
}

