/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu_alt;

import android.content.ContentResolver;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.PduBody;
import com.google.android.mms.pdu_alt.PduContentTypes;
import com.google.android.mms.pdu_alt.PduHeaders;
import com.google.android.mms.pdu_alt.PduPart;
import com.google.android.mms.pdu_alt.SendReq;
import com.klinker.android.logger.Log;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;

public class PduComposer {
    private static final int PDU_PHONE_NUMBER_ADDRESS_TYPE = 1;
    private static final int PDU_EMAIL_ADDRESS_TYPE = 2;
    private static final int PDU_IPV4_ADDRESS_TYPE = 3;
    private static final int PDU_IPV6_ADDRESS_TYPE = 4;
    private static final int PDU_UNKNOWN_ADDRESS_TYPE = 5;
    static final String REGEXP_PHONE_NUMBER_ADDRESS_TYPE = "\\+?[0-9|\\.|\\-]+";
    static final String REGEXP_EMAIL_ADDRESS_TYPE = "[a-zA-Z| ]*\\<{0,1}[a-zA-Z| ]+@{1}[a-zA-Z| ]+\\.{1}[a-zA-Z| ]+\\>{0,1}";
    static final String REGEXP_IPV6_ADDRESS_TYPE = "[a-fA-F]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}";
    static final String REGEXP_IPV4_ADDRESS_TYPE = "[0-9]{1,3}\\.{1}[0-9]{1,3}\\.{1}[0-9]{1,3}\\.{1}[0-9]{1,3}";
    static final String STRING_PHONE_NUMBER_ADDRESS_TYPE = "/TYPE=PLMN";
    static final String STRING_IPV4_ADDRESS_TYPE = "/TYPE=IPV4";
    static final String STRING_IPV6_ADDRESS_TYPE = "/TYPE=IPV6";
    private static final int PDU_COMPOSE_SUCCESS = 0;
    private static final int PDU_COMPOSE_CONTENT_ERROR = 1;
    private static final int PDU_COMPOSE_FIELD_NOT_SET = 2;
    private static final int PDU_COMPOSE_FIELD_NOT_SUPPORTED = 3;
    private static final int QUOTED_STRING_FLAG = 34;
    private static final int END_STRING_FLAG = 0;
    private static final int LENGTH_QUOTE = 31;
    private static final int TEXT_MAX = 127;
    private static final int SHORT_INTEGER_MAX = 127;
    private static final int LONG_INTEGER_LENGTH_MAX = 8;
    private static final int PDU_COMPOSER_BLOCK_SIZE = 1024;
    private static final String TAG = "PduComposer";
    protected ByteArrayOutputStream mMessage = null;
    private GenericPdu mPdu = null;
    protected int mPosition = 0;
    private BufferStack mStack = null;
    private final ContentResolver mResolver;
    private PduHeaders mPduHeader = null;
    private static HashMap<String, Integer> mContentTypeMap = null;

    public PduComposer(Context context, GenericPdu pdu) {
        this.mPdu = pdu;
        this.mResolver = context.getContentResolver();
        this.mPduHeader = pdu.getPduHeaders();
        this.mStack = new BufferStack();
        this.mMessage = new ByteArrayOutputStream();
        this.mPosition = 0;
    }

    public byte[] make() {
        int type = this.mPdu.getMessageType();
        switch (type) {
            case 128: {
                if (this.makeSendReqPdu() == 0) break;
                return null;
            }
            case 131: {
                if (this.makeNotifyResp() == 0) break;
                return null;
            }
            case 133: {
                if (this.makeAckInd() == 0) break;
                return null;
            }
            case 135: {
                if (this.makeReadRecInd() == 0) break;
                return null;
            }
            default: {
                return null;
            }
        }
        return this.mMessage.toByteArray();
    }

    protected void arraycopy(byte[] buf, int pos, int length) {
        this.mMessage.write(buf, pos, length);
        this.mPosition += length;
    }

    protected void append(int value) {
        this.mMessage.write(value);
        ++this.mPosition;
    }

    protected void appendShortInteger(int value) {
        this.append((value | 0x80) & 0xFF);
    }

    protected void appendOctet(int number) {
        this.append(number);
    }

    protected void appendShortLength(int value) {
        this.append(value);
    }

    protected void appendLongInteger(long longInt) {
        int size;
        long temp = longInt;
        for (size = 0; temp != 0L && size < 8; temp >>>= 8, ++size) {
        }
        this.appendShortLength(size);
        int shift = (size - 1) * 8;
        for (int i = 0; i < size; ++i) {
            this.append((int)(longInt >>> shift & 0xFFL));
            shift -= 8;
        }
    }

    protected void appendTextString(byte[] text) {
        if ((text[0] & 0xFF) > 127) {
            this.append(127);
        }
        this.arraycopy(text, 0, text.length);
        this.append(0);
    }

    protected void appendTextString(String str) {
        this.appendTextString(str.getBytes());
    }

    protected void appendEncodedString(EncodedStringValue enStr) {
        assert (enStr != null);
        int charset = enStr.getCharacterSet();
        byte[] textString = enStr.getTextString();
        if (null == textString) {
            return;
        }
        this.mStack.newbuf();
        PositionMarker start = this.mStack.mark();
        this.appendShortInteger(charset);
        this.appendTextString(textString);
        int len = start.getLength();
        this.mStack.pop();
        this.appendValueLength(len);
        this.mStack.copy();
    }

    protected void appendUintvarInteger(long value) {
        int i;
        long max = 127L;
        for (i = 0; i < 5 && value >= max; ++i) {
            max = max << 7 | 0x7FL;
        }
        while (i > 0) {
            long temp = value >>> i * 7;
            this.append((int)(((temp &= 0x7FL) | 0x80L) & 0xFFL));
            --i;
        }
        this.append((int)(value & 0x7FL));
    }

    protected void appendDateValue(long date) {
        this.appendLongInteger(date);
    }

    protected void appendValueLength(long value) {
        if (value < 31L) {
            this.appendShortLength((int)value);
            return;
        }
        this.append(31);
        this.appendUintvarInteger(value);
    }

    protected void appendQuotedString(byte[] text) {
        this.append(34);
        this.arraycopy(text, 0, text.length);
        this.append(0);
    }

    protected void appendQuotedString(String str) {
        this.appendQuotedString(str.getBytes());
    }

    private EncodedStringValue appendAddressType(EncodedStringValue address) {
        EncodedStringValue temp = null;
        try {
            int addressType = PduComposer.checkAddressType(address.getString());
            temp = EncodedStringValue.copy(address);
            if (1 == addressType) {
                temp.appendTextString(STRING_PHONE_NUMBER_ADDRESS_TYPE.getBytes());
            } else if (3 == addressType) {
                temp.appendTextString(STRING_IPV4_ADDRESS_TYPE.getBytes());
            } else if (4 == addressType) {
                temp.appendTextString(STRING_IPV6_ADDRESS_TYPE.getBytes());
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return temp;
    }

    private int appendHeader(int field) {
        switch (field) {
            case 141: {
                this.appendOctet(field);
                int version = this.mPduHeader.getOctet(field);
                if (0 == version) {
                    this.appendShortInteger(18);
                    break;
                }
                this.appendShortInteger(version);
                break;
            }
            case 139: 
            case 152: {
                byte[] textString = this.mPduHeader.getTextString(field);
                if (null == textString) {
                    return 2;
                }
                this.appendOctet(field);
                this.appendTextString(textString);
                break;
            }
            case 129: 
            case 130: 
            case 151: {
                EncodedStringValue[] addr = this.mPduHeader.getEncodedStringValues(field);
                if (null == addr) {
                    return 2;
                }
                for (int i = 0; i < addr.length; ++i) {
                    EncodedStringValue temp = this.appendAddressType(addr[i]);
                    if (temp == null) {
                        return 1;
                    }
                    this.appendOctet(field);
                    this.appendEncodedString(temp);
                }
                break;
            }
            case 137: {
                this.appendOctet(field);
                EncodedStringValue from = this.mPduHeader.getEncodedStringValue(field);
                if (from == null || TextUtils.isEmpty((CharSequence)from.getString()) || new String(from.getTextString()).equals("insert-address-token")) {
                    this.append(1);
                    this.append(129);
                    break;
                }
                this.mStack.newbuf();
                PositionMarker fstart = this.mStack.mark();
                this.append(128);
                EncodedStringValue temp = this.appendAddressType(from);
                if (temp == null) {
                    return 1;
                }
                this.appendEncodedString(temp);
                int flen = fstart.getLength();
                this.mStack.pop();
                this.appendValueLength(flen);
                this.mStack.copy();
                break;
            }
            case 134: 
            case 143: 
            case 144: 
            case 145: 
            case 149: 
            case 155: {
                int octet = this.mPduHeader.getOctet(field);
                if (0 == octet) {
                    return 2;
                }
                this.appendOctet(field);
                this.appendOctet(octet);
                break;
            }
            case 133: {
                long date = this.mPduHeader.getLongInteger(field);
                if (-1L == date) {
                    return 2;
                }
                this.appendOctet(field);
                this.appendDateValue(date);
                break;
            }
            case 150: {
                EncodedStringValue enString = this.mPduHeader.getEncodedStringValue(field);
                if (null == enString) {
                    return 2;
                }
                this.appendOctet(field);
                this.appendEncodedString(enString);
                break;
            }
            case 138: {
                byte[] messageClass = this.mPduHeader.getTextString(field);
                if (null == messageClass) {
                    return 2;
                }
                this.appendOctet(field);
                if (Arrays.equals(messageClass, "advertisement".getBytes())) {
                    this.appendOctet(129);
                    break;
                }
                if (Arrays.equals(messageClass, "auto".getBytes())) {
                    this.appendOctet(131);
                    break;
                }
                if (Arrays.equals(messageClass, "personal".getBytes())) {
                    this.appendOctet(128);
                    break;
                }
                if (Arrays.equals(messageClass, "informational".getBytes())) {
                    this.appendOctet(130);
                    break;
                }
                this.appendTextString(messageClass);
                break;
            }
            case 136: {
                long expiry = this.mPduHeader.getLongInteger(field);
                if (-1L == expiry) {
                    return 2;
                }
                this.appendOctet(field);
                this.mStack.newbuf();
                PositionMarker expiryStart = this.mStack.mark();
                this.append(129);
                this.appendLongInteger(expiry);
                int expiryLength = expiryStart.getLength();
                this.mStack.pop();
                this.appendValueLength(expiryLength);
                this.mStack.copy();
                break;
            }
            default: {
                return 3;
            }
        }
        return 0;
    }

    private int makeReadRecInd() {
        if (this.mMessage == null) {
            this.mMessage = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(135);
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        if (this.appendHeader(139) != 0) {
            return 1;
        }
        if (this.appendHeader(151) != 0) {
            return 1;
        }
        if (this.appendHeader(137) != 0) {
            return 1;
        }
        this.appendHeader(133);
        if (this.appendHeader(155) != 0) {
            return 1;
        }
        return 0;
    }

    private int makeNotifyResp() {
        if (this.mMessage == null) {
            this.mMessage = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(131);
        if (this.appendHeader(152) != 0) {
            return 1;
        }
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        if (this.appendHeader(149) != 0) {
            return 1;
        }
        return 0;
    }

    private int makeAckInd() {
        if (this.mMessage == null) {
            this.mMessage = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(133);
        if (this.appendHeader(152) != 0) {
            return 1;
        }
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        this.appendHeader(145);
        return 0;
    }

    private int makeSendReqPdu() {
        if (this.mMessage == null) {
            this.mMessage = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(128);
        this.appendOctet(152);
        byte[] trid = this.mPduHeader.getTextString(152);
        if (trid == null) {
            throw new IllegalArgumentException("Transaction-ID is null.");
        }
        this.appendTextString(trid);
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        this.appendHeader(133);
        if (this.appendHeader(137) != 0) {
            return 1;
        }
        boolean recipient = false;
        if (this.appendHeader(151) != 1) {
            recipient = true;
        }
        if (this.appendHeader(130) != 1) {
            recipient = true;
        }
        if (this.appendHeader(129) != 1) {
            recipient = true;
        }
        if (!recipient) {
            return 1;
        }
        this.appendHeader(150);
        this.appendHeader(138);
        this.appendHeader(136);
        this.appendHeader(143);
        this.appendHeader(134);
        this.appendHeader(144);
        this.appendOctet(132);
        return this.makeMessageBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int makeMessageBody() {
        PduPart part;
        this.mStack.newbuf();
        PositionMarker ctStart = this.mStack.mark();
        String contentType = new String(this.mPduHeader.getTextString(132));
        Integer contentTypeIdentifier = mContentTypeMap.get(contentType);
        if (contentTypeIdentifier == null) {
            return 1;
        }
        this.appendShortInteger(contentTypeIdentifier);
        PduBody body = ((SendReq)this.mPdu).getBody();
        if (null == body || body.getPartsNum() == 0) {
            this.appendUintvarInteger(0L);
            this.mStack.pop();
            this.mStack.copy();
            return 0;
        }
        try {
            part = body.getPart(0);
            byte[] start = part.getContentId();
            if (start != null) {
                this.appendOctet(138);
                if (60 == start[0] && 62 == start[start.length - 1]) {
                    this.appendTextString(start);
                } else {
                    this.appendTextString("<" + new String(start) + ">");
                }
            }
            this.appendOctet(137);
            this.appendTextString(part.getContentType());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
        }
        int ctLength = ctStart.getLength();
        this.mStack.pop();
        this.appendValueLength(ctLength);
        this.mStack.copy();
        int partNum = body.getPartsNum();
        this.appendUintvarInteger(partNum);
        for (int i = 0; i < partNum; ++i) {
            byte[] contentLocation;
            part = body.getPart(i);
            this.mStack.newbuf();
            PositionMarker attachment = this.mStack.mark();
            this.mStack.newbuf();
            PositionMarker contentTypeBegin = this.mStack.mark();
            byte[] partContentType = part.getContentType();
            if (partContentType == null) {
                return 1;
            }
            Integer partContentTypeIdentifier = mContentTypeMap.get(new String(partContentType));
            if (partContentTypeIdentifier == null) {
                this.appendTextString(partContentType);
            } else {
                this.appendShortInteger(partContentTypeIdentifier);
            }
            byte[] name = part.getName();
            if (null == name && null == (name = part.getFilename()) && null == (name = part.getContentLocation())) {
                return 1;
            }
            this.appendOctet(133);
            this.appendTextString(name);
            int charset = part.getCharset();
            if (charset != 0) {
                this.appendOctet(129);
                this.appendShortInteger(charset);
            }
            int contentTypeLength = contentTypeBegin.getLength();
            this.mStack.pop();
            this.appendValueLength(contentTypeLength);
            this.mStack.copy();
            byte[] contentId = part.getContentId();
            if (null != contentId) {
                this.appendOctet(192);
                if (60 == contentId[0] && 62 == contentId[contentId.length - 1]) {
                    this.appendQuotedString(contentId);
                } else {
                    this.appendQuotedString("<" + new String(contentId) + ">");
                }
            }
            if (null != (contentLocation = part.getContentLocation())) {
                this.appendOctet(142);
                this.appendTextString(contentLocation);
            }
            int headerLength = attachment.getLength();
            int dataLength = 0;
            byte[] partData = part.getData();
            if (partData != null) {
                this.arraycopy(partData, 0, partData.length);
                dataLength = partData.length;
            } else {
                int n;
                InputStream cr = null;
                try {
                    byte[] buffer = new byte[1024];
                    cr = this.mResolver.openInputStream(part.getDataUri());
                    int len = 0;
                    while ((len = cr.read(buffer)) != -1) {
                        this.mMessage.write(buffer, 0, len);
                        this.mPosition += len;
                        dataLength += len;
                    }
                }
                catch (FileNotFoundException e) {
                    n = 1;
                    return n;
                }
                catch (IOException e) {
                    n = 1;
                    return n;
                }
                catch (RuntimeException e2) {
                    n = 1;
                    return n;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (cr != null) {
                        try {
                            cr.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            if (dataLength != attachment.getLength() - headerLength) {
                throw new RuntimeException("BUG: Length sanity check failed");
            }
            this.mStack.pop();
            this.appendUintvarInteger(headerLength);
            this.appendUintvarInteger(dataLength);
            this.mStack.copy();
        }
        return 0;
    }

    protected static int checkAddressType(String address) {
        if (null == address) {
            return 5;
        }
        if (address.matches(REGEXP_IPV4_ADDRESS_TYPE)) {
            return 3;
        }
        if (address.matches(REGEXP_PHONE_NUMBER_ADDRESS_TYPE)) {
            return 1;
        }
        if (address.matches(REGEXP_EMAIL_ADDRESS_TYPE)) {
            return 2;
        }
        if (address.matches(REGEXP_IPV6_ADDRESS_TYPE)) {
            return 4;
        }
        return 5;
    }

    static {
        mContentTypeMap = new HashMap();
        for (int i = 0; i < PduContentTypes.contentTypes.length; ++i) {
            mContentTypeMap.put(PduContentTypes.contentTypes[i], i);
        }
    }

    private class BufferStack {
        private LengthRecordNode stack = null;
        private LengthRecordNode toCopy = null;
        int stackSize = 0;

        private BufferStack() {
        }

        void newbuf() {
            if (this.toCopy != null) {
                throw new RuntimeException("BUG: Invalid newbuf() before copy()");
            }
            LengthRecordNode temp = new LengthRecordNode();
            temp.currentMessage = PduComposer.this.mMessage;
            temp.currentPosition = PduComposer.this.mPosition;
            temp.next = this.stack;
            this.stack = temp;
            ++this.stackSize;
            PduComposer.this.mMessage = new ByteArrayOutputStream();
            PduComposer.this.mPosition = 0;
        }

        void pop() {
            ByteArrayOutputStream currentMessage = PduComposer.this.mMessage;
            int currentPosition = PduComposer.this.mPosition;
            PduComposer.this.mMessage = this.stack.currentMessage;
            PduComposer.this.mPosition = this.stack.currentPosition;
            this.toCopy = this.stack;
            this.stack = this.stack.next;
            --this.stackSize;
            this.toCopy.currentMessage = currentMessage;
            this.toCopy.currentPosition = currentPosition;
        }

        void copy() {
            PduComposer.this.arraycopy(this.toCopy.currentMessage.toByteArray(), 0, this.toCopy.currentPosition);
            this.toCopy = null;
        }

        PositionMarker mark() {
            PositionMarker m = new PositionMarker();
            m.c_pos = PduComposer.this.mPosition;
            m.currentStackSize = this.stackSize;
            return m;
        }
    }

    private class PositionMarker {
        private int c_pos;
        private int currentStackSize;

        private PositionMarker() {
        }

        int getLength() {
            if (this.currentStackSize != ((PduComposer)PduComposer.this).mStack.stackSize) {
                throw new RuntimeException("BUG: Invalid call to getLength()");
            }
            return PduComposer.this.mPosition - this.c_pos;
        }
    }

    private static class LengthRecordNode {
        ByteArrayOutputStream currentMessage = null;
        public int currentPosition = 0;
        public LengthRecordNode next = null;

        private LengthRecordNode() {
        }
    }
}

