/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil;

import com.android.mms.dom.smil.SmilDocumentImpl;
import com.android.mms.dom.smil.SmilElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILRegionElement;

public class SmilRegionElementImpl
extends SmilElementImpl
implements SMILRegionElement {
    private static final String HIDDEN_ATTRIBUTE = "hidden";
    private static final String SLICE_ATTRIBUTE = "slice";
    private static final String SCROLL_ATTRIBUTE = "scroll";
    private static final String MEET_ATTRIBUTE = "meet";
    private static final String FILL_ATTRIBUTE = "fill";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String WIDTH_ATTRIBUTE_NAME = "width";
    private static final String TITLE_ATTRIBUTE_NAME = "title";
    private static final String HEIGHT_ATTRIBUTE_NAME = "height";
    private static final String BACKGROUND_COLOR_ATTRIBUTE_NAME = "backgroundColor";
    private static final String Z_INDEX_ATTRIBUTE_NAME = "z-index";
    private static final String TOP_ATTRIBUTE_NAME = "top";
    private static final String LEFT_ATTRIBUTE_NAME = "left";
    private static final String RIGHT_ATTRIBUTE_NAME = "right";
    private static final String BOTTOM_ATTRIBUTE_NAME = "bottom";
    private static final String FIT_ATTRIBUTE_NAME = "fit";
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;

    SmilRegionElementImpl(SmilDocumentImpl owner, String tagName) {
        super(owner, tagName);
    }

    @Override
    public String getFit() {
        String fit = this.getAttribute(FIT_ATTRIBUTE_NAME);
        if (FILL_ATTRIBUTE.equalsIgnoreCase(fit)) {
            return FILL_ATTRIBUTE;
        }
        if (MEET_ATTRIBUTE.equalsIgnoreCase(fit)) {
            return MEET_ATTRIBUTE;
        }
        if (SCROLL_ATTRIBUTE.equalsIgnoreCase(fit)) {
            return SCROLL_ATTRIBUTE;
        }
        if (SLICE_ATTRIBUTE.equalsIgnoreCase(fit)) {
            return SLICE_ATTRIBUTE;
        }
        return HIDDEN_ATTRIBUTE;
    }

    @Override
    public int getLeft() {
        try {
            return this.parseRegionLength(this.getAttribute(LEFT_ATTRIBUTE_NAME), true);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                int bbw = ((SMILDocument)this.getOwnerDocument()).getLayout().getRootLayout().getWidth();
                int right = this.parseRegionLength(this.getAttribute(RIGHT_ATTRIBUTE_NAME), true);
                int width = this.parseRegionLength(this.getAttribute(WIDTH_ATTRIBUTE_NAME), true);
                return bbw - right - width;
            }
            catch (NumberFormatException numberFormatException2) {
                return 0;
            }
        }
    }

    @Override
    public int getTop() {
        try {
            return this.parseRegionLength(this.getAttribute(TOP_ATTRIBUTE_NAME), false);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                int bbh = ((SMILDocument)this.getOwnerDocument()).getLayout().getRootLayout().getHeight();
                int bottom = this.parseRegionLength(this.getAttribute(BOTTOM_ATTRIBUTE_NAME), false);
                int height = this.parseRegionLength(this.getAttribute(HEIGHT_ATTRIBUTE_NAME), false);
                return bbh - bottom - height;
            }
            catch (NumberFormatException numberFormatException2) {
                return 0;
            }
        }
    }

    @Override
    public int getZIndex() {
        try {
            return Integer.parseInt(this.getAttribute(Z_INDEX_ATTRIBUTE_NAME));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void setFit(String fit) throws DOMException {
        if (fit.equalsIgnoreCase(FILL_ATTRIBUTE) || fit.equalsIgnoreCase(MEET_ATTRIBUTE) || fit.equalsIgnoreCase(SCROLL_ATTRIBUTE) || fit.equalsIgnoreCase(SLICE_ATTRIBUTE)) {
            this.setAttribute(FIT_ATTRIBUTE_NAME, fit.toLowerCase());
        } else {
            this.setAttribute(FIT_ATTRIBUTE_NAME, HIDDEN_ATTRIBUTE);
        }
    }

    @Override
    public void setLeft(int left) throws DOMException {
        this.setAttribute(LEFT_ATTRIBUTE_NAME, String.valueOf(left));
    }

    @Override
    public void setTop(int top) throws DOMException {
        this.setAttribute(TOP_ATTRIBUTE_NAME, String.valueOf(top));
    }

    @Override
    public void setZIndex(int zIndex) throws DOMException {
        if (zIndex > 0) {
            this.setAttribute(Z_INDEX_ATTRIBUTE_NAME, Integer.toString(zIndex));
        } else {
            this.setAttribute(Z_INDEX_ATTRIBUTE_NAME, Integer.toString(0));
        }
    }

    @Override
    public String getBackgroundColor() {
        return this.getAttribute(BACKGROUND_COLOR_ATTRIBUTE_NAME);
    }

    @Override
    public int getHeight() {
        try {
            int height = this.parseRegionLength(this.getAttribute(HEIGHT_ATTRIBUTE_NAME), false);
            return height == 0 ? ((SMILDocument)this.getOwnerDocument()).getLayout().getRootLayout().getHeight() : height;
        }
        catch (NumberFormatException height) {
            int bbh = ((SMILDocument)this.getOwnerDocument()).getLayout().getRootLayout().getHeight();
            try {
                bbh -= this.parseRegionLength(this.getAttribute(TOP_ATTRIBUTE_NAME), false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                bbh -= this.parseRegionLength(this.getAttribute(BOTTOM_ATTRIBUTE_NAME), false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return bbh;
        }
    }

    @Override
    public String getTitle() {
        return this.getAttribute(TITLE_ATTRIBUTE_NAME);
    }

    @Override
    public int getWidth() {
        try {
            int width = this.parseRegionLength(this.getAttribute(WIDTH_ATTRIBUTE_NAME), true);
            return width == 0 ? ((SMILDocument)this.getOwnerDocument()).getLayout().getRootLayout().getWidth() : width;
        }
        catch (NumberFormatException width) {
            int bbw = ((SMILDocument)this.getOwnerDocument()).getLayout().getRootLayout().getWidth();
            try {
                bbw -= this.parseRegionLength(this.getAttribute(LEFT_ATTRIBUTE_NAME), true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                bbw -= this.parseRegionLength(this.getAttribute(RIGHT_ATTRIBUTE_NAME), true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return bbw;
        }
    }

    @Override
    public void setBackgroundColor(String backgroundColor) throws DOMException {
        this.setAttribute(BACKGROUND_COLOR_ATTRIBUTE_NAME, backgroundColor);
    }

    @Override
    public void setHeight(int height) throws DOMException {
        this.setAttribute(HEIGHT_ATTRIBUTE_NAME, String.valueOf(height) + "px");
    }

    @Override
    public void setTitle(String title) throws DOMException {
        this.setAttribute(TITLE_ATTRIBUTE_NAME, title);
    }

    @Override
    public void setWidth(int width) throws DOMException {
        this.setAttribute(WIDTH_ATTRIBUTE_NAME, String.valueOf(width) + "px");
    }

    @Override
    public String getId() {
        return this.getAttribute(ID_ATTRIBUTE_NAME);
    }

    @Override
    public void setId(String id2) throws DOMException {
        this.setAttribute(ID_ATTRIBUTE_NAME, id2);
    }

    private int parseRegionLength(String length, boolean horizontal) {
        if (length.endsWith("px")) {
            length = length.substring(0, length.indexOf("px"));
            return Integer.parseInt(length);
        }
        if (length.endsWith("%")) {
            double value = 0.01 * (double)Integer.parseInt(length.substring(0, length.length() - 1));
            value = horizontal ? (value *= (double)((SMILDocument)this.getOwnerDocument()).getLayout().getRootLayout().getWidth()) : (value *= (double)((SMILDocument)this.getOwnerDocument()).getLayout().getRootLayout().getHeight());
            return (int)Math.round(value);
        }
        return Integer.parseInt(length);
    }

    public String toString() {
        return super.toString() + ": id=" + this.getId() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", left=" + this.getLeft() + ", top=" + this.getTop();
    }
}

