/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.SmsManager;
import com.android.mms.MmsConfig;
import com.android.mms.service_alt.DownloadRequest;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.MmsRequestManager;
import com.android.mms.transaction.NotificationTransaction;
import com.android.mms.transaction.TransactionService;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.DeliveryInd;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.NotificationInd;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.ReadOrigInd;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Transaction;
import com.klinker.android.send_message.Utils;
import java.io.File;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class PushReceiver
extends BroadcastReceiver {
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = true;
    static final String[] PROJECTION = new String[]{"ct_l", "locked"};
    static final int COLUMN_CONTENT_LOCATION = 0;
    private static Set<String> downloadedUrls = new HashSet<String>();

    public void onReceive(Context context, Intent intent) {
        Log.v((String)TAG, (String)(intent.getAction() + " " + intent.getType()));
        if ((intent.getAction().equals("android.provider.Telephony.WAP_PUSH_DELIVER") || intent.getAction().equals("android.provider.Telephony.WAP_PUSH_RECEIVED")) && "application/vnd.wap.mms-message".equals(intent.getType())) {
            Log.v((String)TAG, (String)("Received PUSH Intent: " + intent));
            SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            if (!sharedPrefs.getBoolean("receive_with_stock", false) && Build.VERSION.SDK_INT < 19 && sharedPrefs.getBoolean("override", true) || Build.VERSION.SDK_INT >= 19) {
                PowerManager pm = (PowerManager)context.getSystemService("power");
                PowerManager.WakeLock wl = pm.newWakeLock(1, "MMS PushReceiver");
                wl.acquire(5000L);
                new ReceivePushTask(context).execute(new Intent[]{intent});
                Log.v((String)"mms_receiver", (String)(context.getPackageName() + " received and aborted"));
                this.abortBroadcast();
            } else {
                this.clearAbortBroadcast();
                Intent notificationBroadcast = new Intent("com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                notificationBroadcast.putExtra("receive_through_stock", true);
                context.sendBroadcast(notificationBroadcast);
                Log.v((String)"mms_receiver", (String)(context.getPackageName() + " received and not aborted"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentLocation(Context context, Uri uri) throws MmsException {
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), uri, PROJECTION, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    String location = cursor.getString(0);
                    cursor.close();
                    String string2 = location;
                    return string2;
                }
            }
            finally {
                cursor.close();
            }
        }
        throw new MmsException("Cannot get X-Mms-Content-Location from: " + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findThreadId(Context context, GenericPdu pdu, int type) {
        String messageId = type == 134 ? new String(((DeliveryInd)pdu).getMessageId()) : new String(((ReadOrigInd)pdu).getMessageId());
        StringBuilder sb = new StringBuilder(40);
        sb.append("m_id");
        sb.append('=');
        sb.append(DatabaseUtils.sqlEscapeString((String)messageId));
        sb.append(" AND ");
        sb.append("m_type");
        sb.append('=');
        sb.append(128);
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"thread_id"}, sb.toString(), null, null);
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    long id2 = cursor.getLong(0);
                    cursor.close();
                    long l = id2;
                    return l;
                }
            }
            finally {
                cursor.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateNotification(Context context, NotificationInd nInd) {
        byte[] rawLocation = nInd.getContentLocation();
        if (rawLocation != null) {
            String location = new String(rawLocation);
            String selection = "ct_l = ?";
            String[] selectionArgs = new String[]{location};
            Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"_id"}, selection, selectionArgs, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() > 0) {
                        cursor.close();
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }
        return false;
    }

    private class ReceivePushTask
    extends AsyncTask<Intent, Void, Void> {
        private Context mContext;

        public ReceivePushTask(Context context) {
            this.mContext = context;
        }

        protected Void doInBackground(Intent ... intents) {
            Log.v((String)PushReceiver.TAG, (String)"receiving a new mms message");
            Intent intent = intents[0];
            byte[] pushData = intent.getByteArrayExtra("data");
            PduParser parser = new PduParser(pushData);
            GenericPdu pdu = parser.parse();
            if (null == pdu) {
                Log.e((String)PushReceiver.TAG, (String)"Invalid PUSH data");
                return null;
            }
            PduPersister p = PduPersister.getPduPersister(this.mContext);
            ContentResolver cr = this.mContext.getContentResolver();
            int type = pdu.getMessageType();
            long threadId = -1L;
            try {
                switch (type) {
                    case 134: 
                    case 136: {
                        boolean group;
                        threadId = PushReceiver.findThreadId(this.mContext, pdu, type);
                        if (threadId == -1L) break;
                        try {
                            group = Transaction.settings.getGroup();
                        }
                        catch (Exception e) {
                            group = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("group_message", true);
                        }
                        Uri uri = p.persist(pdu, Uri.parse((String)"content://mms/inbox"), true, group, null);
                        ContentValues values = new ContentValues(1);
                        values.put("thread_id", Long.valueOf(threadId));
                        SqliteWrapper.update(this.mContext, cr, uri, values, null, null);
                        break;
                    }
                    case 130: {
                        byte[] contentLocation;
                        NotificationInd nInd = (NotificationInd)pdu;
                        if (MmsConfig.getTransIdEnabled() && 61 == (contentLocation = nInd.getContentLocation())[contentLocation.length - 1]) {
                            byte[] transactionId = nInd.getTransactionId();
                            byte[] contentLocationWithId = new byte[contentLocation.length + transactionId.length];
                            System.arraycopy(contentLocation, 0, contentLocationWithId, 0, contentLocation.length);
                            System.arraycopy(transactionId, 0, contentLocationWithId, contentLocation.length, transactionId.length);
                            nInd.setContentLocation(contentLocationWithId);
                        }
                        if (!PushReceiver.isDuplicateNotification(this.mContext, nInd)) {
                            boolean group;
                            try {
                                group = Transaction.settings.getGroup();
                            }
                            catch (Exception e) {
                                group = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("group_message", true);
                            }
                            Uri uri = p.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, !NotificationTransaction.allowAutoDownload(this.mContext), group, null);
                            String location = PushReceiver.getContentLocation(this.mContext, uri);
                            if (downloadedUrls.contains(location)) {
                                Log.v((String)PushReceiver.TAG, (String)"already added this download, don't download again");
                                return null;
                            }
                            downloadedUrls.add(location);
                            if (Build.VERSION.SDK_INT >= 21) {
                                Log.v((String)PushReceiver.TAG, (String)"receiving on a lollipop+ device");
                                boolean useSystem = true;
                                useSystem = Transaction.settings != null ? Transaction.settings.getUseSystemSending() : PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("system_mms_sending", useSystem);
                                if (useSystem) {
                                    Log.v((String)PushReceiver.TAG, (String)"receiving with system method");
                                    String fileName = "download." + String.valueOf(Math.abs(new Random().nextLong())) + ".dat";
                                    File mDownloadFile = new File(this.mContext.getCacheDir(), fileName);
                                    Uri contentUri = new Uri.Builder().authority("com.klinker.android.messaging.MmsFileProvider").path(fileName).scheme("content").build();
                                    Intent download = new Intent("com.klinker.android.messaging.MMS_RECEIVED");
                                    download.putExtra("file_path", mDownloadFile.getPath());
                                    download.putExtra("location_url", location);
                                    PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)download, (int)0);
                                    Bundle configOverrides = new Bundle();
                                    configOverrides.putBoolean("enableGroupMms", group);
                                    SmsManager.getDefault().downloadMultimediaMessage(this.mContext, location, contentUri, null, pendingIntent);
                                    break;
                                }
                                Log.v((String)PushReceiver.TAG, (String)"receiving with lollipop method");
                                MmsRequestManager requestManager = new MmsRequestManager(this.mContext);
                                DownloadRequest request = new DownloadRequest(requestManager, Utils.getDefaultSubscriptionId(), location, uri, null, null, null, this.mContext);
                                MmsNetworkManager manager = new MmsNetworkManager(this.mContext, Utils.getDefaultSubscriptionId());
                                request.execute(this.mContext, manager);
                                break;
                            }
                            if (NotificationTransaction.allowAutoDownload(this.mContext)) {
                                Intent svc = new Intent(this.mContext, TransactionService.class);
                                svc.putExtra("uri", uri.toString());
                                svc.putExtra("type", 0);
                                svc.putExtra("receive_with_new_method", Build.VERSION.SDK_INT >= 21);
                                this.mContext.startService(svc);
                                break;
                            }
                            Intent notificationBroadcast = new Intent("com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                            notificationBroadcast.putExtra("receive_through_stock", true);
                            this.mContext.sendBroadcast(notificationBroadcast);
                            break;
                        }
                        Log.v((String)PushReceiver.TAG, (String)("Skip downloading duplicate message: " + new String(nInd.getContentLocation())));
                        break;
                    }
                    default: {
                        Log.e((String)PushReceiver.TAG, (String)"Received unrecognized PDU.");
                    }
                }
            }
            catch (MmsException e) {
                Log.e((String)PushReceiver.TAG, (String)("Failed to save the data from PUSH: type=" + type), (Throwable)e);
            }
            catch (RuntimeException e) {
                Log.e((String)PushReceiver.TAG, (String)"Unexpected RuntimeException.", (Throwable)e);
            }
            Log.v((String)PushReceiver.TAG, (String)"PUSH Intent processed.");
            return null;
        }
    }
}

