/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Telephony;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.mms.service_alt.DownloadRequest;
import com.android.mms.service_alt.MmsConfig;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.util_alt.SqliteWrapper;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;

public class MmsReceivedReceiver
extends BroadcastReceiver {
    private static final String TAG = "MmsReceivedReceiver";
    public static final String MMS_RECEIVED = "com.klinker.android.messaging.MMS_RECEIVED";
    public static final String EXTRA_FILE_PATH = "file_path";
    public static final String EXTRA_LOCATION_URL = "location_url";

    public void onReceive(Context context, Intent intent) {
        Log.v((String)TAG, (String)"MMS has finished downloading, persisting it to the database");
        String path = intent.getStringExtra(EXTRA_FILE_PATH);
        Log.v((String)TAG, (String)path);
        try {
            File mDownloadFile = new File(path);
            int nBytes = (int)mDownloadFile.length();
            FileInputStream reader = new FileInputStream(mDownloadFile);
            byte[] response = new byte[nBytes];
            reader.read(response, 0, nBytes);
            Uri uri = DownloadRequest.persist(context, response, new MmsConfig.Overridden(new MmsConfig(context), null), intent.getStringExtra(EXTRA_LOCATION_URL), Utils.getDefaultSubscriptionId(), null);
            Log.v((String)TAG, (String)"response saved successfully");
            Log.v((String)TAG, (String)("response length: " + response.length));
            mDownloadFile.delete();
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"MMS received, file not found exception", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"MMS received, io exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workaroundForFi(Context context, Uri uri) {
        TelephonyManager manager;
        String carrierName;
        String msgId = uri.getLastPathSegment();
        Uri.Builder builder = Telephony.Mms.CONTENT_URI.buildUpon();
        builder.appendPath(msgId).appendPath("addr");
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), builder.build(), new String[]{"address", "charset", "type", "_id"}, null, null, null);
        HashSet<String> recipients = new HashSet<String>();
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    do {
                        String from;
                        if (TextUtils.isEmpty((CharSequence)(from = cursor.getString(0)))) continue;
                        byte[] bytes = PduPersister.getBytes(from);
                        int charset = cursor.getInt(1);
                        int type = cursor.getInt(2);
                        long id2 = cursor.getLong(3);
                        Log.v((String)"MMS_address", (String)(new EncodedStringValue(charset, bytes).getString() + " " + type + " " + id2));
                        if (type != 130 && type != 129 && type != 137 && type != 151) continue;
                        recipients.add(new EncodedStringValue(charset, bytes).getString());
                    } while (cursor.moveToNext());
                }
            }
            finally {
                cursor.close();
            }
        }
        if ((carrierName = (manager = (TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName()).equals("Fi Network")) {
            Log.v((String)TAG, (String)"on project fi, which hasn't been working for group messages, so work around it");
            String myPhoneNumber = Utils.getMyPhoneNumber(context);
            if (!recipients.contains(myPhoneNumber)) {
                // empty if block
            }
            for (String recipient : recipients) {
                Log.v((String)TAG, (String)("recipient: " + recipient));
            }
            if (recipients.size() > 1) {
                cursor = SqliteWrapper.query(context, context.getContentResolver(), uri, new String[]{"thread_id"}, null, null, null);
                long threadId = -1L;
                long actualThreadId = Utils.getOrCreateThreadId(context, recipients);
                if (cursor != null && cursor.moveToFirst()) {
                    threadId = cursor.getLong(0);
                    cursor.close();
                }
                Log.v((String)TAG, (String)("found " + recipients.size() + " recipients of the message"));
                Log.v((String)TAG, (String)("thread id should be " + actualThreadId + " and actually is " + threadId));
                if (threadId != actualThreadId && Utils.doesThreadIdExist(context, actualThreadId)) {
                    Log.v((String)TAG, (String)"thread ids do not match, so switching it to the correct thread");
                    ContentValues values = new ContentValues(1);
                    values.put("thread_id", Long.valueOf(actualThreadId));
                    context.getContentResolver().update(uri, values, null, null);
                }
            }
        }
    }
}

