/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.android.mms.service_alt.ApnSettings;
import com.android.mms.service_alt.MmsHttpClient;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.MmsRequest;
import com.android.mms.service_alt.exception.MmsHttpException;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.SendConf;
import com.google.android.mms.pdu_alt.SendReq;
import com.google.android.mms.util_alt.SqliteWrapper;
import com.klinker.android.logger.Log;

public class SendRequest
extends MmsRequest {
    private static final String TAG = "SendRequest";
    private final Uri mPduUri;
    private byte[] mPduData;
    private final String mLocationUrl;
    private final PendingIntent mSentIntent;

    public SendRequest(MmsRequest.RequestManager manager, int subId, Uri contentUri, String locationUrl, PendingIntent sentIntent, String creator, Bundle configOverrides) {
        super(manager, subId, creator, configOverrides);
        this.mPduUri = contentUri;
        this.mPduData = null;
        this.mLocationUrl = locationUrl;
        this.mSentIntent = sentIntent;
    }

    @Override
    protected byte[] doHttp(Context context, MmsNetworkManager netMgr, ApnSettings apn) throws MmsHttpException {
        MmsHttpClient mmsHttpClient = netMgr.getOrCreateHttpClient();
        if (mmsHttpClient == null) {
            Log.e((String)TAG, (String)"MMS network is not ready!");
            throw new MmsHttpException(0, "MMS network is not ready");
        }
        return mmsHttpClient.execute(this.mLocationUrl != null ? this.mLocationUrl : apn.getMmscUrl(), this.mPduData, "POST", apn.isProxySet(), apn.getProxyAddress(), apn.getProxyPort(), this.mMmsConfig);
    }

    @Override
    protected PendingIntent getPendingIntent() {
        return this.mSentIntent;
    }

    @Override
    protected int getQueueType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Uri persistIfRequired(Context context, int result, byte[] response) {
        Log.d((String)TAG, (String)"SendRequest.persistIfRequired");
        if (this.mPduData == null) {
            Log.e((String)TAG, (String)"SendRequest.persistIfRequired: empty PDU");
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            boolean supportContentDisposition = this.mMmsConfig.getSupportMmsContentDisposition();
            GenericPdu pdu = new PduParser(this.mPduData, supportContentDisposition).parse();
            if (pdu == null) {
                Log.e((String)TAG, (String)"SendRequest.persistIfRequired: can't parse input PDU");
                Uri uri = null;
                return uri;
            }
            if (!(pdu instanceof SendReq)) {
                Log.d((String)TAG, (String)"SendRequest.persistIfRequired: not SendReq");
                Uri uri = null;
                return uri;
            }
            ContentValues values = new ContentValues();
            SendConf sendConf = null;
            if (response != null && response.length > 0 && (pdu = new PduParser(response, supportContentDisposition).parse()) != null && pdu instanceof SendConf) {
                sendConf = (SendConf)pdu;
            }
            if (result != -1 || sendConf == null || sendConf.getResponseStatus() != 128) {
                values.put("msg_box", Integer.valueOf(5));
            } else {
                values.put("msg_box", Integer.valueOf(2));
            }
            if (sendConf != null) {
                values.put("resp_st", Integer.valueOf(sendConf.getResponseStatus()));
                Log.v((String)TAG, (String)("response status: " + sendConf.getResponseStatus()));
                values.put("m_id", PduPersister.toIsoString(sendConf.getMessageId()));
            }
            values.put("date", Long.valueOf(System.currentTimeMillis() / 1000L));
            values.put("read", Integer.valueOf(1));
            values.put("seen", Integer.valueOf(1));
            if (!TextUtils.isEmpty((CharSequence)this.mCreator)) {
                values.put("creator", this.mCreator);
            }
            if (Build.VERSION.SDK_INT >= 22) {
                values.put("sub_id", Integer.valueOf(this.mSubId));
            }
            if (SqliteWrapper.update(context, context.getContentResolver(), this.mPduUri, values, null, null) != 1) {
                Log.e((String)TAG, (String)"SendRequest.persistIfRequired: failed to update message");
            }
            Uri uri = this.mPduUri;
            return uri;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"SendRequest.persistIfRequired: unexpected parsing failure", (Throwable)e);
        }
        finally {
            Binder.restoreCallingIdentity((long)identity);
        }
        return null;
    }

    private boolean readPduFromContentUri() {
        if (this.mPduData != null) {
            return true;
        }
        int bytesTobeRead = this.mMmsConfig.getMaxMessageSize();
        this.mPduData = this.mRequestManager.readPduFromContentUri(this.mPduUri, bytesTobeRead);
        return this.mPduData != null;
    }

    @Override
    protected boolean transferResponse(Intent fillIn, byte[] response) {
        if (response != null) {
            fillIn.putExtra("android.telephony.extra.MMS_DATA", response);
        }
        return true;
    }

    @Override
    protected boolean prepareForHttpRequest() {
        return this.readPduFromContentUri();
    }

    public void trySendingByCarrierApp(Context context, String carrierMessagingServicePackage) {
    }

    @Override
    protected void revokeUriPermission(Context context) {
        try {
            context.revokeUriPermission(this.mPduUri, 1);
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"error revoking permissions", (Throwable)e);
        }
    }
}

