/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.android.mms.service_alt.DownloadRequest;
import com.android.mms.service_alt.MmsConfig;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MmsReceivedReceiver
extends BroadcastReceiver {
    private static final String TAG = "MmsReceivedReceiver";
    public static final String MMS_RECEIVED = "com.klinker.android.messaging.MMS_RECEIVED";
    public static final String EXTRA_FILE_PATH = "file_path";
    public static final String EXTRA_LOCATION_URL = "location_url";

    public void onReceive(Context context, Intent intent) {
        Log.v((String)TAG, (String)"MMS has finished downloading, persisting it to the database");
        String path = intent.getStringExtra(EXTRA_FILE_PATH);
        Log.v((String)TAG, (String)path);
        try {
            File mDownloadFile = new File(path);
            int nBytes = (int)mDownloadFile.length();
            FileInputStream reader = new FileInputStream(mDownloadFile);
            byte[] response = new byte[nBytes];
            reader.read(response, 0, nBytes);
            DownloadRequest.persist(context, response, new MmsConfig.Overridden(new MmsConfig(context), null), intent.getStringExtra(EXTRA_LOCATION_URL), Utils.getDefaultSubscriptionId(), null);
            Log.v((String)TAG, (String)"response saved successfully");
            Log.v((String)TAG, (String)("response length: " + response.length));
            mDownloadFile.delete();
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"MMS received, file not found exception", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"MMS received, io exception", (Throwable)e);
        }
    }
}

