/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil;

import com.android.mms.dom.events.EventImpl;
import com.android.mms.dom.smil.ElementTimeImpl;
import com.android.mms.dom.smil.SmilDocumentImpl;
import com.android.mms.dom.smil.SmilElementImpl;
import com.android.mms.dom.smil.SmilParElementImpl;
import com.klinker.android.logger.Log;
import org.w3c.dom.DOMException;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.smil.ElementTime;
import org.w3c.dom.smil.SMILMediaElement;
import org.w3c.dom.smil.TimeList;

public class SmilMediaElementImpl
extends SmilElementImpl
implements SMILMediaElement {
    public static final String SMIL_MEDIA_START_EVENT = "SmilMediaStart";
    public static final String SMIL_MEDIA_END_EVENT = "SmilMediaEnd";
    public static final String SMIL_MEDIA_PAUSE_EVENT = "SmilMediaPause";
    public static final String SMIL_MEDIA_SEEK_EVENT = "SmilMediaSeek";
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    ElementTime mElementTime = new ElementTimeImpl(this){

        private Event createEvent(String eventType) {
            DocumentEvent doc = (DocumentEvent)((Object)SmilMediaElementImpl.this.getOwnerDocument());
            Event event = doc.createEvent("Event");
            event.initEvent(eventType, false, false);
            return event;
        }

        private Event createEvent(String eventType, int seekTo) {
            DocumentEvent doc = (DocumentEvent)((Object)SmilMediaElementImpl.this.getOwnerDocument());
            EventImpl event = (EventImpl)doc.createEvent("Event");
            event.initEvent(eventType, false, false, seekTo);
            return event;
        }

        @Override
        public boolean beginElement() {
            Event startEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_START_EVENT);
            SmilMediaElementImpl.this.dispatchEvent(startEvent);
            return true;
        }

        @Override
        public boolean endElement() {
            Event endEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_END_EVENT);
            SmilMediaElementImpl.this.dispatchEvent(endEvent);
            return true;
        }

        @Override
        public void resumeElement() {
            Event resumeEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_START_EVENT);
            SmilMediaElementImpl.this.dispatchEvent(resumeEvent);
        }

        @Override
        public void pauseElement() {
            Event pauseEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_PAUSE_EVENT);
            SmilMediaElementImpl.this.dispatchEvent(pauseEvent);
        }

        @Override
        public void seekElement(float seekTo) {
            Event seekEvent = this.createEvent(SmilMediaElementImpl.SMIL_MEDIA_SEEK_EVENT, (int)seekTo);
            SmilMediaElementImpl.this.dispatchEvent(seekEvent);
        }

        @Override
        public float getDur() {
            float dur = super.getDur();
            if (dur == 0.0f) {
                String tag = SmilMediaElementImpl.this.getTagName();
                if (tag.equals("video") || tag.equals("audio")) {
                    dur = -1.0f;
                } else if (tag.equals("text") || tag.equals("img")) {
                    dur = 0.0f;
                } else {
                    Log.w((String)SmilMediaElementImpl.TAG, (String)"Unknown media type");
                }
            }
            return dur;
        }

        @Override
        ElementTime getParentElementTime() {
            return ((SmilParElementImpl)this.mSmilElement.getParentNode()).mParTimeContainer;
        }
    };

    SmilMediaElementImpl(SmilDocumentImpl owner, String tagName) {
        super(owner, tagName);
    }

    @Override
    public String getAbstractAttr() {
        return this.getAttribute("abstract");
    }

    @Override
    public String getAlt() {
        return this.getAttribute("alt");
    }

    @Override
    public String getAuthor() {
        return this.getAttribute("author");
    }

    @Override
    public String getClipBegin() {
        return this.getAttribute("clipBegin");
    }

    @Override
    public String getClipEnd() {
        return this.getAttribute("clipEnd");
    }

    @Override
    public String getCopyright() {
        return this.getAttribute("copyright");
    }

    @Override
    public String getLongdesc() {
        return this.getAttribute("longdesc");
    }

    @Override
    public String getPort() {
        return this.getAttribute("port");
    }

    @Override
    public String getReadIndex() {
        return this.getAttribute("readIndex");
    }

    @Override
    public String getRtpformat() {
        return this.getAttribute("rtpformat");
    }

    @Override
    public String getSrc() {
        return this.getAttribute("src");
    }

    @Override
    public String getStripRepeat() {
        return this.getAttribute("stripRepeat");
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public String getTransport() {
        return this.getAttribute("transport");
    }

    @Override
    public String getType() {
        return this.getAttribute("type");
    }

    @Override
    public void setAbstractAttr(String abstractAttr) throws DOMException {
        this.setAttribute("abstract", abstractAttr);
    }

    @Override
    public void setAlt(String alt) throws DOMException {
        this.setAttribute("alt", alt);
    }

    @Override
    public void setAuthor(String author) throws DOMException {
        this.setAttribute("author", author);
    }

    @Override
    public void setClipBegin(String clipBegin) throws DOMException {
        this.setAttribute("clipBegin", clipBegin);
    }

    @Override
    public void setClipEnd(String clipEnd) throws DOMException {
        this.setAttribute("clipEnd", clipEnd);
    }

    @Override
    public void setCopyright(String copyright) throws DOMException {
        this.setAttribute("copyright", copyright);
    }

    @Override
    public void setLongdesc(String longdesc) throws DOMException {
        this.setAttribute("longdesc", longdesc);
    }

    @Override
    public void setPort(String port) throws DOMException {
        this.setAttribute("port", port);
    }

    @Override
    public void setReadIndex(String readIndex) throws DOMException {
        this.setAttribute("readIndex", readIndex);
    }

    @Override
    public void setRtpformat(String rtpformat) throws DOMException {
        this.setAttribute("rtpformat", rtpformat);
    }

    @Override
    public void setSrc(String src) throws DOMException {
        this.setAttribute("src", src);
    }

    @Override
    public void setStripRepeat(String stripRepeat) throws DOMException {
        this.setAttribute("stripRepeat", stripRepeat);
    }

    @Override
    public void setTitle(String title) throws DOMException {
        this.setAttribute("title", title);
    }

    @Override
    public void setTransport(String transport) throws DOMException {
        this.setAttribute("transport", transport);
    }

    @Override
    public void setType(String type) throws DOMException {
        this.setAttribute("type", type);
    }

    @Override
    public boolean beginElement() {
        return this.mElementTime.beginElement();
    }

    @Override
    public boolean endElement() {
        return this.mElementTime.endElement();
    }

    @Override
    public TimeList getBegin() {
        return this.mElementTime.getBegin();
    }

    @Override
    public float getDur() {
        return this.mElementTime.getDur();
    }

    @Override
    public TimeList getEnd() {
        return this.mElementTime.getEnd();
    }

    @Override
    public short getFill() {
        return this.mElementTime.getFill();
    }

    @Override
    public short getFillDefault() {
        return this.mElementTime.getFillDefault();
    }

    @Override
    public float getRepeatCount() {
        return this.mElementTime.getRepeatCount();
    }

    @Override
    public float getRepeatDur() {
        return this.mElementTime.getRepeatDur();
    }

    @Override
    public short getRestart() {
        return this.mElementTime.getRestart();
    }

    @Override
    public void pauseElement() {
        this.mElementTime.pauseElement();
    }

    @Override
    public void resumeElement() {
        this.mElementTime.resumeElement();
    }

    @Override
    public void seekElement(float seekTo) {
        this.mElementTime.seekElement(seekTo);
    }

    @Override
    public void setBegin(TimeList begin) throws DOMException {
        this.mElementTime.setBegin(begin);
    }

    @Override
    public void setDur(float dur) throws DOMException {
        this.mElementTime.setDur(dur);
    }

    @Override
    public void setEnd(TimeList end) throws DOMException {
        this.mElementTime.setEnd(end);
    }

    @Override
    public void setFill(short fill) throws DOMException {
        this.mElementTime.setFill(fill);
    }

    @Override
    public void setFillDefault(short fillDefault) throws DOMException {
        this.mElementTime.setFillDefault(fillDefault);
    }

    @Override
    public void setRepeatCount(float repeatCount) throws DOMException {
        this.mElementTime.setRepeatCount(repeatCount);
    }

    @Override
    public void setRepeatDur(float repeatDur) throws DOMException {
        this.mElementTime.setRepeatDur(repeatDur);
    }

    @Override
    public void setRestart(short restart) throws DOMException {
        this.mElementTime.setRestart(restart);
    }
}

