/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.text.TextUtils;
import com.android.mms.MmsConfig;
import com.klinker.android.logger.Log;
import java.io.File;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class DownloadManager {
    private static final String TAG = "DownloadManager";
    private static DownloadManager ourInstance = new DownloadManager();
    private static final ConcurrentHashMap<String, MmsDownloadReceiver> mMap = new ConcurrentHashMap();

    public static DownloadManager getInstance() {
        return ourInstance;
    }

    private DownloadManager() {
    }

    void downloadMultimediaMessage(Context context, String location) {
        MmsDownloadReceiver receiver = mMap.get(location);
        if (receiver != null) {
            return;
        }
        receiver = new MmsDownloadReceiver();
        mMap.put(location, receiver);
        context.getApplicationContext().registerReceiver((BroadcastReceiver)receiver, new IntentFilter(receiver.mAction));
        Log.v((String)TAG, (String)"receiving with system method");
        String fileName = "download." + String.valueOf(Math.abs(new Random().nextLong())) + ".dat";
        File mDownloadFile = new File(context.getCacheDir(), fileName);
        Uri contentUri = new Uri.Builder().authority(context.getPackageName() + ".MmsFileProvider").path(fileName).scheme("content").build();
        Intent download = new Intent(receiver.mAction);
        download.putExtra("file_path", mDownloadFile.getPath());
        download.putExtra("location_url", location);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)download, (int)0x10000000);
        Bundle configOverrides = new Bundle();
        String httpParams = MmsConfig.getHttpParams();
        if (!TextUtils.isEmpty((CharSequence)httpParams)) {
            configOverrides.putString("httpParams", httpParams);
        }
        SmsManager.getDefault().downloadMultimediaMessage(context, location, contentUri, configOverrides, pendingIntent);
    }

    private static class MmsDownloadReceiver
    extends BroadcastReceiver {
        private static final String ACTION_PREFIX = "com.android.mms.transaction.DownloadManager$MmsDownloadReceiver.";
        private final String mAction = "com.android.mms.transaction.DownloadManager$MmsDownloadReceiver." + UUID.randomUUID().toString();

        MmsDownloadReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            context.unregisterReceiver((BroadcastReceiver)this);
            String location = intent.getStringExtra("location_url");
            mMap.remove(location);
            Intent newIntent = (Intent)intent.clone();
            newIntent.setAction("com.klinker.android.messaging.MMS_RECEIVED");
            context.sendBroadcast(newIntent);
        }
    }
}

