/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.util_alt;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.widget.Toast;
import com.klinker.android.logger.Log;

public final class SqliteWrapper {
    private static final String TAG = "SqliteWrapper";
    private static final String SQLITE_EXCEPTION_DETAIL_MESSAGE = "unable to open database file";

    private SqliteWrapper() {
    }

    private static boolean isLowMemory(Context context) {
        if (null == context) {
            return false;
        }
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo outInfo = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(outInfo);
        return outInfo.lowMemory;
    }

    private static boolean isLowMemory(SQLiteException e) {
        return e.getMessage().equals(SQLITE_EXCEPTION_DETAIL_MESSAGE);
    }

    public static void checkSQLiteException(Context context, SQLiteException e) {
        if (!SqliteWrapper.isLowMemory(e)) {
            throw e;
        }
        Toast.makeText((Context)context, (CharSequence)"Low Memory", (int)0).show();
    }

    public static Cursor query(Context context, ContentResolver resolver, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            return resolver.query(uri, projection, selection, selectionArgs, sortOrder);
        }
        catch (SQLiteException e) {
            Log.e((String)TAG, (String)"Catch a SQLiteException when query: ", (Throwable)e);
            SqliteWrapper.checkSQLiteException(context, e);
            return null;
        }
    }

    public static boolean requery(Context context, Cursor cursor) {
        try {
            return cursor.requery();
        }
        catch (SQLiteException e) {
            Log.e((String)TAG, (String)"Catch a SQLiteException when requery: ", (Throwable)e);
            SqliteWrapper.checkSQLiteException(context, e);
            return false;
        }
    }

    public static int update(Context context, ContentResolver resolver, Uri uri, ContentValues values, String where, String[] selectionArgs) {
        try {
            return resolver.update(uri, values, where, selectionArgs);
        }
        catch (SQLiteException e) {
            Log.e((String)TAG, (String)"Catch a SQLiteException when update: ", (Throwable)e);
            SqliteWrapper.checkSQLiteException(context, e);
            return -1;
        }
    }

    public static int delete(Context context, ContentResolver resolver, Uri uri, String where, String[] selectionArgs) {
        try {
            return resolver.delete(uri, where, selectionArgs);
        }
        catch (SQLiteException e) {
            Log.e((String)TAG, (String)"Catch a SQLiteException when delete: ", (Throwable)e);
            SqliteWrapper.checkSQLiteException(context, e);
            return -1;
        }
    }

    public static Uri insert(Context context, ContentResolver resolver, Uri uri, ContentValues values) {
        try {
            return resolver.insert(uri, values);
        }
        catch (SQLiteException e) {
            Log.e((String)TAG, (String)"Catch a SQLiteException when insert: ", (Throwable)e);
            SqliteWrapper.checkSQLiteException(context, e);
            return null;
        }
    }
}

