/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.provider.Telephony;
import com.android.mms.service_alt.DownloadRequest;
import com.android.mms.service_alt.MmsConfig;
import com.android.mms.transaction.DownloadManager;
import com.google.android.mms.util_alt.SqliteWrapper;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MmsReceivedReceiver
extends BroadcastReceiver {
    private static final String TAG = "MmsReceivedReceiver";
    public static final String MMS_RECEIVED = "com.klinker.android.messaging.MMS_RECEIVED";
    public static final String EXTRA_FILE_PATH = "file_path";
    public static final String EXTRA_LOCATION_URL = "location_url";
    private static final String LOCATION_SELECTION = "m_type=? AND ct_l =?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        Log.v((String)TAG, (String)"MMS has finished downloading, persisting it to the database");
        String path = intent.getStringExtra(EXTRA_FILE_PATH);
        Log.v((String)TAG, (String)path);
        FileInputStream reader = null;
        try {
            File mDownloadFile = new File(path);
            int nBytes = (int)mDownloadFile.length();
            reader = new FileInputStream(mDownloadFile);
            byte[] response = new byte[nBytes];
            reader.read(response, 0, nBytes);
            DownloadRequest.persist(context, response, new MmsConfig.Overridden(new MmsConfig(context), null), intent.getStringExtra(EXTRA_LOCATION_URL), Utils.getDefaultSubscriptionId(), null);
            Log.v((String)TAG, (String)"response saved successfully");
            Log.v((String)TAG, (String)("response length: " + response.length));
            mDownloadFile.delete();
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"MMS received, file not found exception", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"MMS received, io exception", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"MMS received, io exception", (Throwable)e);
                }
            }
        }
        this.handleHttpError(context, intent);
        DownloadManager.finishDownload(intent.getStringExtra(EXTRA_LOCATION_URL));
    }

    private void handleHttpError(Context context, Intent intent) {
        int httpError = intent.getIntExtra("android.telephony.extra.MMS_HTTP_STATUS", 0);
        if (httpError == 404) {
            SqliteWrapper.delete(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, LOCATION_SELECTION, new String[]{Integer.toString(130), intent.getStringExtra(EXTRA_LOCATION_URL)});
        }
    }
}

