/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.service_alt.ApnSettings;
import com.android.mms.service_alt.MmsConfig;
import com.android.mms.service_alt.MmsHttpClient;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.MmsRequest;
import com.android.mms.service_alt.SubscriptionIdChecker;
import com.android.mms.service_alt.exception.MmsHttpException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.RetrieveConf;

public class DownloadRequest
extends MmsRequest {
    private static final String TAG = "DownloadRequest";
    private static final String LOCATION_SELECTION = "m_type=? AND ct_l =?";
    static final String[] PROJECTION = new String[]{"ct_l"};
    static final int COLUMN_CONTENT_LOCATION = 0;
    private final String mLocationUrl;
    private final PendingIntent mDownloadedIntent;
    private final Uri mContentUri;

    public DownloadRequest(MmsRequest.RequestManager manager, int subId, String locationUrl, Uri contentUri, PendingIntent downloadedIntent, String creator, Bundle configOverrides, Context context) throws MmsException {
        super(manager, subId, creator, configOverrides);
        this.mLocationUrl = locationUrl == null ? this.getContentLocation(context, contentUri) : locationUrl;
        this.mDownloadedIntent = downloadedIntent;
        this.mContentUri = contentUri;
    }

    @Override
    protected byte[] doHttp(Context context, MmsNetworkManager netMgr, ApnSettings apn) throws MmsHttpException {
        MmsHttpClient mmsHttpClient = netMgr.getOrCreateHttpClient();
        if (mmsHttpClient == null) {
            Log.e((String)TAG, (String)"MMS network is not ready!");
            throw new MmsHttpException(0, "MMS network is not ready");
        }
        return mmsHttpClient.execute(this.mLocationUrl, null, "GET", apn.isProxySet(), apn.getProxyAddress(), apn.getProxyPort(), this.mMmsConfig);
    }

    @Override
    protected PendingIntent getPendingIntent() {
        return this.mDownloadedIntent;
    }

    @Override
    protected int getQueueType() {
        return 1;
    }

    @Override
    protected Uri persistIfRequired(Context context, int result, byte[] response) {
        if (!this.mRequestManager.getAutoPersistingPref()) {
            DownloadRequest.notifyOfDownload(context);
            return null;
        }
        return DownloadRequest.persist(context, response, this.mMmsConfig, this.mLocationUrl, this.mSubId, this.mCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri persist(Context context, byte[] response, MmsConfig.Overridden mmsConfig, String locationUrl, int subId, String creator) {
        DownloadRequest.notifyOfDownload(context);
        Log.d((String)TAG, (String)"DownloadRequest.persistIfRequired");
        if (response == null || response.length < 1) {
            Log.e((String)TAG, (String)"DownloadRequest.persistIfRequired: empty response");
            ContentValues values = new ContentValues(1);
            values.put("retr_st", Integer.valueOf(255));
            com.google.android.mms.util_alt.SqliteWrapper.update(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, values, LOCATION_SELECTION, new String[]{Integer.toString(130), locationUrl});
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            GenericPdu pdu = new PduParser(response, mmsConfig.getSupportMmsContentDisposition()).parse();
            if (pdu == null || !(pdu instanceof RetrieveConf)) {
                Log.e((String)TAG, (String)"DownloadRequest.persistIfRequired: invalid parsed PDU");
                Uri uri = null;
                return uri;
            }
            RetrieveConf retrieveConf = (RetrieveConf)pdu;
            int status = retrieveConf.getRetrieveStatus();
            PduPersister persister = PduPersister.getPduPersister(context);
            Uri messageUri = persister.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, true, true, null);
            if (messageUri == null) {
                Log.e((String)TAG, (String)"DownloadRequest.persistIfRequired: can not persist message");
                Uri uri = null;
                return uri;
            }
            ContentValues values = new ContentValues();
            values.put("date", Long.valueOf(System.currentTimeMillis() / 1000L));
            values.put("read", Integer.valueOf(0));
            values.put("seen", Integer.valueOf(0));
            if (!TextUtils.isEmpty((CharSequence)creator)) {
                values.put("creator", creator);
            }
            if (SubscriptionIdChecker.getInstance(context).canUseSubscriptionId()) {
                values.put("sub_id", Integer.valueOf(subId));
            }
            if (com.google.android.mms.util_alt.SqliteWrapper.update(context, context.getContentResolver(), messageUri, values, null, null) != 1) {
                Log.e((String)TAG, (String)"DownloadRequest.persistIfRequired: can not update message");
            }
            com.google.android.mms.util_alt.SqliteWrapper.delete(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, LOCATION_SELECTION, new String[]{Integer.toString(130), locationUrl});
            Uri uri = messageUri;
            return uri;
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"DownloadRequest.persistIfRequired: can not persist message", (Throwable)e);
        }
        catch (SQLiteException e) {
            Log.e((String)TAG, (String)"DownloadRequest.persistIfRequired: can not update message", (Throwable)e);
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"DownloadRequest.persistIfRequired: can not parse response", (Throwable)e);
        }
        finally {
            Binder.restoreCallingIdentity((long)identity);
        }
        return null;
    }

    private static void notifyOfDownload(Context context) {
        context.sendBroadcast(new Intent("com.klinker.android.messaging.NEW_MMS_DOWNLOADED"));
    }

    @Override
    protected boolean transferResponse(Intent fillIn, byte[] response) {
        return this.mRequestManager.writePduToContentUri(this.mContentUri, response);
    }

    @Override
    protected boolean prepareForHttpRequest() {
        return true;
    }

    public void tryDownloadingByCarrierApp(Context context, String carrierMessagingServicePackage) {
    }

    @Override
    protected void revokeUriPermission(Context context) {
        context.revokeUriPermission(this.mContentUri, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentLocation(Context context, Uri uri) throws MmsException {
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), uri, PROJECTION, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    String location = cursor.getString(0);
                    cursor.close();
                    String string = location;
                    return string;
                }
            }
            finally {
                cursor.close();
            }
        }
        throw new MmsException("Cannot get X-Mms-Content-Location from: " + uri);
    }
}

