/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.SSLCertificateSocketFactory;
import android.os.Build;
import android.os.SystemClock;
import com.android.mms.service_alt.MmsConfigManager;
import com.android.mms.service_alt.MmsHttpClient;
import com.android.mms.service_alt.MmsRequest;
import com.android.mms.service_alt.exception.MmsNetworkException;
import com.klinker.android.logger.Log;
import com.squareup.okhttp.ConnectionPool;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class MmsNetworkManager
implements com.squareup.okhttp.internal.Network {
    private static final String TAG = "MmsNetworkManager";
    private static final int NETWORK_REQUEST_TIMEOUT_MILLIS = 60000;
    private static final int NETWORK_ACQUIRE_TIMEOUT_MILLIS = 65000;
    private static final boolean httpKeepAlive = Boolean.parseBoolean(System.getProperty("http.keepAlive", "true"));
    private static final int httpMaxConnections = httpKeepAlive ? Integer.parseInt(System.getProperty("http.maxConnections", "5")) : 0;
    private static final long httpKeepAliveDurationMs = Long.parseLong(System.getProperty("http.keepAliveDuration", "300000"));
    private final Context mContext;
    private Network mNetwork;
    private int mMmsRequestCount;
    private NetworkRequest mNetworkRequest;
    private ConnectivityManager.NetworkCallback mNetworkCallback;
    private volatile ConnectivityManager mConnectivityManager;
    private ConnectionPool mConnectionPool;
    private MmsHttpClient mMmsHttpClient;
    private final int mSubId;
    private boolean permissionError = false;
    private static final InetAddress[] EMPTY_ADDRESS_ARRAY = new InetAddress[0];

    public MmsNetworkManager(Context context, int subId) {
        this.mContext = context;
        this.mNetworkCallback = null;
        this.mNetwork = null;
        this.mMmsRequestCount = 0;
        this.mConnectivityManager = null;
        this.mConnectionPool = null;
        this.mMmsHttpClient = null;
        this.mSubId = subId;
        this.mNetworkRequest = !MmsRequest.useWifi(context) ? (Build.VERSION.SDK_INT >= 22 ? new NetworkRequest.Builder().addTransportType(0).addCapability(0).setNetworkSpecifier(Integer.toString(this.mSubId)).build() : new NetworkRequest.Builder().addTransportType(0).addCapability(0).build()) : new NetworkRequest.Builder().addCapability(12).build();
        MmsConfigManager.getInstance().init(context);
    }

    public void acquireNetwork() throws MmsNetworkException {
        MmsNetworkManager mmsNetworkManager = this;
        synchronized (mmsNetworkManager) {
            ++this.mMmsRequestCount;
            if (this.mNetwork != null) {
                Log.d((String)TAG, (String)"MmsNetworkManager: already available");
                return;
            }
            Log.d((String)TAG, (String)"MmsNetworkManager: start new network request");
            this.newRequest();
            long shouldEnd = SystemClock.elapsedRealtime() + 65000L;
            long waitTime = 65000L;
            while (waitTime > 0L) {
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {
                    Log.w((String)TAG, (String)"MmsNetworkManager: acquire network wait interrupted");
                }
                if (this.mNetwork != null || this.permissionError) {
                    return;
                }
                waitTime = shouldEnd - SystemClock.elapsedRealtime();
            }
            Log.d((String)TAG, (String)"MmsNetworkManager: timed out");
            this.releaseRequestLocked(this.mNetworkCallback);
            throw new MmsNetworkException("Acquiring network timed out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNetwork() {
        MmsNetworkManager mmsNetworkManager = this;
        synchronized (mmsNetworkManager) {
            if (this.mMmsRequestCount > 0) {
                --this.mMmsRequestCount;
                Log.d((String)TAG, (String)("MmsNetworkManager: release, count=" + this.mMmsRequestCount));
                if (this.mMmsRequestCount < 1) {
                    this.releaseRequestLocked(this.mNetworkCallback);
                }
            }
        }
    }

    private void newRequest() {
        ConnectivityManager connectivityManager = this.getConnectivityManager();
        this.mNetworkCallback = new ConnectivityManager.NetworkCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAvailable(Network network) {
                super.onAvailable(network);
                Log.d((String)MmsNetworkManager.TAG, (String)("NetworkCallbackListener.onAvailable: network=" + network));
                MmsNetworkManager mmsNetworkManager = MmsNetworkManager.this;
                synchronized (mmsNetworkManager) {
                    MmsNetworkManager.this.mNetwork = network;
                    MmsNetworkManager.this.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLost(Network network) {
                super.onLost(network);
                Log.d((String)MmsNetworkManager.TAG, (String)("NetworkCallbackListener.onLost: network=" + network));
                MmsNetworkManager mmsNetworkManager = MmsNetworkManager.this;
                synchronized (mmsNetworkManager) {
                    MmsNetworkManager.this.releaseRequestLocked(this);
                    MmsNetworkManager.this.notifyAll();
                }
            }
        };
        try {
            connectivityManager.requestNetwork(this.mNetworkRequest, this.mNetworkCallback);
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)"permission exception... skipping it for testing purposes", (Throwable)e);
            this.permissionError = true;
        }
    }

    private void releaseRequestLocked(ConnectivityManager.NetworkCallback callback) {
        if (callback != null) {
            ConnectivityManager connectivityManager = this.getConnectivityManager();
            try {
                connectivityManager.unregisterNetworkCallback(callback);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"couldn't unregister", (Throwable)e);
            }
        }
        this.resetLocked();
    }

    private void resetLocked() {
        this.mNetworkCallback = null;
        this.mNetwork = null;
        this.mMmsRequestCount = 0;
        this.mConnectionPool = null;
        this.mMmsHttpClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress[] resolveInetAddresses(String host) throws UnknownHostException {
        Network network = null;
        MmsNetworkManager mmsNetworkManager = this;
        synchronized (mmsNetworkManager) {
            if (this.mNetwork == null) {
                return EMPTY_ADDRESS_ARRAY;
            }
            network = this.mNetwork;
        }
        return network.getAllByName(host);
    }

    private ConnectivityManager getConnectivityManager() {
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        return this.mConnectivityManager;
    }

    private ConnectionPool getOrCreateConnectionPoolLocked() {
        if (this.mConnectionPool == null) {
            this.mConnectionPool = new ConnectionPool(httpMaxConnections, httpKeepAliveDurationMs);
        }
        return this.mConnectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmsHttpClient getOrCreateHttpClient() {
        MmsNetworkManager mmsNetworkManager = this;
        synchronized (mmsNetworkManager) {
            if (this.mMmsHttpClient == null) {
                if (this.mNetwork != null) {
                    this.mMmsHttpClient = new MmsHttpClient(this.mContext, this.mNetwork.getSocketFactory(), this, this.getOrCreateConnectionPoolLocked());
                } else if (this.permissionError) {
                    this.mMmsHttpClient = new MmsHttpClient(this.mContext, (SocketFactory)new SSLCertificateSocketFactory(60000), this, this.getOrCreateConnectionPoolLocked());
                }
            }
            return this.mMmsHttpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApnName() {
        Network network = null;
        MmsNetworkManager mmsNetworkManager = this;
        synchronized (mmsNetworkManager) {
            if (this.mNetwork == null) {
                Log.d((String)TAG, (String)"MmsNetworkManager: getApnName: network not available");
                this.mNetworkRequest = new NetworkRequest.Builder().addCapability(12).build();
                return null;
            }
            network = this.mNetwork;
        }
        String apnName = null;
        ConnectivityManager connectivityManager = this.getConnectivityManager();
        NetworkInfo mmsNetworkInfo = connectivityManager.getNetworkInfo(network);
        if (mmsNetworkInfo != null) {
            apnName = mmsNetworkInfo.getExtraInfo();
        }
        Log.d((String)TAG, (String)("MmsNetworkManager: getApnName: " + apnName));
        return apnName;
    }
}

