/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;

public class LinkAddress
implements Parcelable {
    private final InetAddress address;
    private final int prefixLength;
    public static final Parcelable.Creator<LinkAddress> CREATOR = new Parcelable.Creator<LinkAddress>(){

        public LinkAddress createFromParcel(Parcel in) {
            InetAddress address = null;
            int prefixLength = 0;
            if (in.readByte() == 1) {
                try {
                    address = InetAddress.getByAddress(in.createByteArray());
                    prefixLength = in.readInt();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return new LinkAddress(address, prefixLength);
        }

        public LinkAddress[] newArray(int size) {
            return new LinkAddress[size];
        }
    };

    public LinkAddress(InetAddress address, int prefixLength) {
        if (address == null || prefixLength < 0 || address instanceof Inet4Address && prefixLength > 32 || prefixLength > 128) {
            throw new IllegalArgumentException("Bad LinkAddress haloParams " + address + prefixLength);
        }
        this.address = address;
        this.prefixLength = prefixLength;
    }

    public LinkAddress(InterfaceAddress interfaceAddress) {
        this.address = interfaceAddress.getAddress();
        this.prefixLength = interfaceAddress.getNetworkPrefixLength();
    }

    public String toString() {
        return this.address == null ? "" : this.address.getHostAddress() + "/" + this.prefixLength;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LinkAddress)) {
            return false;
        }
        LinkAddress linkAddress = (LinkAddress)obj;
        return this.address.equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength;
    }

    public int hashCode() {
        return (null == this.address ? 0 : this.address.hashCode()) + this.prefixLength;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getNetworkPrefixLength() {
        return this.prefixLength;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.address != null) {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.address.getAddress());
            dest.writeInt(this.prefixLength);
        } else {
            dest.writeByte((byte)0);
        }
    }
}

