/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.text.TextUtils;
import android.widget.Toast;
import com.android.mms.service_alt.DownloadRequest;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.MmsRequestManager;
import com.android.mms.transaction.DownloadManager;
import com.android.mms.transaction.NotificationTransaction;
import com.android.mms.transaction.Observable;
import com.android.mms.transaction.Observer;
import com.android.mms.transaction.PushReceiver;
import com.android.mms.transaction.ReadRecTransaction;
import com.android.mms.transaction.RetrieveTransaction;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.SendTransaction;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionBundle;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.transaction.TransactionState;
import com.android.mms.util.RateController;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.NotificationInd;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.R;
import com.klinker.android.send_message.Utils;
import java.io.IOException;
import java.util.ArrayList;

public class TransactionService
extends Service
implements Observer {
    private static final String TAG = "Mms";
    public static final String TRANSACTION_COMPLETED_ACTION = "android.intent.action.TRANSACTION_COMPLETED_ACTION";
    public static final String ACTION_ONALARM = "android.intent.action.ACTION_ONALARM";
    public static final String ACTION_ENABLE_AUTO_RETRIEVE = "android.intent.action.ACTION_ENABLE_AUTO_RETRIEVE";
    public static final String STATE = "state";
    public static final String STATE_URI = "uri";
    private static final int EVENT_TRANSACTION_REQUEST = 1;
    private static final int EVENT_CONTINUE_MMS_CONNECTIVITY = 3;
    private static final int EVENT_HANDLE_NEXT_PENDING_TRANSACTION = 4;
    private static final int EVENT_NEW_INTENT = 5;
    private static final int EVENT_QUIT = 100;
    private static final int TOAST_MSG_QUEUED = 1;
    private static final int TOAST_DOWNLOAD_LATER = 2;
    private static final int TOAST_NO_APN = 3;
    private static final int TOAST_NONE = -1;
    private static final int APN_EXTENSION_WAIT = 30000;
    private ServiceHandler mServiceHandler;
    private Looper mServiceLooper;
    private final ArrayList<Transaction> mProcessing = new ArrayList();
    private final ArrayList<Transaction> mPending = new ArrayList();
    private ConnectivityManager mConnMgr;
    private ConnectivityBroadcastReceiver mReceiver;
    private boolean mobileDataEnabled;
    private boolean lollipopReceiving = false;
    private PowerManager.WakeLock mWakeLock;
    public Handler mToastHandler = new Handler(){

        public void handleMessage(Message msg) {
            String str = null;
            if (msg.what == 1) {
                str = TransactionService.this.getString(R.string.message_queued);
            } else if (msg.what == 2) {
                str = TransactionService.this.getString(R.string.download_later);
            } else if (msg.what == 3) {
                str = TransactionService.this.getString(R.string.no_apn);
            }
            if (str != null) {
                Toast.makeText((Context)TransactionService.this, (CharSequence)str, (int)1).show();
            }
        }
    };

    public void onCreate() {
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)"Creating TransactionService");
        }
        if (!Utils.isDefaultSmsApp((Context)this)) {
            Log.v((String)TAG, (String)"not default app, so exiting");
            this.stopSelf();
            return;
        }
        this.initServiceHandler();
        this.mReceiver = new ConnectivityBroadcastReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.registerReceiver(this.mReceiver, intentFilter);
    }

    private void initServiceHandler() {
        HandlerThread thread = new HandlerThread("TransactionService");
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            if (this.mServiceHandler == null) {
                this.initServiceHandler();
            }
            Message msg = this.mServiceHandler.obtainMessage(5);
            msg.arg1 = startId;
            msg.obj = intent;
            this.mServiceHandler.sendMessage(msg);
        }
        return 2;
    }

    private boolean isNetworkAvailable() {
        if (this.mConnMgr == null) {
            return false;
        }
        if (Utils.isMmsOverWifiEnabled((Context)this)) {
            NetworkInfo niWF = this.mConnMgr.getNetworkInfo(1);
            return niWF == null ? false : niWF.isConnected();
        }
        NetworkInfo ni = this.mConnMgr.getNetworkInfo(2);
        return ni == null ? false : ni.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewIntent(Intent intent, int serviceId) {
        String action;
        boolean noNetwork;
        this.mobileDataEnabled = Utils.isMobileDataEnabled((Context)this);
        this.mConnMgr = (ConnectivityManager)this.getSystemService("connectivity");
        if (!this.mobileDataEnabled) {
            Utils.setMobileDataEnabled((Context)this, true);
        }
        if (this.mConnMgr == null) {
            this.endMmsConnectivity();
            this.stopSelf(serviceId);
            return;
        }
        boolean bl = noNetwork = !this.isNetworkAvailable();
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("onNewIntent: serviceId: " + serviceId + ": " + intent.getExtras() + " intent=" + intent));
            Log.v((String)TAG, (String)("    networkAvailable=" + !noNetwork));
        }
        if (ACTION_ONALARM.equals(action = intent.getAction()) || ACTION_ENABLE_AUTO_RETRIEVE.equals(action) || intent.getExtras() == null) {
            Cursor cursor = PduPersister.getPduPersister((Context)this).getPendingMessages(System.currentTimeMillis());
            if (cursor != null) {
                try {
                    int count = cursor.getCount();
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.v((String)TAG, (String)("onNewIntent: cursor.count=" + count + " action=" + action));
                    }
                    if (count == 0) {
                        if (Log.isLoggable((String)TAG, (int)2)) {
                            Log.v((String)TAG, (String)"onNewIntent: no pending messages. Stopping service.");
                        }
                        RetryScheduler.setRetryAlarm((Context)this);
                        this.stopSelfIfIdle(serviceId);
                        return;
                    }
                    int columnIndexOfMsgId = cursor.getColumnIndexOrThrow("msg_id");
                    int columnIndexOfMsgType = cursor.getColumnIndexOrThrow("msg_type");
                    block15: while (cursor.moveToNext()) {
                        Uri uri;
                        int msgType = cursor.getInt(columnIndexOfMsgType);
                        int transactionType = this.getTransactionType(msgType);
                        if (Build.VERSION.SDK_INT >= 21) {
                            boolean useSystem = true;
                            useSystem = com.klinker.android.send_message.Transaction.settings != null ? com.klinker.android.send_message.Transaction.settings.getUseSystemSending() : PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("system_mms_sending", useSystem);
                            if (useSystem) {
                                try {
                                    uri = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)cursor.getLong(columnIndexOfMsgId));
                                    DownloadManager.getInstance().downloadMultimediaMessage((Context)this, PushReceiver.getContentLocation((Context)this, uri));
                                }
                                catch (MmsException e) {
                                    e.printStackTrace();
                                    continue;
                                }
                            }
                            try {
                                uri = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)cursor.getLong(columnIndexOfMsgId));
                                MmsRequestManager requestManager = new MmsRequestManager((Context)this);
                                DownloadRequest request = new DownloadRequest(requestManager, Utils.getDefaultSubscriptionId(), PushReceiver.getContentLocation((Context)this, uri), uri, null, null, null, (Context)this);
                                MmsNetworkManager manager = new MmsNetworkManager((Context)this, Utils.getDefaultSubscriptionId());
                                request.execute((Context)this, manager);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                        }
                        if (Log.isLoggable((String)TAG, (int)2)) {
                            Log.v((String)TAG, (String)("onNewIntent: msgType=" + msgType + " transactionType=" + transactionType));
                        }
                        if (noNetwork) {
                            this.onNetworkUnavailable(serviceId, transactionType);
                            return;
                        }
                        switch (transactionType) {
                            case -1: {
                                continue block15;
                            }
                            case 1: {
                                int failureType = cursor.getInt(cursor.getColumnIndexOrThrow("err_type"));
                                try {
                                    com.android.mms.util.DownloadManager.init((Context)this);
                                    com.android.mms.util.DownloadManager downloadManager = com.android.mms.util.DownloadManager.getInstance();
                                    boolean autoDownload = downloadManager.isAuto();
                                    if (Log.isLoggable((String)TAG, (int)2)) {
                                        Log.v((String)TAG, (String)("onNewIntent: failureType=" + failureType + " action=" + action + " isTransientFailure:" + TransactionService.isTransientFailure(failureType) + " autoDownload=" + autoDownload));
                                    }
                                    if (!autoDownload) {
                                        if (Log.isLoggable((String)TAG, (int)2)) {
                                            Log.v((String)TAG, (String)"onNewIntent: skipping - autodownload off");
                                        }
                                        Uri uri2 = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)cursor.getLong(columnIndexOfMsgId));
                                        downloadManager.markState(uri2, 137);
                                        continue block15;
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (failureType != 0 && !TransactionService.isTransientFailure(failureType)) {
                                    if (!Log.isLoggable((String)TAG, (int)2)) continue block15;
                                    Log.v((String)TAG, (String)"onNewIntent: skipping - permanent error");
                                    continue block15;
                                }
                                if (!Log.isLoggable((String)TAG, (int)2)) break;
                                Log.v((String)TAG, (String)"onNewIntent: falling through and processing");
                            }
                        }
                        uri = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)cursor.getLong(columnIndexOfMsgId));
                        TransactionBundle args = new TransactionBundle(transactionType, uri.toString());
                        if (Log.isLoggable((String)TAG, (int)2)) {
                            Log.v((String)TAG, (String)("onNewIntent: launchTransaction uri=" + uri));
                        }
                        this.launchTransaction(serviceId, args, false);
                    }
                }
                finally {
                    cursor.close();
                }
            } else {
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)"onNewIntent: no pending messages. Stopping service.");
                }
                RetryScheduler.setRetryAlarm((Context)this);
                this.stopSelfIfIdle(serviceId);
            }
        } else {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"onNewIntent: launch transaction...");
            }
            TransactionBundle args = new TransactionBundle(intent.getExtras());
            this.launchTransaction(serviceId, args, noNetwork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSelfIfIdle(int startId) {
        ArrayList<Transaction> arrayList = this.mProcessing;
        synchronized (arrayList) {
            if (this.mProcessing.isEmpty() && this.mPending.isEmpty()) {
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)"stopSelfIfIdle: STOP!");
                }
                this.stopSelf(startId);
            }
        }
    }

    private static boolean isTransientFailure(int type) {
        return type > 0 && type < 10;
    }

    private int getTransactionType(int msgType) {
        switch (msgType) {
            case 130: {
                return 1;
            }
            case 135: {
                return 3;
            }
            case 128: {
                return 2;
            }
        }
        Log.w((String)TAG, (String)("Unrecognized MESSAGE_TYPE: " + msgType));
        return -1;
    }

    private void launchTransaction(int serviceId, TransactionBundle txnBundle, boolean noNetwork) {
        if (noNetwork) {
            Log.w((String)TAG, (String)"launchTransaction: no network error!");
            this.onNetworkUnavailable(serviceId, txnBundle.getTransactionType());
            return;
        }
        Message msg = this.mServiceHandler.obtainMessage(1);
        msg.arg1 = serviceId;
        msg.obj = txnBundle;
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("launchTransaction: sending message " + msg));
        }
        this.mServiceHandler.sendMessage(msg);
    }

    private void onNetworkUnavailable(int serviceId, int transactionType) {
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("onNetworkUnavailable: sid=" + serviceId + ", type=" + transactionType));
        }
        int toastType = -1;
        if (transactionType == 1) {
            toastType = 2;
        } else if (transactionType == 2) {
            toastType = 1;
        }
        if (toastType != -1) {
            this.mToastHandler.sendEmptyMessage(toastType);
        }
        this.stopSelf(serviceId);
    }

    public void onDestroy() {
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)"Destroying TransactionService");
        }
        if (!this.mPending.isEmpty()) {
            Log.w((String)TAG, (String)"TransactionService exiting with transaction still pending");
        }
        this.releaseWakeLock();
        try {
            this.unregisterReceiver(this.mReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mServiceHandler.sendEmptyMessage(100);
        if (!this.mobileDataEnabled && !this.lollipopReceiving) {
            Log.v((String)TAG, (String)"disabling mobile data");
            Utils.setMobileDataEnabled((Context)this, false);
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable) {
        Transaction transaction = (Transaction)observable;
        int serviceId = transaction.getServiceId();
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("update transaction " + serviceId));
        }
        try {
            ArrayList<Transaction> arrayList = this.mProcessing;
            synchronized (arrayList) {
                this.mProcessing.remove(transaction);
                if (this.mPending.size() > 0) {
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.v((String)TAG, (String)"update: handle next pending transaction...");
                    }
                    Message msg = this.mServiceHandler.obtainMessage(4, transaction.getConnectionSettings());
                    this.mServiceHandler.sendMessage(msg);
                } else if (this.mProcessing.isEmpty()) {
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.v((String)TAG, (String)"update: endMmsConnectivity");
                    }
                    this.endMmsConnectivity();
                } else if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)"update: mProcessing is not empty");
                }
            }
            Intent intent = new Intent(TRANSACTION_COMPLETED_ACTION);
            TransactionState state = transaction.getState();
            int result = state.getState();
            intent.putExtra(STATE, result);
            switch (result) {
                case 1: {
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.v((String)TAG, (String)("Transaction complete: " + serviceId));
                    }
                    intent.putExtra(STATE_URI, (Parcelable)state.getContentUri());
                    switch (transaction.getType()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        case 2: {
                            RateController.init(this.getApplicationContext());
                            RateController.getInstance().update();
                        }
                    }
                    break;
                }
                case 2: {
                    if (!Log.isLoggable((String)TAG, (int)2)) break;
                    Log.v((String)TAG, (String)("Transaction failed: " + serviceId));
                    break;
                }
                default: {
                    if (!Log.isLoggable((String)TAG, (int)2)) break;
                    Log.v((String)TAG, (String)("Transaction state unknown: " + serviceId + " " + result));
                }
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("update: broadcast transaction result " + result));
            }
            this.sendBroadcast(intent);
        }
        finally {
            transaction.detach(this);
            this.stopSelfIfIdle(serviceId);
        }
    }

    private synchronized void createWakeLock() {
        if (this.mWakeLock == null) {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            this.mWakeLock = pm.newWakeLock(1, "MMS Connectivity");
            this.mWakeLock.setReferenceCounted(false);
        }
    }

    private void acquireWakeLock() {
        Log.v((String)TAG, (String)"mms acquireWakeLock");
        this.mWakeLock.acquire();
    }

    private void releaseWakeLock() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            Log.v((String)TAG, (String)"mms releaseWakeLock");
            this.mWakeLock.release();
        }
    }

    protected int beginMmsConnectivity() throws IOException {
        NetworkInfo niWF;
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)"beginMmsConnectivity");
        }
        this.createWakeLock();
        if (Utils.isMmsOverWifiEnabled((Context)this) && (niWF = this.mConnMgr.getNetworkInfo(1)) != null && niWF.isConnected()) {
            Log.v((String)TAG, (String)"beginMmsConnectivity: Wifi active");
            return 0;
        }
        int result = this.mConnMgr.startUsingNetworkFeature(0, "enableMMS");
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("beginMmsConnectivity: result=" + result));
        }
        switch (result) {
            case 0: 
            case 1: {
                this.acquireWakeLock();
                return result;
            }
        }
        throw new IOException("Cannot establish MMS connectivity");
    }

    protected void endMmsConnectivity() {
        try {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"endMmsConnectivity");
            }
            this.mServiceHandler.removeMessages(3);
            if (this.mConnMgr != null && Build.VERSION.SDK_INT < 23) {
                this.mConnMgr.stopUsingNetworkFeature(0, "enableMMS");
            }
        }
        finally {
            this.releaseWakeLock();
        }
    }

    private void renewMmsConnectivity() {
        this.mServiceHandler.sendMessageDelayed(this.mServiceHandler.obtainMessage(3), 30000L);
    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private ConnectivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                Log.w((String)TransactionService.TAG, (String)("ConnectivityBroadcastReceiver.onReceive() action: " + action));
            }
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                return;
            }
            NetworkInfo mmsNetworkInfo = null;
            if (TransactionService.this.mConnMgr != null && Utils.isMobileDataEnabled(context).booleanValue()) {
                mmsNetworkInfo = TransactionService.this.mConnMgr.getNetworkInfo(2);
            } else if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                Log.v((String)TransactionService.TAG, (String)"mConnMgr is null, bail");
            }
            if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                Log.v((String)TransactionService.TAG, (String)("Handle ConnectivityBroadcastReceiver.onReceive(): " + mmsNetworkInfo));
            }
            if (mmsNetworkInfo == null) {
                if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                    Log.v((String)TransactionService.TAG, (String)"mms type is null or mobile data is turned off, bail");
                }
            } else {
                if ("2GVoiceCallEnded".equals(mmsNetworkInfo.getReason())) {
                    if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)"   reason is 2GVoiceCallEnded, retrying mms connectivity");
                    }
                    TransactionService.this.renewMmsConnectivity();
                    return;
                }
                if (mmsNetworkInfo.isConnected()) {
                    TransactionSettings settings = new TransactionSettings((Context)TransactionService.this, mmsNetworkInfo.getExtraInfo());
                    if (TextUtils.isEmpty((CharSequence)settings.getMmscUrl())) {
                        Log.v((String)TransactionService.TAG, (String)"   empty MMSC url, bail");
                        TransactionService.this.sendBroadcast(new Intent("com.klinker.android.send_message.MMS_ERROR"));
                        TransactionService.this.mServiceHandler.markAllPendingTransactionsAsFailed();
                        TransactionService.this.endMmsConnectivity();
                        TransactionService.this.stopSelf();
                        return;
                    }
                    TransactionService.this.mServiceHandler.processPendingTransaction(null, settings);
                } else {
                    if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)"   TYPE_MOBILE_MMS not connected, bail");
                    }
                    if (mmsNetworkInfo.isAvailable()) {
                        if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                            Log.v((String)TransactionService.TAG, (String)"   retrying mms connectivity for it's available");
                        }
                        TransactionService.this.renewMmsConnectivity();
                    }
                }
            }
        }
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        private String decodeMessage(Message msg) {
            if (msg.what == 100) {
                return "EVENT_QUIT";
            }
            if (msg.what == 3) {
                return "EVENT_CONTINUE_MMS_CONNECTIVITY";
            }
            if (msg.what == 1) {
                return "EVENT_TRANSACTION_REQUEST";
            }
            if (msg.what == 4) {
                return "EVENT_HANDLE_NEXT_PENDING_TRANSACTION";
            }
            if (msg.what == 5) {
                return "EVENT_NEW_INTENT";
            }
            return "unknown message.what";
        }

        private String decodeTransactionType(int transactionType) {
            if (transactionType == 0) {
                return "NOTIFICATION_TRANSACTION";
            }
            if (transactionType == 1) {
                return "RETRIEVE_TRANSACTION";
            }
            if (transactionType == 2) {
                return "SEND_TRANSACTION";
            }
            if (transactionType == 3) {
                return "READREC_TRANSACTION";
            }
            return "invalid transaction type";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleMessage(Message msg) {
            if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                Log.v((String)TransactionService.TAG, (String)("Handling incoming message: " + msg + " = " + this.decodeMessage(msg)));
            }
            Observable transaction = null;
            switch (msg.what) {
                case 5: {
                    TransactionService.this.onNewIntent((Intent)msg.obj, msg.arg1);
                    return;
                }
                case 100: {
                    this.getLooper().quit();
                    return;
                }
                case 3: {
                    ArrayList arrayList = TransactionService.this.mProcessing;
                    synchronized (arrayList) {
                        if (TransactionService.this.mProcessing.isEmpty()) {
                            return;
                        }
                    }
                    if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)"handle EVENT_CONTINUE_MMS_CONNECTIVITY event...");
                    }
                    try {
                        int result = TransactionService.this.beginMmsConnectivity();
                        if (result != 0) {
                            Log.v((String)TransactionService.TAG, (String)("Extending MMS connectivity returned " + result + " instead of APN_ALREADY_ACTIVE"));
                            return;
                        }
                    }
                    catch (IOException e) {
                        Log.w((String)TransactionService.TAG, (String)"Attempt to extend use of MMS connectivity failed");
                        return;
                    }
                    TransactionService.this.renewMmsConnectivity();
                    return;
                }
                case 1: {
                    Object transactionSettings;
                    int serviceId = msg.arg1;
                    try {
                        String mmsc;
                        TransactionBundle args = (TransactionBundle)msg.obj;
                        if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                            Log.v((String)TransactionService.TAG, (String)("EVENT_TRANSACTION_REQUEST MmscUrl=" + args.getMmscUrl() + " proxy port: " + args.getProxyAddress()));
                        }
                        transactionSettings = (mmsc = args.getMmscUrl()) != null ? new TransactionSettings(mmsc, args.getProxyAddress(), args.getProxyPort()) : new TransactionSettings((Context)TransactionService.this, null);
                        int transactionType = args.getTransactionType();
                        if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                            Log.v((String)TransactionService.TAG, (String)("handle EVENT_TRANSACTION_REQUEST: transactionType=" + transactionType + " " + this.decodeTransactionType(transactionType)));
                        }
                        switch (transactionType) {
                            case 0: {
                                String uri = args.getUri();
                                if (uri != null) {
                                    transaction = new NotificationTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, uri);
                                    break;
                                }
                                byte[] pushData = args.getPushData();
                                PduParser parser = new PduParser(pushData);
                                GenericPdu ind = parser.parse();
                                int type = 130;
                                if (ind == null || ind.getMessageType() != type) {
                                    Log.e((String)TransactionService.TAG, (String)"Invalid PUSH data.");
                                    transaction = null;
                                    return;
                                }
                                transaction = new NotificationTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, (NotificationInd)ind);
                                break;
                            }
                            case 1: {
                                transaction = new RetrieveTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, args.getUri());
                                if (Build.VERSION.SDK_INT < 21) break;
                                Uri u = Uri.parse((String)args.getUri());
                                DownloadManager.getInstance().downloadMultimediaMessage((Context)TransactionService.this, ((RetrieveTransaction)transaction).getContentLocation((Context)TransactionService.this, u));
                                return;
                            }
                            case 2: {
                                transaction = new SendTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, args.getUri());
                                break;
                            }
                            case 3: {
                                transaction = new ReadRecTransaction((Context)TransactionService.this, serviceId, (TransactionSettings)transactionSettings, args.getUri());
                                break;
                            }
                            default: {
                                Log.w((String)TransactionService.TAG, (String)("Invalid transaction type: " + serviceId));
                                transaction = null;
                                return;
                            }
                        }
                        if (!this.processTransaction((Transaction)transaction)) {
                            transaction = null;
                            return;
                        }
                        if (!Log.isLoggable((String)TransactionService.TAG, (int)2)) return;
                        Log.v((String)TransactionService.TAG, (String)("Started processing of incoming message: " + msg));
                        return;
                    }
                    catch (Exception ex) {
                        Log.w((String)TransactionService.TAG, (String)("Exception occurred while handling message: " + msg), (Throwable)ex);
                        if (transaction == null) return;
                        try {
                            transaction.detach(TransactionService.this);
                            if (TransactionService.this.mProcessing.contains(transaction)) {
                                transactionSettings = TransactionService.this.mProcessing;
                                synchronized (transactionSettings) {
                                    TransactionService.this.mProcessing.remove(transaction);
                                }
                            }
                            transaction = null;
                            return;
                        }
                        catch (Throwable t) {
                            try {
                                Log.e((String)TransactionService.TAG, (String)"Unexpected Throwable.", (Throwable)t);
                                return;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                transaction = null;
                            }
                        }
                    }
                    finally {
                        if (transaction == null) {
                            if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                                Log.v((String)TransactionService.TAG, (String)("Transaction was null. Stopping self: " + serviceId));
                            }
                            TransactionService.this.endMmsConnectivity();
                            TransactionService.this.stopSelf(serviceId);
                        }
                    }
                }
                case 4: {
                    this.processPendingTransaction((Transaction)transaction, (TransactionSettings)msg.obj);
                    return;
                }
                default: {
                    Log.w((String)TransactionService.TAG, (String)("what=" + msg.what));
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markAllPendingTransactionsAsFailed() {
            ArrayList arrayList = TransactionService.this.mProcessing;
            synchronized (arrayList) {
                while (TransactionService.this.mPending.size() != 0) {
                    Transaction transaction = (Transaction)TransactionService.this.mPending.remove(0);
                    transaction.mTransactionState.setState(2);
                    if (transaction instanceof SendTransaction) {
                        Uri uri = ((SendTransaction)transaction).mSendReqURI;
                        transaction.mTransactionState.setContentUri(uri);
                        int respStatus = 134;
                        ContentValues values = new ContentValues(1);
                        values.put("resp_st", Integer.valueOf(respStatus));
                        SqliteWrapper.update((Context)TransactionService.this, TransactionService.this.getContentResolver(), uri, values, null, null);
                    }
                    transaction.notifyObservers();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPendingTransaction(Transaction transaction, TransactionSettings settings) {
            block15: {
                if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                    Log.v((String)TransactionService.TAG, (String)("processPendingTxn: transaction=" + transaction));
                }
                int numProcessTransaction = 0;
                ArrayList arrayList = TransactionService.this.mProcessing;
                synchronized (arrayList) {
                    if (TransactionService.this.mPending.size() != 0) {
                        transaction = (Transaction)TransactionService.this.mPending.remove(0);
                    }
                    numProcessTransaction = TransactionService.this.mProcessing.size();
                }
                if (transaction != null) {
                    if (settings != null) {
                        transaction.setConnectionSettings(settings);
                    }
                    try {
                        int serviceId = transaction.getServiceId();
                        if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                            Log.v((String)TransactionService.TAG, (String)("processPendingTxn: process " + serviceId));
                        }
                        if (this.processTransaction(transaction)) {
                            if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                                Log.v((String)TransactionService.TAG, (String)("Started deferred processing of transaction  " + transaction));
                            }
                            break block15;
                        }
                        transaction = null;
                        TransactionService.this.stopSelf(serviceId);
                    }
                    catch (IOException e) {
                        Log.w((String)TransactionService.TAG, (String)e.getMessage(), (Throwable)e);
                    }
                } else if (numProcessTransaction == 0) {
                    if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)"processPendingTxn: no more transaction, endMmsConnectivity");
                    }
                    TransactionService.this.endMmsConnectivity();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processTransaction(Transaction transaction) throws IOException {
            ArrayList arrayList = TransactionService.this.mProcessing;
            synchronized (arrayList) {
                int connectivityResult;
                for (Transaction t : TransactionService.this.mPending) {
                    if (!t.isEquivalent(transaction)) continue;
                    if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)("Transaction already pending: " + transaction.getServiceId()));
                    }
                    return true;
                }
                for (Transaction t : TransactionService.this.mProcessing) {
                    if (!t.isEquivalent(transaction)) continue;
                    if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)("Duplicated transaction: " + transaction.getServiceId()));
                    }
                    return true;
                }
                if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                    Log.v((String)TransactionService.TAG, (String)"processTransaction: call beginMmsConnectivity...");
                }
                if ((connectivityResult = TransactionService.this.beginMmsConnectivity()) == 1) {
                    TransactionService.this.mPending.add(transaction);
                    if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)"processTransaction: connResult=APN_REQUEST_STARTED, defer transaction pending MMS connectivity");
                    }
                    return true;
                }
                if (TransactionService.this.mProcessing.size() > 0) {
                    if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                        Log.v((String)TransactionService.TAG, (String)("Adding transaction to 'mPending' list: " + transaction));
                    }
                    TransactionService.this.mPending.add(transaction);
                    return true;
                }
                if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                    Log.v((String)TransactionService.TAG, (String)("Adding transaction to 'mProcessing' list: " + transaction));
                }
                TransactionService.this.mProcessing.add(transaction);
            }
            this.sendMessageDelayed(this.obtainMessage(3), 30000L);
            if (Log.isLoggable((String)TransactionService.TAG, (int)2)) {
                Log.v((String)TransactionService.TAG, (String)("processTransaction: starting transaction " + transaction));
            }
            transaction.attach(TransactionService.this);
            transaction.process();
            return true;
        }
    }
}

