/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom;

import com.android.mms.dom.DocumentImpl;
import com.android.mms.dom.NamedNodeMapImpl;
import com.android.mms.dom.NodeImpl;
import com.android.mms.dom.NodeListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    private String mTagName;
    private NamedNodeMap mAttributes = new NamedNodeMapImpl();

    protected ElementImpl(DocumentImpl owner, String tagName) {
        super(owner);
        this.mTagName = tagName;
    }

    @Override
    public String getAttribute(String name) {
        Attr attrNode = this.getAttributeNode(name);
        String attrValue = "";
        if (attrNode != null) {
            attrValue = attrNode.getValue();
        }
        return attrValue;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public Attr getAttributeNode(String name) {
        return (Attr)this.mAttributes.getNamedItem(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        return new NodeListImpl(this, name, true);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public String getTagName() {
        return this.mTagName;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return false;
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return null;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        Attr attribute = this.getAttributeNode(name);
        if (attribute == null) {
            attribute = this.mOwnerDocument.createAttribute(name);
        }
        attribute.setNodeValue(value);
        this.mAttributes.setNamedItem(attribute);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return null;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.mTagName;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.mAttributes;
    }

    @Override
    public boolean hasAttributes() {
        return this.mAttributes.getLength() > 0;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(9, null);
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, null);
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(9, null);
    }
}

