/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.ProxyProperties;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LinkProperties
implements Parcelable {
    String mIfaceName;
    private Collection<LinkAddress> mLinkAddresses = new ArrayList<LinkAddress>();
    private Collection<InetAddress> mDnses = new ArrayList<InetAddress>();
    private Collection<RouteInfo> mRoutes = new ArrayList<RouteInfo>();
    private ProxyProperties mHttpProxy;
    public static final Parcelable.Creator<LinkProperties> CREATOR = new Parcelable.Creator<LinkProperties>(){

        public LinkProperties createFromParcel(Parcel in) {
            int i;
            LinkProperties netProp = new LinkProperties();
            String iface = in.readString();
            if (iface != null) {
                try {
                    netProp.setInterfaceName(iface);
                }
                catch (Exception e) {
                    return null;
                }
            }
            int addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                netProp.addLinkAddress((LinkAddress)in.readParcelable(null));
            }
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                try {
                    netProp.addDns(InetAddress.getByAddress(in.createByteArray()));
                    continue;
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                netProp.addRoute((RouteInfo)in.readParcelable(null));
            }
            if (in.readByte() == 1) {
                netProp.setHttpProxy((ProxyProperties)in.readParcelable(null));
            }
            return netProp;
        }

        public LinkProperties[] newArray(int size) {
            return new LinkProperties[size];
        }
    };

    public LinkProperties() {
        this.clear();
    }

    public LinkProperties(LinkProperties source) {
        if (source != null) {
            this.mIfaceName = source.getInterfaceName();
            for (LinkAddress l : source.getLinkAddresses()) {
                this.mLinkAddresses.add(l);
            }
            for (InetAddress i : source.getDnses()) {
                this.mDnses.add(i);
            }
            for (RouteInfo r : source.getRoutes()) {
                this.mRoutes.add(r);
            }
            this.mHttpProxy = source.getHttpProxy() == null ? null : new ProxyProperties(source.getHttpProxy());
        }
    }

    public void setInterfaceName(String iface) {
        this.mIfaceName = iface;
    }

    public String getInterfaceName() {
        return this.mIfaceName;
    }

    public Collection<InetAddress> getAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        return Collections.unmodifiableCollection(addresses);
    }

    public void addLinkAddress(LinkAddress address) {
        if (address != null) {
            this.mLinkAddresses.add(address);
        }
    }

    public Collection<LinkAddress> getLinkAddresses() {
        return Collections.unmodifiableCollection(this.mLinkAddresses);
    }

    public void addDns(InetAddress dns) {
        if (dns != null) {
            this.mDnses.add(dns);
        }
    }

    public Collection<InetAddress> getDnses() {
        return Collections.unmodifiableCollection(this.mDnses);
    }

    public void addRoute(RouteInfo route) {
        if (route != null) {
            this.mRoutes.add(route);
        }
    }

    public Collection<RouteInfo> getRoutes() {
        return Collections.unmodifiableCollection(this.mRoutes);
    }

    public void setHttpProxy(ProxyProperties proxy) {
        this.mHttpProxy = proxy;
    }

    public ProxyProperties getHttpProxy() {
        return this.mHttpProxy;
    }

    public void clear() {
        this.mIfaceName = null;
        this.mLinkAddresses.clear();
        this.mDnses.clear();
        this.mRoutes.clear();
        this.mHttpProxy = null;
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var4_7;
        String ifaceName = this.mIfaceName == null ? "" : "InterfaceName: " + this.mIfaceName + " ";
        String linkAddresses = "LinkAddresses: [";
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            linkAddresses = linkAddresses + linkAddress.toString() + ",";
        }
        linkAddresses = linkAddresses + "] ";
        String dns = "DnsAddresses: [";
        for (InetAddress inetAddress : this.mDnses) {
            dns = dns + inetAddress.getHostAddress() + ",";
        }
        dns = dns + "] ";
        String string2 = "Routes: [";
        for (RouteInfo route : this.mRoutes) {
            String string3 = (String)var4_7 + route.toString() + ",";
        }
        String string4 = (String)var4_7 + "] ";
        String string5 = this.mHttpProxy == null ? "" : "HttpProxy: " + this.mHttpProxy.toString() + " ";
        return ifaceName + linkAddresses + string4 + dns + string5;
    }

    public boolean isIdenticalInterfaceName(LinkProperties target) {
        return TextUtils.equals((CharSequence)this.getInterfaceName(), (CharSequence)target.getInterfaceName());
    }

    public boolean isIdenticalAddresses(LinkProperties target) {
        Collection<InetAddress> targetAddresses = target.getAddresses();
        Collection<InetAddress> sourceAddresses = this.getAddresses();
        return sourceAddresses.size() == targetAddresses.size() ? sourceAddresses.containsAll(targetAddresses) : false;
    }

    public boolean isIdenticalDnses(LinkProperties target) {
        Collection<InetAddress> targetDnses = target.getDnses();
        return this.mDnses.size() == targetDnses.size() ? this.mDnses.containsAll(targetDnses) : false;
    }

    public boolean isIdenticalRoutes(LinkProperties target) {
        Collection<RouteInfo> targetRoutes = target.getRoutes();
        return this.mRoutes.size() == targetRoutes.size() ? this.mRoutes.containsAll(targetRoutes) : false;
    }

    public boolean isIdenticalHttpProxy(LinkProperties target) {
        return this.getHttpProxy() == null ? target.getHttpProxy() == null : this.getHttpProxy().equals(target.getHttpProxy());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkProperties)) {
            return false;
        }
        LinkProperties target = (LinkProperties)obj;
        return this.isIdenticalInterfaceName(target) && this.isIdenticalAddresses(target) && this.isIdenticalDnses(target) && this.isIdenticalRoutes(target) && this.isIdenticalHttpProxy(target);
    }

    public CompareResult<LinkAddress> compareAddresses(LinkProperties target) {
        CompareResult<LinkAddress> result = new CompareResult<LinkAddress>();
        result.removed = new ArrayList<LinkAddress>(this.mLinkAddresses);
        result.added.clear();
        if (target != null) {
            for (LinkAddress newAddress : target.getLinkAddresses()) {
                if (result.removed.remove(newAddress)) continue;
                result.added.add(newAddress);
            }
        }
        return result;
    }

    public CompareResult<InetAddress> compareDnses(LinkProperties target) {
        CompareResult<InetAddress> result = new CompareResult<InetAddress>();
        result.removed = new ArrayList<InetAddress>(this.mDnses);
        result.added.clear();
        if (target != null) {
            for (InetAddress newAddress : target.getDnses()) {
                if (result.removed.remove(newAddress)) continue;
                result.added.add(newAddress);
            }
        }
        return result;
    }

    public CompareResult<RouteInfo> compareRoutes(LinkProperties target) {
        CompareResult<RouteInfo> result = new CompareResult<RouteInfo>();
        result.removed = new ArrayList<RouteInfo>(this.mRoutes);
        result.added.clear();
        if (target != null) {
            for (RouteInfo r : target.getRoutes()) {
                if (result.removed.remove(r)) continue;
                result.added.add(r);
            }
        }
        return result;
    }

    public int hashCode() {
        return null == this.mIfaceName ? 0 : this.mIfaceName.hashCode() + this.mLinkAddresses.size() * 31 + this.mDnses.size() * 37 + this.mRoutes.size() * 41 + (null == this.mHttpProxy ? 0 : this.mHttpProxy.hashCode());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getInterfaceName());
        dest.writeInt(this.mLinkAddresses.size());
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            dest.writeParcelable((Parcelable)linkAddress, flags);
        }
        dest.writeInt(this.mDnses.size());
        for (InetAddress d : this.mDnses) {
            dest.writeByteArray(d.getAddress());
        }
        dest.writeInt(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            dest.writeParcelable((Parcelable)route, flags);
        }
        if (this.mHttpProxy != null) {
            dest.writeByte((byte)1);
            dest.writeParcelable((Parcelable)this.mHttpProxy, flags);
        } else {
            dest.writeByte((byte)0);
        }
    }

    public static class CompareResult<T> {
        public Collection<T> removed = new ArrayList<T>();
        public Collection<T> added = new ArrayList<T>();

        public String toString() {
            String retVal = "removed=[";
            for (T addr : this.removed) {
                retVal = retVal + addr.toString() + ",";
            }
            retVal = retVal + "] added=[";
            for (T addr : this.added) {
                retVal = retVal + addr.toString() + ",";
            }
            retVal = retVal + "]";
            return retVal;
        }
    }
}

