/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom;

import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListImpl
implements NodeList {
    private ArrayList<Node> mSearchNodes;
    private ArrayList<Node> mStaticNodes;
    private Node mRootNode;
    private String mTagName;
    private boolean mDeepSearch;

    public NodeListImpl(Node rootNode, String tagName, boolean deepSearch) {
        this.mRootNode = rootNode;
        this.mTagName = tagName;
        this.mDeepSearch = deepSearch;
    }

    public NodeListImpl(ArrayList<Node> nodes) {
        this.mStaticNodes = nodes;
    }

    @Override
    public int getLength() {
        if (this.mStaticNodes == null) {
            this.fillList(this.mRootNode);
            return this.mSearchNodes.size();
        }
        return this.mStaticNodes.size();
    }

    @Override
    public Node item(int index) {
        Node node = null;
        if (this.mStaticNodes == null) {
            this.fillList(this.mRootNode);
            try {
                node = this.mSearchNodes.get(index);
            }
            catch (IndexOutOfBoundsException e) {}
        } else {
            try {
                node = this.mStaticNodes.get(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return node;
    }

    private void fillList(Node node) {
        if (node == this.mRootNode) {
            this.mSearchNodes = new ArrayList();
        } else if (this.mTagName == null || node.getNodeName().equals(this.mTagName)) {
            this.mSearchNodes.add(node);
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (this.mDeepSearch) {
                this.fillList(node);
                continue;
            }
            if (this.mTagName != null && !node.getNodeName().equals(this.mTagName)) continue;
            this.mSearchNodes.add(node);
        }
    }
}

