/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.layout;

import android.content.Context;
import com.android.mms.layout.LayoutParameters;

public class HVGALayoutParameters
implements LayoutParameters {
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private int mType = -1;
    private static int mImageHeightLandscape;
    private static int mTextHeightLandscape;
    private static int mImageHeightPortrait;
    private static int mTextHeightPortrait;
    private static int mMaxHeight;
    private static int mMaxWidth;

    public HVGALayoutParameters(Context context, int type) {
        if (type != 10 && type != 11) {
            throw new IllegalArgumentException("Bad layout type detected: " + type);
        }
        this.mType = type;
        float scale = context.getResources().getDisplayMetrics().density;
        mMaxWidth = (int)((float)context.getResources().getConfiguration().screenWidthDp * scale + 0.5f);
        mMaxHeight = (int)((float)context.getResources().getConfiguration().screenHeightDp * scale + 0.5f);
        mImageHeightLandscape = (int)((float)mMaxHeight * 0.9f);
        mTextHeightLandscape = (int)((float)mMaxHeight * 0.1f);
        mImageHeightPortrait = (int)((float)mMaxWidth * 0.9f);
        mTextHeightPortrait = (int)((float)mMaxWidth * 0.1f);
    }

    @Override
    public int getWidth() {
        return this.mType == 10 ? mMaxWidth : mMaxHeight;
    }

    @Override
    public int getHeight() {
        return this.mType == 10 ? mMaxHeight : mMaxWidth;
    }

    @Override
    public int getImageHeight() {
        return this.mType == 10 ? mImageHeightLandscape : mImageHeightPortrait;
    }

    @Override
    public int getTextHeight() {
        return this.mType == 10 ? mTextHeightLandscape : mTextHeightPortrait;
    }

    @Override
    public int getType() {
        return this.mType;
    }

    @Override
    public String getTypeDescription() {
        return this.mType == 10 ? "HVGA-L" : "HVGA-P";
    }
}

