/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom;

import com.android.mms.dom.DocumentImpl;
import com.android.mms.dom.NodeListImpl;
import com.android.mms.dom.events.EventTargetImpl;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class NodeImpl
implements Node,
EventTarget {
    private Node mParentNode;
    private final Vector<Node> mChildNodes = new Vector();
    DocumentImpl mOwnerDocument;
    private final EventTarget mEventTarget = new EventTargetImpl(this);

    protected NodeImpl(DocumentImpl owner) {
        this.mOwnerDocument = owner;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        ((NodeImpl)newChild).setParentNode(this);
        this.mChildNodes.remove(newChild);
        this.mChildNodes.add(newChild);
        return newChild;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeListImpl(this, null, false);
    }

    @Override
    public Node getFirstChild() {
        Node firstChild = null;
        try {
            firstChild = this.mChildNodes.firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return firstChild;
    }

    @Override
    public Node getLastChild() {
        Node lastChild = null;
        try {
            lastChild = this.mChildNodes.lastElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return lastChild;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        if (this.mParentNode != null && this != this.mParentNode.getLastChild()) {
            Vector<Node> siblings = ((NodeImpl)this.mParentNode).mChildNodes;
            int indexOfThis = siblings.indexOf(this);
            return siblings.elementAt(indexOfThis + 1);
        }
        return null;
    }

    @Override
    public abstract String getNodeName();

    @Override
    public abstract short getNodeType();

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.mOwnerDocument;
    }

    @Override
    public Node getParentNode() {
        return this.mParentNode;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        if (this.mParentNode != null && this != this.mParentNode.getFirstChild()) {
            Vector<Node> siblings = ((NodeImpl)this.mParentNode).mChildNodes;
            int indexOfThis = siblings.indexOf(this);
            return siblings.elementAt(indexOfThis - 1);
        }
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public boolean hasChildNodes() {
        return !this.mChildNodes.isEmpty();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return null;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public void normalize() {
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (!this.mChildNodes.contains(oldChild)) {
            throw new DOMException(8, "Child does not exist");
        }
        this.mChildNodes.remove(oldChild);
        ((NodeImpl)oldChild).setParentNode(null);
        return null;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (this.mChildNodes.contains(oldChild)) {
            try {
                this.mChildNodes.remove(newChild);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        } else {
            throw new DOMException(8, "Old child does not exist");
        }
        this.mChildNodes.setElementAt(newChild, this.mChildNodes.indexOf(oldChild));
        ((NodeImpl)newChild).setParentNode(this);
        ((NodeImpl)oldChild).setParentNode(null);
        return oldChild;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    private void setParentNode(Node parentNode) {
        this.mParentNode = parentNode;
    }

    @Override
    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        this.mEventTarget.addEventListener(type, listener, useCapture);
    }

    @Override
    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        this.mEventTarget.removeEventListener(type, listener, useCapture);
    }

    @Override
    public boolean dispatchEvent(Event evt) throws EventException {
        return this.mEventTarget.dispatchEvent(evt);
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DOMException(9, null);
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new DOMException(9, null);
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new DOMException(9, null);
    }

    @Override
    public boolean isSameNode(Node other) {
        throw new DOMException(9, null);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new DOMException(9, null);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new DOMException(9, null);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new DOMException(9, null);
    }

    @Override
    public Object getUserData(String key) {
        return null;
    }
}

