/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Telephony;
import com.android.mms.service_alt.DownloadRequest;
import com.android.mms.service_alt.MmsConfig;
import com.android.mms.transaction.DownloadManager;
import com.android.mms.transaction.HttpUtils;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.AcknowledgeInd;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.NotificationInd;
import com.google.android.mms.pdu_alt.NotifyRespInd;
import com.google.android.mms.pdu_alt.PduComposer;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.RetrieveConf;
import com.google.android.mms.util_alt.SqliteWrapper;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MmsReceivedService
extends IntentService {
    private static final String TAG = "MmsReceivedService";
    private static final String LOCATION_SELECTION = "m_type=? AND ct_l =?";

    public MmsReceivedService() {
        super(TAG);
    }

    public MmsReceivedService(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleIntent(Intent intent) {
        Log.v((String)TAG, (String)"MMS has finished downloading, persisting it to the database");
        String path = intent.getStringExtra("file_path");
        Log.v((String)TAG, (String)path);
        FileInputStream reader = null;
        try {
            File mDownloadFile = new File(path);
            int nBytes = (int)mDownloadFile.length();
            reader = new FileInputStream(mDownloadFile);
            byte[] response = new byte[nBytes];
            reader.read(response, 0, nBytes);
            CommonNotificationTask task = MmsReceivedService.getNotificationTask((Context)this, intent, response);
            MmsReceivedService.executeNotificationTask(task);
            DownloadRequest.persist((Context)this, response, new MmsConfig.Overridden(new MmsConfig((Context)this), null), intent.getStringExtra("location_url"), Utils.getDefaultSubscriptionId(), null);
            Log.v((String)TAG, (String)"response saved successfully");
            Log.v((String)TAG, (String)("response length: " + response.length));
            mDownloadFile.delete();
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"MMS received, file not found exception", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"MMS received, io exception", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"MMS received, io exception", (Throwable)e);
                }
            }
            MmsReceivedService.handleHttpError((Context)this, intent);
            DownloadManager.finishDownload(intent.getStringExtra("location_url"));
        }
    }

    private static void handleHttpError(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        int httpError = intent.getIntExtra("android.telephony.extra.MMS_HTTP_STATUS", 0);
        if (httpError == 404 || httpError == 400) {
            SqliteWrapper.delete(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, LOCATION_SELECTION, new String[]{Integer.toString(130), intent.getStringExtra("location_url")});
        }
    }

    private static NotificationInd getNotificationInd(Context context, Intent intent) throws MmsException {
        return (NotificationInd)PduPersister.getPduPersister(context).load((Uri)intent.getParcelableExtra("notification_ind_uri"));
    }

    private static CommonNotificationTask getNotificationTask(Context context, Intent intent, byte[] response) {
        if (response.length == 0) {
            return null;
        }
        GenericPdu pdu = new PduParser(response, new MmsConfig.Overridden(new MmsConfig(context), null).getSupportMmsContentDisposition()).parse();
        if (pdu == null || !(pdu instanceof RetrieveConf)) {
            android.util.Log.e((String)TAG, (String)"MmsReceivedReceiver.sendNotification failed to parse pdu");
            return null;
        }
        try {
            NotificationInd ind = MmsReceivedService.getNotificationInd(context, intent);
            TransactionSettings transactionSettings = new TransactionSettings(context, null);
            if (intent.getBooleanExtra("trigger_push", false)) {
                return new NotifyRespTask(context, ind, transactionSettings);
            }
            return new AcknowledgeIndTask(context, ind, transactionSettings, (RetrieveConf)pdu);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"error", (Throwable)e);
            return null;
        }
    }

    private static void executeNotificationTask(CommonNotificationTask task) throws IOException {
        if (task == null) {
            return;
        }
        try {
            task.run();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"MMS send received notification, io exception", (Throwable)e);
            throw e;
        }
    }

    private static class AcknowledgeIndTask
    extends CommonNotificationTask {
        private final RetrieveConf mRetrieveConf;

        AcknowledgeIndTask(Context context, NotificationInd ind, TransactionSettings settings, RetrieveConf rc) {
            super(context, settings, ind);
            this.mRetrieveConf = rc;
        }

        @Override
        public void run() throws IOException {
            byte[] tranId = this.mRetrieveConf.getTransactionId();
            if (tranId != null) {
                AcknowledgeInd acknowledgeInd = null;
                try {
                    acknowledgeInd = new AcknowledgeInd(18, tranId);
                    String lineNumber = Utils.getMyPhoneNumber(this.mContext);
                    acknowledgeInd.setFrom(new EncodedStringValue(lineNumber));
                    if (com.android.mms.MmsConfig.getNotifyWapMMSC()) {
                        this.sendPdu(new PduComposer(this.mContext, acknowledgeInd).make(), this.mContentLocation);
                    } else {
                        this.sendPdu(new PduComposer(this.mContext, acknowledgeInd).make());
                    }
                }
                catch (InvalidHeaderValueException e) {
                    Log.e((String)MmsReceivedService.TAG, (String)"error", (Throwable)e);
                }
                catch (MmsException e) {
                    Log.e((String)MmsReceivedService.TAG, (String)"error", (Throwable)e);
                }
            }
        }
    }

    private static class NotifyRespTask
    extends CommonNotificationTask {
        NotifyRespTask(Context context, NotificationInd ind, TransactionSettings settings) {
            super(context, settings, ind);
        }

        @Override
        public void run() throws IOException {
            NotifyRespInd notifyRespInd = null;
            try {
                notifyRespInd = new NotifyRespInd(18, this.mNotificationInd.getTransactionId(), 129);
                if (com.android.mms.MmsConfig.getNotifyWapMMSC()) {
                    this.sendPdu(new PduComposer(this.mContext, notifyRespInd).make(), this.mContentLocation);
                } else {
                    this.sendPdu(new PduComposer(this.mContext, notifyRespInd).make());
                }
            }
            catch (MmsException e) {
                Log.e((String)MmsReceivedService.TAG, (String)"error", (Throwable)e);
            }
        }
    }

    private static abstract class CommonNotificationTask {
        protected final Context mContext;
        private final TransactionSettings mTransactionSettings;
        final NotificationInd mNotificationInd;
        final String mContentLocation;

        CommonNotificationTask(Context context, TransactionSettings settings, NotificationInd ind) {
            this.mContext = context;
            this.mTransactionSettings = settings;
            this.mNotificationInd = ind;
            this.mContentLocation = new String(ind.getContentLocation());
        }

        byte[] sendPdu(byte[] pdu, String mmscUrl) throws IOException, MmsException {
            return this.sendPdu(-1L, pdu, mmscUrl);
        }

        byte[] sendPdu(byte[] pdu) throws IOException, MmsException {
            return this.sendPdu(-1L, pdu, this.mTransactionSettings.getMmscUrl());
        }

        private byte[] sendPdu(final long token, final byte[] pdu, final String mmscUrl) throws IOException, MmsException {
            if (pdu == null) {
                throw new MmsException();
            }
            if (mmscUrl == null) {
                throw new IOException("Cannot establish route: mmscUrl is null");
            }
            if (Transaction.useWifi(this.mContext)) {
                return HttpUtils.httpConnection(this.mContext, token, mmscUrl, pdu, 1, false, null, 0);
            }
            return Utils.ensureRouteToMmsNetwork(this.mContext, mmscUrl, this.mTransactionSettings.getProxyAddress(), new Utils.Task<byte[]>(){

                @Override
                public byte[] run() throws IOException {
                    return HttpUtils.httpConnection(CommonNotificationTask.this.mContext, token, mmscUrl, pdu, 1, CommonNotificationTask.this.mTransactionSettings.isProxySet(), CommonNotificationTask.this.mTransactionSettings.getProxyAddress(), CommonNotificationTask.this.mTransactionSettings.getProxyPort());
                }
            });
        }

        public abstract void run() throws IOException;
    }
}

