/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Build;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.util.ArrayMap;
import com.android.mms.service_alt.MmsConfig;
import com.klinker.android.logger.Log;
import java.util.List;
import java.util.Map;

public class MmsConfigManager {
    private static final String TAG = "MmsConfigManager";
    private static volatile MmsConfigManager sInstance = new MmsConfigManager();
    private final Map<Integer, MmsConfig> mSubIdConfigMap;
    private Context mContext;
    private SubscriptionManager mSubscriptionManager;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            Log.i((String)MmsConfigManager.TAG, (String)("mReceiver action: " + action));
            if (action.equals("LOADED")) {
                MmsConfigManager.this.loadInBackground();
            }
        }
    };

    public static MmsConfigManager getInstance() {
        return sInstance;
    }

    private MmsConfigManager() {
        this.mSubIdConfigMap = new ArrayMap();
    }

    public void init(Context context) {
        this.mContext = context;
        if (Build.VERSION.SDK_INT >= 22) {
            this.mSubscriptionManager = SubscriptionManager.from((Context)context);
            IntentFilter intentFilterLoaded = new IntentFilter("LOADED");
            try {
                context.registerReceiver(this.mReceiver, intentFilterLoaded);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.load(context);
        } else {
            this.load(context);
        }
    }

    private void loadInBackground() {
        new Thread(){

            @Override
            public void run() {
                Configuration configuration = MmsConfigManager.this.mContext.getResources().getConfiguration();
                Log.i((String)MmsConfigManager.TAG, (String)("MmsConfigManager.loadInBackground(): mcc/mnc: " + configuration.mcc + "/" + configuration.mnc));
                MmsConfigManager.this.load(MmsConfigManager.this.mContext);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmsConfig getMmsConfigBySubId(int subId) {
        MmsConfig mmsConfig;
        Map<Integer, MmsConfig> map = this.mSubIdConfigMap;
        synchronized (map) {
            mmsConfig = this.mSubIdConfigMap.get(subId);
        }
        Log.i((String)TAG, (String)("getMmsConfigBySubId -- for sub: " + subId + " mmsConfig: " + mmsConfig));
        return mmsConfig;
    }

    public MmsConfig getMmsConfig() {
        return new MmsConfig(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Context context) {
        if (Build.VERSION.SDK_INT >= 22) {
            List subs = this.mSubscriptionManager.getActiveSubscriptionInfoList();
            if (subs == null || subs.size() < 1) {
                Log.e((String)TAG, (String)"MmsConfigManager.load -- empty getActiveSubInfoList");
                return;
            }
            ArrayMap newConfigMap = new ArrayMap();
            for (SubscriptionInfo sub : subs) {
                Configuration configuration = new Configuration();
                if (sub.getMcc() == 0 && sub.getMnc() == 0) {
                    Configuration config = this.mContext.getResources().getConfiguration();
                    configuration.mcc = config.mcc;
                    configuration.mnc = config.mnc;
                    Log.i((String)TAG, (String)("MmsConfigManager.load -- no mcc/mnc for sub: " + sub + " using mcc/mnc from main context: " + configuration.mcc + "/" + configuration.mnc));
                } else {
                    Log.i((String)TAG, (String)("MmsConfigManager.load -- mcc/mnc for sub: " + sub));
                    configuration.mcc = sub.getMcc();
                    configuration.mnc = sub.getMnc();
                }
                Context subContext = context.createConfigurationContext(configuration);
                int subId = sub.getSubscriptionId();
                newConfigMap.put(subId, new MmsConfig(subContext, subId));
            }
            Map<Integer, MmsConfig> map = this.mSubIdConfigMap;
            synchronized (map) {
                this.mSubIdConfigMap.clear();
                this.mSubIdConfigMap.putAll((Map<Integer, MmsConfig>)newConfigMap);
            }
        }
    }
}

