/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.Context;
import android.content.Intent;
import com.klinker.android.send_message.BroadcastUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.entity.ByteArrayEntity;

public class ProgressCallbackEntity
extends ByteArrayEntity {
    private static final int DEFAULT_PIECE_SIZE = 4096;
    public static final String PROGRESS_STATUS_ACTION = "com.android.mms.PROGRESS_STATUS";
    public static final int PROGRESS_START = -1;
    public static final int PROGRESS_ABORT = -2;
    public static final int PROGRESS_COMPLETE = 100;
    private final Context mContext;
    private final byte[] mContent;
    private final long mToken;

    public ProgressCallbackEntity(Context context, long token, byte[] b) {
        super(b);
        this.mContext = context;
        this.mContent = b;
        this.mToken = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        boolean completed = false;
        try {
            this.broadcastProgressIfNeeded(-1);
            int pos = 0;
            int totalLen = this.mContent.length;
            while (pos < totalLen) {
                int len = totalLen - pos;
                if (len > 4096) {
                    len = 4096;
                }
                outstream.write(this.mContent, pos, len);
                outstream.flush();
                this.broadcastProgressIfNeeded(100 * (pos += len) / totalLen);
            }
            this.broadcastProgressIfNeeded(100);
            completed = true;
        }
        finally {
            if (!completed) {
                this.broadcastProgressIfNeeded(-2);
            }
        }
    }

    private void broadcastProgressIfNeeded(int progress) {
        if (this.mToken > 0L) {
            Intent intent = new Intent(PROGRESS_STATUS_ACTION);
            intent.putExtra("progress", progress);
            intent.putExtra("token", this.mToken);
            BroadcastUtils.sendExplicitBroadcast(this.mContext, intent, PROGRESS_STATUS_ACTION);
        }
    }
}

