/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.util;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.widget.Toast;
import com.android.mms.service_alt.SystemPropertiesProxy;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.NotificationInd;
import com.google.android.mms.pdu_alt.PduPersister;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.R;

public class DownloadManager {
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    public static final int DEFERRED_MASK = 4;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_UNSTARTED = 128;
    public static final int STATE_DOWNLOADING = 129;
    public static final int STATE_TRANSIENT_FAILURE = 130;
    public static final int STATE_PERMANENT_FAILURE = 135;
    public static final int STATE_PRE_DOWNLOADING = 136;
    public static final int STATE_SKIP_RETRYING = 137;
    private final Context mContext;
    private final Handler mHandler;
    private final SharedPreferences mPreferences;
    private boolean mAutoDownload;
    private static DownloadManager sInstance;

    private DownloadManager(Context context) {
        this.mContext = context;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.mAutoDownload = DownloadManager.getAutoDownloadState(context, this.mPreferences);
    }

    public boolean isAuto() {
        return this.mAutoDownload;
    }

    public static void init(Context context) {
        if (sInstance != null) {
            Log.w((String)TAG, (String)"Already initialized.");
        }
        sInstance = new DownloadManager(context);
    }

    public static DownloadManager getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("Uninitialized.");
        }
        return sInstance;
    }

    static boolean getAutoDownloadState(Context context, SharedPreferences prefs) {
        return DownloadManager.getAutoDownloadState(prefs, DownloadManager.isRoaming(context));
    }

    static boolean getAutoDownloadState(SharedPreferences prefs, boolean roaming) {
        boolean autoDownload = prefs.getBoolean("auto_download_mms", true);
        if (autoDownload) {
            boolean alwaysAuto = true;
            if (!roaming || alwaysAuto) {
                return true;
            }
        }
        return false;
    }

    static boolean isRoaming(Context context) {
        String roaming = SystemPropertiesProxy.get(context, "gsm.operator.isroaming", null);
        return "true".equals(roaming);
    }

    public void markState(final Uri uri, int state) {
        try {
            NotificationInd nInd = (NotificationInd)PduPersister.getPduPersister(this.mContext).load(uri);
            if (nInd.getExpiry() < System.currentTimeMillis() / 1000L && (state == 129 || state == 136)) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)DownloadManager.this.mContext, (int)R.string.service_message_not_found, (int)1).show();
                    }
                });
                SqliteWrapper.delete(this.mContext, this.mContext.getContentResolver(), uri, null, null);
                return;
            }
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            return;
        }
        if (state == 135) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Toast.makeText((Context)DownloadManager.this.mContext, (CharSequence)DownloadManager.this.getMessage(uri), (int)1).show();
                    }
                    catch (MmsException e) {
                        Log.e((String)DownloadManager.TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if (!this.mAutoDownload) {
            state |= 4;
        }
        ContentValues values = new ContentValues(1);
        values.put("st", Integer.valueOf(state));
        SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), uri, values, null, null);
    }

    public void showErrorCodeToast(int errorStr) {
        final int errStr = errorStr;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Toast.makeText((Context)DownloadManager.this.mContext, (int)errStr, (int)1).show();
                }
                catch (Exception e) {
                    Log.e((String)DownloadManager.TAG, (String)"Caught an exception in showErrorCodeToast");
                }
            }
        });
    }

    private String getMessage(Uri uri) throws MmsException {
        NotificationInd ind = (NotificationInd)PduPersister.getPduPersister(this.mContext).load(uri);
        EncodedStringValue v = ind.getSubject();
        String subject = v != null ? v.getString() : this.mContext.getString(R.string.no_subject);
        String from = this.mContext.getString(R.string.unknown_sender);
        return this.mContext.getString(R.string.dl_failure_notification, new Object[]{subject, from});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState(Uri uri) {
        Cursor cursor = SqliteWrapper.query(this.mContext, this.mContext.getContentResolver(), uri, new String[]{"st"}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    int state = cursor.getInt(0) & 0xFFFFFFFB;
                    cursor.close();
                    int n = state;
                    return n;
                }
            }
            finally {
                cursor.close();
            }
        }
        return 128;
    }
}

