/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.BroadcastUtils;
import java.util.Calendar;

public class DeliveredReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        Uri uri;
        Log.v((String)"delivery_receiver", (String)"marking message as delivered");
        try {
            uri = Uri.parse((String)intent.getStringExtra("message_uri"));
            if (uri.equals((Object)"")) {
                uri = null;
            }
        }
        catch (Exception e) {
            uri = null;
        }
        switch (this.getResultCode()) {
            case -1: {
                Intent delivered = new Intent("com.klinker.android.send_message.NOTIFY_DELIVERY");
                delivered.putExtra("result", true);
                delivered.putExtra("message_uri", uri == null ? "" : uri.toString());
                BroadcastUtils.sendExplicitBroadcast(context, delivered, "com.klinker.android.send_message.NOTIFY_DELIVERY");
                if (uri != null) {
                    ContentValues values = new ContentValues();
                    values.put("status", "0");
                    values.put("date_sent", Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                    values.put("read", Boolean.valueOf(true));
                    context.getContentResolver().update(uri, values, null, null);
                    break;
                }
                Cursor query = context.getContentResolver().query(Uri.parse((String)"content://sms/sent"), null, null, null, "date desc");
                if (query.moveToFirst()) {
                    String id2 = query.getString(query.getColumnIndex("_id"));
                    ContentValues values = new ContentValues();
                    values.put("status", "0");
                    values.put("date_sent", Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                    values.put("read", Boolean.valueOf(true));
                    context.getContentResolver().update(Uri.parse((String)"content://sms/sent"), values, "_id=" + id2, null);
                }
                query.close();
                break;
            }
            case 0: {
                Intent notDelivered = new Intent("com.klinker.android.send_message.NOTIFY_DELIVERY");
                notDelivered.putExtra("result", false);
                notDelivered.putExtra("message_uri", uri == null ? "" : uri.toString());
                BroadcastUtils.sendExplicitBroadcast(context, notDelivered, "com.klinker.android.send_message.NOTIFY_DELIVERY");
                if (uri != null) {
                    ContentValues values = new ContentValues();
                    values.put("status", "64");
                    values.put("date_sent", Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                    values.put("read", Boolean.valueOf(true));
                    values.put("error_code", Integer.valueOf(this.getResultCode()));
                    context.getContentResolver().update(uri, values, null, null);
                    break;
                }
                Cursor query2 = context.getContentResolver().query(Uri.parse((String)"content://sms/sent"), null, null, null, "date desc");
                if (query2.moveToFirst()) {
                    String id3 = query2.getString(query2.getColumnIndex("_id"));
                    ContentValues values = new ContentValues();
                    values.put("status", "64");
                    values.put("read", Boolean.valueOf(true));
                    values.put("error_code", Integer.valueOf(this.getResultCode()));
                    context.getContentResolver().update(Uri.parse((String)"content://sms/sent"), values, "_id=" + id3, null);
                }
                query2.close();
            }
        }
        BroadcastUtils.sendExplicitBroadcast(context, new Intent(), "com.klinker.android.send_message.REFRESH");
    }
}

