/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.widget.Toast;
import com.android.mms.MmsConfig;
import com.android.mms.dom.smil.parser.SmilXmlSerializer;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.MmsRequestManager;
import com.android.mms.service_alt.SendRequest;
import com.android.mms.transaction.MmsMessageSender;
import com.android.mms.util.DownloadManager;
import com.android.mms.util.RateController;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MMSPart;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.PduBody;
import com.google.android.mms.pdu_alt.PduComposer;
import com.google.android.mms.pdu_alt.PduPart;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.SendReq;
import com.google.android.mms.smil.SmilHelper;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.BroadcastUtils;
import com.klinker.android.send_message.Message;
import com.klinker.android.send_message.Settings;
import com.klinker.android.send_message.SmsManagerFactory;
import com.klinker.android.send_message.StripAccents;
import com.klinker.android.send_message.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class Transaction {
    private static final String TAG = "Transaction";
    public static Settings settings;
    private Context context;
    private Intent explicitSentSmsReceiver;
    private Intent explicitSentMmsReceiver;
    private Intent explicitDeliveredSmsReceiver;
    private boolean saveMessage = true;
    public String SMS_SENT = ".SMS_SENT";
    public String SMS_DELIVERED = ".SMS_DELIVERED";
    public static String NOTIFY_SMS_FAILURE;
    public static final String MMS_ERROR = "com.klinker.android.send_message.MMS_ERROR";
    public static final String REFRESH = "com.klinker.android.send_message.REFRESH";
    public static final String MMS_PROGRESS = "com.klinker.android.send_message.MMS_PROGRESS";
    public static final String NOTIFY_OF_DELIVERY = "com.klinker.android.send_message.NOTIFY_DELIVERY";
    public static final String NOTIFY_OF_MMS = "com.klinker.android.messaging.NEW_MMS_DOWNLOADED";
    public static final long NO_THREAD_ID = 0L;
    public static final long DEFAULT_EXPIRY_TIME = 604800L;
    public static final int DEFAULT_PRIORITY = 129;

    public Transaction(Context context) {
        this(context, new Settings());
    }

    public Transaction(Context context, Settings settings) {
        Transaction.settings = settings;
        this.context = context;
        this.SMS_SENT = context.getPackageName() + this.SMS_SENT;
        this.SMS_DELIVERED = context.getPackageName() + this.SMS_DELIVERED;
        if (NOTIFY_SMS_FAILURE.equals(".NOTIFY_SMS_FAILURE")) {
            NOTIFY_SMS_FAILURE = context.getPackageName() + NOTIFY_SMS_FAILURE;
        }
    }

    public void sendNewMessage(Message message, long threadId) {
        this.saveMessage = message.getSave();
        if (this.checkMMS(message)) {
            try {
                Looper.prepare();
            }
            catch (Exception exception) {
                // empty catch block
            }
            RateController.init(this.context);
            DownloadManager.init(this.context);
            this.sendMmsMessage(message.getText(), message.getAddresses(), message.getImages(), message.getImageNames(), message.getParts(), message.getSubject());
        } else {
            this.sendSmsMessage(message.getText(), message.getAddresses(), threadId, message.getDelay());
        }
    }

    public Transaction setExplicitBroadcastForSentSms(Intent intent) {
        this.explicitSentSmsReceiver = intent;
        return this;
    }

    public Transaction setExplicitBroadcastForSentMms(Intent intent) {
        this.explicitSentMmsReceiver = intent;
        return this;
    }

    public Transaction setExplicitBroadcastForDeliveredSms(Intent intent) {
        this.explicitDeliveredSmsReceiver = intent;
        return this;
    }

    private void sendSmsMessage(String text, String[] addresses, long threadId, int delay) {
        Log.v((String)"send_transaction", (String)("message text: " + text));
        Uri messageUri = null;
        int messageId = 0;
        if (this.saveMessage) {
            Log.v((String)"send_transaction", (String)"saving message");
            if (!settings.getSignature().equals("")) {
                text = text + "\n" + settings.getSignature();
            }
            for (int i = 0; i < addresses.length; ++i) {
                Intent deliveredIntent;
                Intent sentIntent;
                Calendar cal = Calendar.getInstance();
                ContentValues values = new ContentValues();
                values.put("address", addresses[i]);
                values.put("body", settings.getStripUnicode() ? StripAccents.stripAccents(text) : text);
                values.put("date", cal.getTimeInMillis() + "");
                values.put("read", Integer.valueOf(1));
                values.put("type", Integer.valueOf(4));
                if (threadId == 0L || addresses.length > 1) {
                    threadId = Utils.getOrCreateThreadId(this.context, addresses[i]);
                }
                Log.v((String)"send_transaction", (String)("saving message with thread id: " + threadId));
                values.put("thread_id", Long.valueOf(threadId));
                messageUri = this.context.getContentResolver().insert(Uri.parse((String)"content://sms/"), values);
                Log.v((String)"send_transaction", (String)("inserted to uri: " + messageUri));
                Cursor query = this.context.getContentResolver().query(messageUri, new String[]{"_id"}, null, null, null);
                if (query != null && query.moveToFirst()) {
                    messageId = query.getInt(0);
                    query.close();
                }
                Log.v((String)"send_transaction", (String)("message id: " + messageId));
                if (this.explicitSentSmsReceiver == null) {
                    sentIntent = new Intent(this.SMS_SENT);
                    BroadcastUtils.addClassName(this.context, sentIntent, this.SMS_SENT);
                } else {
                    sentIntent = this.explicitSentSmsReceiver;
                }
                sentIntent.putExtra("message_uri", messageUri == null ? "" : messageUri.toString());
                PendingIntent sentPI = PendingIntent.getBroadcast((Context)this.context, (int)messageId, (Intent)sentIntent, (int)0x8000000);
                if (this.explicitDeliveredSmsReceiver == null) {
                    deliveredIntent = new Intent(this.SMS_DELIVERED);
                    BroadcastUtils.addClassName(this.context, deliveredIntent, this.SMS_DELIVERED);
                } else {
                    deliveredIntent = this.explicitDeliveredSmsReceiver;
                }
                deliveredIntent.putExtra("message_uri", messageUri == null ? "" : messageUri.toString());
                PendingIntent deliveredPI = PendingIntent.getBroadcast((Context)this.context, (int)messageId, (Intent)deliveredIntent, (int)0x8000000);
                ArrayList<PendingIntent> sPI = new ArrayList<PendingIntent>();
                ArrayList<PendingIntent> dPI = new ArrayList<PendingIntent>();
                String body = text;
                if (settings.getStripUnicode()) {
                    body = StripAccents.stripAccents(body);
                }
                if (!settings.getPreText().equals("")) {
                    body = settings.getPreText() + " " + body;
                }
                SmsManager smsManager = SmsManagerFactory.createSmsManager(settings);
                Log.v((String)"send_transaction", (String)"found sms manager");
                if (settings.getSplit()) {
                    Log.v((String)"send_transaction", (String)"splitting message");
                    int[] splitData = SmsMessage.calculateLength((String)body, (boolean)false);
                    int length = (body.length() + splitData[2]) / splitData[0];
                    Log.v((String)"send_transaction", (String)("length: " + length));
                    boolean counter = false;
                    if (settings.getSplitCounter() && body.length() > length) {
                        counter = true;
                        length -= 6;
                    }
                    String[] textToSend = this.splitByLength(body, length, counter);
                    for (int j = 0; j < textToSend.length; ++j) {
                        ArrayList parts = smsManager.divideMessage(textToSend[j]);
                        for (int k = 0; k < parts.size(); ++k) {
                            sPI.add((PendingIntent)(this.saveMessage ? sentPI : null));
                            dPI.add(settings.getDeliveryReports() && this.saveMessage ? deliveredPI : null);
                        }
                        Log.v((String)"send_transaction", (String)"sending split message");
                        this.sendDelayedSms(smsManager, addresses[i], parts, sPI, dPI, delay, messageUri);
                    }
                    continue;
                }
                Log.v((String)"send_transaction", (String)"sending without splitting");
                ArrayList parts = smsManager.divideMessage(body);
                for (int j = 0; j < parts.size(); ++j) {
                    sPI.add((PendingIntent)(this.saveMessage ? sentPI : null));
                    dPI.add(settings.getDeliveryReports() && this.saveMessage ? deliveredPI : null);
                }
                if (Utils.isDefaultSmsApp(this.context)) {
                    try {
                        Log.v((String)"send_transaction", (String)"sent message");
                        this.sendDelayedSms(smsManager, addresses[i], parts, sPI, dPI, delay, messageUri);
                    }
                    catch (Exception e) {
                        Log.v((String)"send_transaction", (String)"error sending message");
                        Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
                        try {
                            ((Activity)this.context).getWindow().getDecorView().findViewById(0x1020002).post(new Runnable(){

                                @Override
                                public void run() {
                                    Toast.makeText((Context)Transaction.this.context, (CharSequence)"Message could not be sent", (int)1).show();
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                    continue;
                }
                smsManager.sendMultipartTextMessage(addresses[i], null, parts, sPI, dPI);
            }
        }
    }

    private void sendDelayedSms(final SmsManager smsManager, final String address, final ArrayList<String> parts, final ArrayList<PendingIntent> sPI, final ArrayList<PendingIntent> dPI, final int delay, final Uri messageUri) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Transaction.this.checkIfMessageExistsAfterDelay(messageUri)) {
                    Log.v((String)"send_transaction", (String)"message sent after delay");
                    try {
                        smsManager.sendMultipartTextMessage(address, null, parts, sPI, dPI);
                    }
                    catch (Exception e) {
                        Log.e((String)Transaction.TAG, (String)"exception thrown", (Throwable)e);
                    }
                } else {
                    Log.v((String)"send_transaction", (String)"message not sent after delay, no longer exists");
                }
            }
        }).start();
    }

    private boolean checkIfMessageExistsAfterDelay(Uri messageUti) {
        Cursor query = this.context.getContentResolver().query(messageUti, new String[]{"_id"}, null, null, null);
        if (query != null && query.moveToFirst()) {
            query.close();
            return true;
        }
        return false;
    }

    private void sendMmsMessage(String text, String[] addresses, Bitmap[] image, String[] imageNames, List<Message.Part> parts, String subject) {
        MMSPart part;
        String address = "";
        for (int i = 0; i < addresses.length; ++i) {
            address = address + addresses[i] + " ";
        }
        address = address.trim();
        ArrayList<MMSPart> data = new ArrayList<MMSPart>();
        for (int i = 0; i < image.length; ++i) {
            byte[] imageBytes = Message.bitmapToByteArray(image[i]);
            part = new MMSPart();
            part.MimeType = "image/jpeg";
            part.Name = imageNames != null ? imageNames[i] : "image_" + System.currentTimeMillis();
            part.Data = imageBytes;
            data.add(part);
        }
        if (parts != null) {
            for (Message.Part p : parts) {
                part = new MMSPart();
                part.Name = p.getName() != null ? p.getName() : p.getContentType().split("/")[0];
                part.MimeType = p.getContentType();
                part.Data = p.getMedia();
                data.add(part);
            }
        }
        if (text != null && !text.equals("")) {
            MMSPart part2 = new MMSPart();
            part2.Name = "text";
            part2.MimeType = "text/plain";
            part2.Data = text.getBytes();
            data.add(part2);
        }
        if (Build.VERSION.SDK_INT <= 19) {
            MessageInfo info = null;
            try {
                info = Transaction.getBytes(this.context, this.saveMessage, address.split(" "), data.toArray(new MMSPart[data.size()]), subject);
                MmsMessageSender sender = new MmsMessageSender(this.context, info.location, info.bytes.length);
                sender.sendMessage(info.token);
                IntentFilter filter = new IntentFilter();
                filter.addAction("com.android.mms.PROGRESS_STATUS");
                BroadcastReceiver receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        int progress = intent.getIntExtra("progress", -3);
                        Log.v((String)"sending_mms_library", (String)("progress: " + progress));
                        Intent progressIntent = new Intent(Transaction.MMS_PROGRESS);
                        progressIntent.putExtra("progress", progress);
                        BroadcastUtils.sendExplicitBroadcast(context, progressIntent, Transaction.MMS_PROGRESS);
                        if (progress == 100) {
                            BroadcastUtils.sendExplicitBroadcast(context, new Intent(), Transaction.REFRESH);
                            try {
                                context.unregisterReceiver((BroadcastReceiver)this);
                            }
                            catch (Exception exception) {}
                        } else if (progress == -2) {
                            Log.v((String)"sending_mms_library", (String)"sending aborted for some reason...");
                        }
                    }
                };
                this.context.registerReceiver(receiver, filter);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
            }
        } else {
            Log.v((String)TAG, (String)"using lollipop method for sending sms");
            if (settings.getUseSystemSending()) {
                Log.v((String)TAG, (String)"using system method for sending");
                Transaction.sendMmsThroughSystem(this.context, subject, data, addresses, this.explicitSentMmsReceiver);
            } else {
                try {
                    MessageInfo info = Transaction.getBytes(this.context, this.saveMessage, address.split(" "), data.toArray(new MMSPart[data.size()]), subject);
                    MmsRequestManager requestManager = new MmsRequestManager(this.context, info.bytes);
                    SendRequest request = new SendRequest(requestManager, Utils.getDefaultSubscriptionId(), info.location, null, null, null, null);
                    MmsNetworkManager manager = new MmsNetworkManager(this.context, Utils.getDefaultSubscriptionId());
                    request.execute(this.context, manager);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"error sending mms", (Throwable)e);
                }
            }
        }
    }

    public static MessageInfo getBytes(Context context, boolean saveMessage, String[] recipients, MMSPart[] parts, String subject) throws MmsException {
        byte[] bytesToSend;
        SendReq sendRequest = new SendReq();
        for (int i = 0; i < recipients.length; ++i) {
            EncodedStringValue[] phoneNumbers = EncodedStringValue.extract(recipients[i]);
            if (phoneNumbers == null || phoneNumbers.length <= 0) continue;
            sendRequest.addTo(phoneNumbers[0]);
        }
        if (subject != null) {
            sendRequest.setSubject(new EncodedStringValue(subject));
        }
        sendRequest.setDate(Calendar.getInstance().getTimeInMillis() / 1000L);
        try {
            sendRequest.setFrom(new EncodedStringValue(Utils.getMyPhoneNumber(context)));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"error getting from address", (Throwable)e);
        }
        PduBody pduBody = new PduBody();
        long size = 0L;
        if (parts != null) {
            for (int i = 0; i < parts.length; ++i) {
                MMSPart part = parts[i];
                if (part == null) continue;
                try {
                    PduPart partPdu = new PduPart();
                    partPdu.setName(part.Name.getBytes());
                    partPdu.setContentType(part.MimeType.getBytes());
                    if (part.MimeType.startsWith("text")) {
                        partPdu.setCharset(106);
                    }
                    partPdu.setContentLocation(part.Name.getBytes());
                    int index = part.Name.lastIndexOf(".");
                    String contentId = index == -1 ? part.Name : part.Name.substring(0, index);
                    partPdu.setContentId(contentId.getBytes());
                    partPdu.setData(part.Data);
                    pduBody.addPart(partPdu);
                    size += (long)(2 * part.Name.getBytes().length + part.MimeType.getBytes().length + part.Data.length + contentId.getBytes().length);
                    continue;
                }
                catch (Exception partPdu) {
                    // empty catch block
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SmilXmlSerializer.serialize(SmilHelper.createSmilDocument(pduBody), out);
        PduPart smilPart = new PduPart();
        smilPart.setContentId("smil".getBytes());
        smilPart.setContentLocation("smil.xml".getBytes());
        smilPart.setContentType("application/smil".getBytes());
        smilPart.setData(out.toByteArray());
        pduBody.addPart(0, smilPart);
        sendRequest.setBody(pduBody);
        Log.v((String)TAG, (String)("setting message size to " + size + " bytes"));
        sendRequest.setMessageSize(size);
        sendRequest.setPriority(129);
        sendRequest.setDeliveryReport(129);
        sendRequest.setExpiry(604800000L);
        sendRequest.setMessageClass("personal".getBytes());
        sendRequest.setReadReport(129);
        PduComposer composer = new PduComposer(context, sendRequest);
        try {
            bytesToSend = composer.make();
        }
        catch (OutOfMemoryError e) {
            throw new MmsException("Out of memory!");
        }
        MessageInfo info = new MessageInfo();
        info.bytes = bytesToSend;
        if (saveMessage) {
            try {
                PduPersister persister = PduPersister.getPduPersister(context);
                info.location = persister.persist(sendRequest, Uri.parse((String)"content://mms/outbox"), true, settings.getGroup(), null);
            }
            catch (Exception e) {
                Log.v((String)"sending_mms_library", (String)"error saving mms message");
                Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
                Transaction.insert(context, recipients, parts, subject);
            }
        }
        try {
            Cursor query = context.getContentResolver().query(info.location, new String[]{"thread_id"}, null, null, null);
            if (query != null && query.moveToFirst()) {
                info.token = query.getLong(query.getColumnIndex("thread_id"));
                query.close();
            } else {
                info.token = 4444L;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
            info.token = 4444L;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendMmsThroughSystem(Context context, String subject, List<MMSPart> parts, String[] addresses, Intent explicitSentMmsReceiver) {
        try {
            Intent intent;
            String fileName = "send." + String.valueOf(Math.abs(new Random().nextLong())) + ".dat";
            File mSendFile = new File(context.getCacheDir(), fileName);
            SendReq sendReq = Transaction.buildPdu(context, addresses, subject, parts);
            PduPersister persister = PduPersister.getPduPersister(context);
            Uri messageUri = persister.persist(sendReq, Uri.parse((String)"content://mms/outbox"), true, settings.getGroup(), null);
            if (explicitSentMmsReceiver == null) {
                intent = new Intent("com.klinker.android.messaging.MMS_SENT");
                BroadcastUtils.addClassName(context, intent, "com.klinker.android.messaging.MMS_SENT");
            } else {
                intent = explicitSentMmsReceiver;
            }
            intent.putExtra("content_uri", messageUri.toString());
            intent.putExtra("file_path", mSendFile.getPath());
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x10000000);
            Uri writerUri = new Uri.Builder().authority(context.getPackageName() + ".MmsFileProvider").path(fileName).scheme("content").build();
            FileOutputStream writer = null;
            Uri contentUri = null;
            try {
                writer = new FileOutputStream(mSendFile);
                writer.write(new PduComposer(context, sendReq).make());
                contentUri = writerUri;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error writing send file", (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {}
                }
            }
            Bundle configOverrides = new Bundle();
            configOverrides.putBoolean("enableGroupMms", settings.getGroup());
            String httpParams = MmsConfig.getHttpParams();
            if (!TextUtils.isEmpty((CharSequence)httpParams)) {
                configOverrides.putString("httpParams", httpParams);
            }
            configOverrides.putInt("maxMessageSize", MmsConfig.getMaxMessageSize());
            if (contentUri != null) {
                SmsManagerFactory.createSmsManager(settings).sendMultimediaMessage(context, contentUri, null, configOverrides, pendingIntent);
            } else {
                Log.e((String)TAG, (String)"Error writing sending Mms");
                try {
                    pendingIntent.send(5);
                }
                catch (PendingIntent.CanceledException ex) {
                    Log.e((String)TAG, (String)"Mms pending intent cancelled?", (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"error using system sending method", (Throwable)e);
        }
    }

    private static SendReq buildPdu(Context context, String[] recipients, String subject, List<MMSPart> parts) {
        SendReq req = new SendReq();
        String lineNumber = Utils.getMyPhoneNumber(context);
        if (!TextUtils.isEmpty((CharSequence)lineNumber)) {
            req.setFrom(new EncodedStringValue(lineNumber));
        }
        for (String recipient : recipients) {
            req.addTo(new EncodedStringValue(recipient));
        }
        if (!TextUtils.isEmpty((CharSequence)subject)) {
            req.setSubject(new EncodedStringValue(subject));
        }
        req.setDate(System.currentTimeMillis() / 1000L);
        PduBody body = new PduBody();
        int size = 0;
        for (int i = 0; i < parts.size(); ++i) {
            MMSPart part = parts.get(i);
            size += Transaction.addTextPart(body, part, i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SmilXmlSerializer.serialize(SmilHelper.createSmilDocument(body), out);
        PduPart smilPart = new PduPart();
        smilPart.setContentId("smil".getBytes());
        smilPart.setContentLocation("smil.xml".getBytes());
        smilPart.setContentType("application/smil".getBytes());
        smilPart.setData(out.toByteArray());
        body.addPart(0, smilPart);
        req.setBody(body);
        req.setMessageSize(size);
        req.setMessageClass("personal".getBytes());
        req.setExpiry(604800L);
        try {
            req.setPriority(129);
            req.setDeliveryReport(129);
            req.setReadReport(129);
        }
        catch (InvalidHeaderValueException invalidHeaderValueException) {
            // empty catch block
        }
        return req;
    }

    private static int addTextPart(PduBody pb, MMSPart p, int id2) {
        String filename = p.Name;
        PduPart part = new PduPart();
        if (p.MimeType.startsWith("text")) {
            part.setCharset(106);
        }
        part.setContentType(p.MimeType.getBytes());
        part.setContentLocation(filename.getBytes());
        int index = filename.lastIndexOf(".");
        String contentId = index == -1 ? filename : filename.substring(0, index);
        part.setContentId(contentId.getBytes());
        part.setData(p.Data);
        pb.addPart(part);
        return part.getData().length;
    }

    private String[] splitByLength(String s, int chunkSize, boolean counter) {
        int i;
        int arraySize = (int)Math.ceil((double)s.length() / (double)chunkSize);
        String[] returnArray = new String[arraySize];
        int index = 0;
        for (i = 0; i < s.length(); i += chunkSize) {
            returnArray[index++] = s.length() - i < chunkSize ? s.substring(i) : s.substring(i, i + chunkSize);
        }
        if (counter && returnArray.length > 1) {
            for (i = 0; i < returnArray.length; ++i) {
                returnArray[i] = "(" + (i + 1) + "/" + returnArray.length + ") " + returnArray[i];
            }
        }
        return returnArray;
    }

    private static Uri insert(Context context, String[] to, MMSPart[] parts, String subject) {
        try {
            Uri destUri = Uri.parse((String)"content://mms");
            HashSet<String> recipients = new HashSet<String>();
            recipients.addAll(Arrays.asList(to));
            long thread_id = Utils.getOrCreateThreadId(context, recipients);
            ContentValues dummyValues = new ContentValues();
            dummyValues.put("thread_id", Long.valueOf(thread_id));
            dummyValues.put("body", " ");
            Uri dummySms = context.getContentResolver().insert(Uri.parse((String)"content://sms/sent"), dummyValues);
            long now = System.currentTimeMillis();
            ContentValues mmsValues = new ContentValues();
            mmsValues.put("thread_id", Long.valueOf(thread_id));
            mmsValues.put("date", Long.valueOf(now / 1000L));
            mmsValues.put("msg_box", Integer.valueOf(4));
            mmsValues.put("read", Boolean.valueOf(true));
            mmsValues.put("sub", subject != null ? subject : "");
            mmsValues.put("sub_cs", Integer.valueOf(106));
            mmsValues.put("ct_t", "application/vnd.wap.multipart.related");
            long imageBytes = 0L;
            for (MMSPart part : parts) {
                imageBytes += (long)part.Data.length;
            }
            mmsValues.put("exp", Long.valueOf(imageBytes));
            mmsValues.put("m_cls", "personal");
            mmsValues.put("m_type", Integer.valueOf(128));
            mmsValues.put("v", Integer.valueOf(19));
            mmsValues.put("pri", Integer.valueOf(129));
            mmsValues.put("tr_id", "T" + Long.toHexString(now));
            mmsValues.put("resp_st", Integer.valueOf(128));
            Uri res = context.getContentResolver().insert(destUri, mmsValues);
            String messageId = res.getLastPathSegment().trim();
            for (MMSPart part : parts) {
                if (part.MimeType.startsWith("image")) {
                    Transaction.createPartImage(context, messageId, part.Data, part.MimeType);
                    continue;
                }
                if (!part.MimeType.startsWith("text")) continue;
                Transaction.createPartText(context, messageId, new String(part.Data, "UTF-8"));
            }
            for (String addr : to) {
                Transaction.createAddr(context, messageId, addr);
            }
            context.getContentResolver().delete(dummySms, null, null);
            return res;
        }
        catch (Exception e) {
            Log.v((String)"sending_mms_library", (String)"still an error saving... :(");
            Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
            return null;
        }
    }

    private static Uri createPartImage(Context context, String id2, byte[] imageBytes, String mimeType) throws Exception {
        ContentValues mmsPartValue = new ContentValues();
        mmsPartValue.put("mid", id2);
        mmsPartValue.put("ct", mimeType);
        mmsPartValue.put("cid", "<" + System.currentTimeMillis() + ">");
        Uri partUri = Uri.parse((String)("content://mms/" + id2 + "/part"));
        Uri res = context.getContentResolver().insert(partUri, mmsPartValue);
        OutputStream os = context.getContentResolver().openOutputStream(res);
        ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
        byte[] buffer = new byte[256];
        int len = 0;
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        os.close();
        is.close();
        return res;
    }

    private static Uri createPartText(Context context, String id2, String text) throws Exception {
        ContentValues mmsPartValue = new ContentValues();
        mmsPartValue.put("mid", id2);
        mmsPartValue.put("ct", "text/plain");
        mmsPartValue.put("cid", "<" + System.currentTimeMillis() + ">");
        mmsPartValue.put("text", text);
        Uri partUri = Uri.parse((String)("content://mms/" + id2 + "/part"));
        Uri res = context.getContentResolver().insert(partUri, mmsPartValue);
        return res;
    }

    private static Uri createAddr(Context context, String id2, String addr) throws Exception {
        ContentValues addrValues = new ContentValues();
        addrValues.put("address", addr);
        addrValues.put("charset", "106");
        addrValues.put("type", Integer.valueOf(151));
        Uri addrUri = Uri.parse((String)("content://mms/" + id2 + "/addr"));
        Uri res = context.getContentResolver().insert(addrUri, addrValues);
        return res;
    }

    public boolean checkMMS(Message message) {
        return message.getImages().length != 0 || message.getParts().size() != 0 || settings.getSendLongAsMms() && Utils.getNumPages(settings, message.getText()) > settings.getSendLongAsMmsAfter() || message.getAddresses().length > 1 && settings.getGroup() || message.getSubject() != null;
    }

    static {
        NOTIFY_SMS_FAILURE = ".NOTIFY_SMS_FAILURE";
    }

    public static class MessageInfo {
        public long token;
        public Uri location;
        public byte[] bytes;
    }
}

