/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.provider.Telephony;
import android.util.Log;
import com.android.mms.service_alt.DownloadRequest;
import com.android.mms.service_alt.MmsConfig;
import com.android.mms.transaction.DownloadManager;
import com.android.mms.transaction.HttpUtils;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.AcknowledgeInd;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.NotificationInd;
import com.google.android.mms.pdu_alt.NotifyRespInd;
import com.google.android.mms.pdu_alt.PduComposer;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.RetrieveConf;
import com.google.android.mms.util_alt.SqliteWrapper;
import com.klinker.android.send_message.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MmsReceivedReceiver
extends BroadcastReceiver {
    private static final String TAG = "MmsReceivedReceiver";
    public static final String MMS_RECEIVED = "com.klinker.android.messaging.MMS_RECEIVED";
    public static final String EXTRA_FILE_PATH = "file_path";
    public static final String EXTRA_LOCATION_URL = "location_url";
    public static final String EXTRA_TRIGGER_PUSH = "trigger_push";
    public static final String EXTRA_URI = "notification_ind_uri";
    private static final String LOCATION_SELECTION = "m_type=? AND ct_l =?";
    private static final ExecutorService RECEIVE_NOTIFICATION_EXECUTOR = Executors.newSingleThreadExecutor();

    public MmscInformation getMmscInfoForReceptionAck() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        Log.v((String)TAG, (String)"MMS has finished downloading, persisting it to the database");
        String path = intent.getStringExtra(EXTRA_FILE_PATH);
        Log.v((String)TAG, (String)path);
        FileInputStream reader = null;
        try {
            File mDownloadFile = new File(path);
            int nBytes = (int)mDownloadFile.length();
            reader = new FileInputStream(mDownloadFile);
            byte[] response = new byte[nBytes];
            reader.read(response, 0, nBytes);
            List<CommonAsyncTask> tasks = this.getNotificationTask(context, intent, response);
            DownloadRequest.persist(context, response, new MmsConfig.Overridden(new MmsConfig(context), null), intent.getStringExtra(EXTRA_LOCATION_URL), Utils.getDefaultSubscriptionId(), null);
            Log.v((String)TAG, (String)"response saved successfully");
            Log.v((String)TAG, (String)("response length: " + response.length));
            mDownloadFile.delete();
            if (tasks != null) {
                Log.v((String)TAG, (String)"running the common async notifier for download");
                for (CommonAsyncTask task : tasks) {
                    task.executeOnExecutor(RECEIVE_NOTIFICATION_EXECUTOR, new Void[0]);
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"MMS received, file not found exception", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"MMS received, io exception", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"MMS received, io exception", (Throwable)e);
                }
            }
        }
        this.handleHttpError(context, intent);
        DownloadManager.finishDownload(intent.getStringExtra(EXTRA_LOCATION_URL));
    }

    private void handleHttpError(Context context, Intent intent) {
        int httpError = intent.getIntExtra("android.telephony.extra.MMS_HTTP_STATUS", 0);
        if (httpError == 404 || httpError == 400) {
            SqliteWrapper.delete(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, LOCATION_SELECTION, new String[]{Integer.toString(130), intent.getStringExtra(EXTRA_LOCATION_URL)});
        }
    }

    private static NotificationInd getNotificationInd(Context context, Intent intent) throws MmsException {
        return (NotificationInd)PduPersister.getPduPersister(context).load((Uri)intent.getParcelableExtra(EXTRA_URI));
    }

    private List<CommonAsyncTask> getNotificationTask(Context context, Intent intent, byte[] response) {
        if (response.length == 0) {
            Log.v((String)TAG, (String)"MmsReceivedReceiver.sendNotification blank response");
            return null;
        }
        if (this.getMmscInfoForReceptionAck() == null) {
            Log.v((String)TAG, (String)"No MMSC information set, so no notification tasks will be able to complete");
            return null;
        }
        GenericPdu pdu = new PduParser(response, new MmsConfig.Overridden(new MmsConfig(context), null).getSupportMmsContentDisposition()).parse();
        if (pdu == null || !(pdu instanceof RetrieveConf)) {
            Log.e((String)TAG, (String)"MmsReceivedReceiver.sendNotification failed to parse pdu");
            return null;
        }
        try {
            NotificationInd ind = MmsReceivedReceiver.getNotificationInd(context, intent);
            MmscInformation mmsc = this.getMmscInfoForReceptionAck();
            TransactionSettings transactionSettings = new TransactionSettings(mmsc.mmscUrl, mmsc.mmsProxy, mmsc.proxyPort);
            ArrayList<CommonAsyncTask> responseTasks = new ArrayList<CommonAsyncTask>();
            responseTasks.add(new AcknowledgeIndTask(context, ind, transactionSettings, (RetrieveConf)pdu));
            responseTasks.add(new NotifyRespTask(context, ind, transactionSettings));
            return responseTasks;
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"error", (Throwable)e);
            return null;
        }
    }

    public static class MmscInformation {
        String mmscUrl;
        String mmsProxy;
        int proxyPort;

        public MmscInformation(String mmscUrl, String mmsProxy, int proxyPort) {
            this.mmscUrl = mmscUrl;
            this.mmsProxy = mmsProxy;
            this.proxyPort = proxyPort;
        }
    }

    private static class AcknowledgeIndTask
    extends CommonAsyncTask {
        private final RetrieveConf mRetrieveConf;

        AcknowledgeIndTask(Context context, NotificationInd ind, TransactionSettings settings, RetrieveConf rc) {
            super(context, settings, ind);
            this.mRetrieveConf = rc;
        }

        protected Void doInBackground(Void ... params) {
            byte[] tranId = this.mRetrieveConf.getTransactionId();
            if (tranId != null) {
                Log.v((String)MmsReceivedReceiver.TAG, (String)("sending ACK to MMSC: " + this.mTransactionSettings.getMmscUrl()));
                AcknowledgeInd acknowledgeInd = null;
                try {
                    acknowledgeInd = new AcknowledgeInd(18, tranId);
                    String lineNumber = Utils.getMyPhoneNumber(this.mContext);
                    acknowledgeInd.setFrom(new EncodedStringValue(lineNumber));
                    if (com.android.mms.MmsConfig.getNotifyWapMMSC()) {
                        this.sendPdu(new PduComposer(this.mContext, acknowledgeInd).make(), this.mContentLocation);
                    } else {
                        this.sendPdu(new PduComposer(this.mContext, acknowledgeInd).make());
                    }
                }
                catch (InvalidHeaderValueException e) {
                    Log.e((String)MmsReceivedReceiver.TAG, (String)"error", (Throwable)e);
                }
                catch (MmsException e) {
                    Log.e((String)MmsReceivedReceiver.TAG, (String)"error", (Throwable)e);
                }
                catch (IOException e) {
                    Log.e((String)MmsReceivedReceiver.TAG, (String)"error", (Throwable)e);
                }
            }
            return null;
        }
    }

    private static class NotifyRespTask
    extends CommonAsyncTask {
        NotifyRespTask(Context context, NotificationInd ind, TransactionSettings settings) {
            super(context, settings, ind);
        }

        protected Void doInBackground(Void ... params) {
            NotifyRespInd notifyRespInd = null;
            try {
                notifyRespInd = new NotifyRespInd(18, this.mNotificationInd.getTransactionId(), 129);
                if (com.android.mms.MmsConfig.getNotifyWapMMSC()) {
                    this.sendPdu(new PduComposer(this.mContext, notifyRespInd).make(), this.mContentLocation);
                } else {
                    this.sendPdu(new PduComposer(this.mContext, notifyRespInd).make());
                }
            }
            catch (MmsException e) {
                Log.e((String)MmsReceivedReceiver.TAG, (String)"error", (Throwable)e);
            }
            catch (IOException e) {
                Log.e((String)MmsReceivedReceiver.TAG, (String)"error", (Throwable)e);
            }
            return null;
        }
    }

    private static abstract class CommonAsyncTask
    extends AsyncTask<Void, Void, Void> {
        protected final Context mContext;
        protected final TransactionSettings mTransactionSettings;
        final NotificationInd mNotificationInd;
        final String mContentLocation;

        CommonAsyncTask(Context context, TransactionSettings settings, NotificationInd ind) {
            this.mContext = context;
            this.mTransactionSettings = settings;
            this.mNotificationInd = ind;
            this.mContentLocation = new String(ind.getContentLocation());
        }

        byte[] sendPdu(byte[] pdu, String mmscUrl) throws IOException, MmsException {
            return this.sendPdu(-1L, pdu, mmscUrl);
        }

        byte[] sendPdu(byte[] pdu) throws IOException, MmsException {
            return this.sendPdu(-1L, pdu, this.mTransactionSettings.getMmscUrl());
        }

        private byte[] sendPdu(long token, byte[] pdu, String mmscUrl) throws IOException, MmsException {
            if (pdu == null) {
                throw new MmsException();
            }
            if (mmscUrl == null) {
                throw new IOException("Cannot establish route: mmscUrl is null");
            }
            if (Transaction.useWifi(this.mContext)) {
                return HttpUtils.httpConnection(this.mContext, token, mmscUrl, pdu, 1, false, null, 0);
            }
            Utils.ensureRouteToHost(this.mContext, mmscUrl, this.mTransactionSettings.getProxyAddress());
            return HttpUtils.httpConnection(this.mContext, token, mmscUrl, pdu, 1, this.mTransactionSettings.isProxySet(), this.mTransactionSettings.getProxyAddress(), this.mTransactionSettings.getProxyPort());
        }
    }
}

