/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.BroadcastUtils;
import com.klinker.android.send_message.StatusUpdatedReceiver;
import com.klinker.android.send_message.Transaction;

public abstract class SentReceiver
extends StatusUpdatedReceiver {
    @Override
    public final void updateInInternalDatabase(Context context, Intent intent, int resultCode) {
        Log.v((String)"sent_receiver", (String)"marking message as sent");
        Uri uri = this.getUri(intent);
        switch (resultCode) {
            case -1: {
                if (uri != null) {
                    try {
                        Log.v((String)"sent_receiver", (String)"using supplied uri");
                        ContentValues values = new ContentValues();
                        values.put("type", Integer.valueOf(2));
                        values.put("read", Integer.valueOf(1));
                        context.getContentResolver().update(uri, values, null, null);
                    }
                    catch (NullPointerException e) {
                        this.markFirstAsSent(context);
                    }
                    break;
                }
                this.markFirstAsSent(context);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (uri != null) {
                    Log.v((String)"sent_receiver", (String)"using supplied uri");
                    ContentValues values = new ContentValues();
                    values.put("type", Integer.valueOf(5));
                    values.put("read", Boolean.valueOf(true));
                    values.put("error_code", Integer.valueOf(resultCode));
                    context.getContentResolver().update(uri, values, null, null);
                } else {
                    Log.v((String)"sent_receiver", (String)"using first message");
                    Cursor query = context.getContentResolver().query(Uri.parse((String)"content://sms/outbox"), null, null, null, null);
                    if (query != null && query.moveToFirst()) {
                        String id2 = query.getString(query.getColumnIndex("_id"));
                        ContentValues values = new ContentValues();
                        values.put("type", Integer.valueOf(5));
                        values.put("read", Integer.valueOf(1));
                        values.put("error_code", Integer.valueOf(resultCode));
                        context.getContentResolver().update(Uri.parse((String)"content://sms/outbox"), values, "_id=" + id2, null);
                        query.close();
                    }
                }
                BroadcastUtils.sendExplicitBroadcast(context, new Intent(), Transaction.NOTIFY_SMS_FAILURE);
            }
        }
        BroadcastUtils.sendExplicitBroadcast(context, new Intent(), "com.klinker.android.send_message.REFRESH");
    }

    private Uri getUri(Intent intent) {
        Uri uri;
        try {
            uri = Uri.parse((String)intent.getStringExtra("message_uri"));
            if (uri.equals((Object)"")) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return uri;
    }

    private void markFirstAsSent(Context context) {
        Log.v((String)"sent_receiver", (String)"using first message");
        Cursor query = context.getContentResolver().query(Uri.parse((String)"content://sms/outbox"), null, null, null, null);
        if (query != null && query.moveToFirst()) {
            String id2 = query.getString(query.getColumnIndex("_id"));
            ContentValues values = new ContentValues();
            values.put("type", Integer.valueOf(2));
            values.put("read", Integer.valueOf(1));
            context.getContentResolver().update(Uri.parse((String)"content://sms/outbox"), values, "_id=" + id2, null);
            query.close();
        }
    }
}

